<?php
// Direct test of the products method
echo "<h1>Direct Products Test</h1>";

// Set up the environment
$_SERVER['REQUEST_METHOD'] = 'GET';
$_SERVER['REQUEST_URI'] = '/erp-ecom/products';
$_SERVER['HTTP_HOST'] = 'localhost';
$_SERVER['SCRIPT_NAME'] = '/erp-ecom/index.php';

// Start output buffering to capture any errors
ob_start();

try {
    // Load CodeIgniter
    require_once 'index.php';
    
    // Try to instantiate the controller directly
    $CI =& get_instance();
    $CI->load->database();
    
    // Test the products method
    echo "<h2>Testing products method directly</h2>";
    
    // Create a mock controller instance
    class TestWebsiteFrontend extends CI_Controller {
        public function __construct() {
            parent::__construct();
            $this->load->database();
        }
        
        public function test_products() {
            try {
                // Simple query test
                $this->db->select('id, description, rate');
                $this->db->from('tblitems');
                $this->db->where('rate >', 0);
                $this->db->where('id >', 10);
                $this->db->limit(5);
                $query = $this->db->get();
                $products = $query->result_array();
                
                echo "<h3>Database Query Test</h3>";
                echo "<p>Found " . count($products) . " products:</p>";
                
                foreach ($products as $product) {
                    echo "<div style='border: 1px solid #ccc; padding: 10px; margin: 5px;'>";
                    echo "<strong>" . htmlspecialchars($product['description']) . "</strong><br>";
                    echo "Price: $" . $product['rate'] . "<br>";
                    echo "ID: " . $product['id'];
                    echo "</div>";
                }
                
                return true;
            } catch (Exception $e) {
                echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
                return false;
            }
        }
    }
    
    $test = new TestWebsiteFrontend();
    $test->test_products();
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Fatal Error: " . $e->getMessage() . "</p>";
    echo "<p>Stack trace: " . $e->getTraceAsString() . "</p>";
}

$output = ob_get_clean();
echo $output;
?>

