<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Header Functionality - Honoré Bakery</title>
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
</head>
<body class="font-inter bg-gray-50">
    <?php include 'header_component.php'; ?>
    
    <main class="pt-8">
        <div class="max-w-4xl mx-auto px-4 py-16">
            <h1 class="text-3xl font-bold text-gray-900 mb-8">Header Functionality Test</h1>
            
            <div class="bg-white p-6 rounded-lg shadow-lg">
                <h2 class="text-xl font-semibold mb-4">Test Instructions:</h2>
                <ol class="list-decimal list-inside space-y-2 text-gray-700">
                    <li>Click the "SEARCH" button in the header - it should open a search dropdown</li>
                    <li>Click the cart icon (shopping bag) in the header - it should open the cart sidebar</li>
                    <li>Check the browser console (F12) for any JavaScript errors or debug messages</li>
                </ol>
                
                <div class="mt-6 p-4 bg-blue-50 rounded-lg">
                    <h3 class="font-semibold text-blue-900 mb-2">Debug Information:</h3>
                    <p class="text-blue-800 text-sm">Open browser console (F12) to see debug messages about search and cart functionality.</p>
                </div>
            </div>
        </div>
    </main>
    
    <?php include 'cart_component.php'; ?>
</body>
</html>
