<?php
// Simple test to debug the products page issue
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Testing basic functionality...\n";

// Test 1: Check if we can load CodeIgniter
try {
    require_once('index.php');
    echo "✓ CodeIgniter loaded\n";
} catch (Exception $e) {
    echo "✗ CodeIgniter error: " . $e->getMessage() . "\n";
    exit;
}

// Test 2: Check if we can create the controller
try {
    $CI =& get_instance();
    echo "✓ CI instance created\n";
} catch (Exception $e) {
    echo "✗ CI instance error: " . $e->getMessage() . "\n";
    exit;
}

// Test 3: Check if we can load the omni_sales_model
try {
    $CI->load->model('omni_sales_model');
    echo "✓ omni_sales_model loaded\n";
} catch (Exception $e) {
    echo "✗ omni_sales_model error: " . $e->getMessage() . "\n";
    exit;
}

// Test 4: Check if we can query the database
try {
    $CI->db->select('id, description, rate');
    $CI->db->from('tblitems');
    $CI->db->where('rate >', 0);
    $CI->db->limit(1);
    $query = $CI->db->get();
    $result = $query->result_array();
    echo "✓ Database query successful, found " . count($result) . " products\n";
} catch (Exception $e) {
    echo "✗ Database error: " . $e->getMessage() . "\n";
    exit;
}

// Test 5: Check if we can create the Website_frontend controller
try {
    $controller = new Website_frontend();
    echo "✓ Website_frontend controller created\n";
} catch (Exception $e) {
    echo "✗ Website_frontend controller error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
    exit;
}

// Test 6: Check if we can call the products method
try {
    $controller->products();
    echo "✓ products() method executed successfully\n";
} catch (Exception $e) {
    echo "✗ products() method error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
    exit;
}

echo "\nAll tests passed! The issue might be in the view file.\n";
?>