<?php
// Simple test to check if the website is accessible
echo "<h1>Website Access Test</h1>";
echo "<p>Current time: " . date('Y-m-d H:i:s') . "</p>";
echo "<p>PHP Version: " . phpversion() . "</p>";

// Test if we can access the main application
if (file_exists('index.php')) {
    echo "<p>✅ Main index.php file exists</p>";
} else {
    echo "<p>❌ Main index.php file not found</p>";
}

// Test if we can access the Website_frontend controller
if (file_exists('application/controllers/Website_frontend.php')) {
    echo "<p>✅ Website_frontend controller exists</p>";
} else {
    echo "<p>❌ Website_frontend controller not found</p>";
}

// Test if we can access the frontend views
if (file_exists('application/views/frontend/homepage.php')) {
    echo "<p>✅ Homepage view exists</p>";
} else {
    echo "<p>❌ Homepage view not found</p>";
}

if (file_exists('application/views/frontend/about.php')) {
    echo "<p>✅ About view exists</p>";
} else {
    echo "<p>❌ About view not found</p>";
}

if (file_exists('application/views/frontend/contact.php')) {
    echo "<p>✅ Contact view exists</p>";
} else {
    echo "<p>❌ Contact view not found</p>";
}

// Test if we can access the include files
if (file_exists('application/views/frontend/includes/header.php')) {
    echo "<p>✅ Header include exists</p>";
} else {
    echo "<p>❌ Header include not found</p>";
}

if (file_exists('application/views/frontend/includes/footer.php')) {
    echo "<p>✅ Footer include exists</p>";
} else {
    echo "<p>❌ Footer include not found</p>";
}

// Test routes configuration
if (file_exists('application/config/routes.php')) {
    echo "<p>✅ Routes configuration exists</p>";
    
    // Read routes file to check default controller
    $routes_content = file_get_contents('application/config/routes.php');
    if (strpos($routes_content, "website_frontend/homepage") !== false) {
        echo "<p>✅ Default controller is set to website_frontend/homepage</p>";
    } else {
        echo "<p>❌ Default controller not set to website_frontend/homepage</p>";
    }
} else {
    echo "<p>❌ Routes configuration not found</p>";
}

echo "<hr>";
echo "<h2>Test Links</h2>";
echo "<p><a href='index.php'>Test Main Index</a></p>";
echo "<p><a href='homepage'>Test Homepage Route</a></p>";
echo "<p><a href='about'>Test About Route</a></p>";
echo "<p><a href='contact'>Test Contact Route</a></p>";
echo "<p><a href='products'>Test Products Route</a></p>";
?>
