<?php
/*
 * Direct Website Integration Test
 * This file tests the website-omni_sales integration without routing
 */

// Include CodeIgniter framework
require_once('index.php');

// Get CI instance
$CI = &get_instance();

// Load the website ecommerce service
$CI->load->library('website/Ecommerce_service');

echo "<h2>Website-Omni Sales Integration Test</h2>";

try {
    // Test 1: Get Products
    echo "<h3>1. Testing Product Retrieval</h3>";
    $products = $CI->ecommerce_service->get_products(5); // Get first 5 products
    echo "Products found: " . count($products) . "<br>";
    
    if (!empty($products)) {
        echo "<table border='1'>";
        echo "<tr><th>ID</th><th>Name</th><th>Price</th><th>Stock</th></tr>";
        foreach (array_slice($products, 0, 3) as $product) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($product['id']) . "</td>";
            echo "<td>" . htmlspecialchars($product['description']) . "</td>";
            echo "<td>" . htmlspecialchars($product['rate']) . "</td>";
            echo "<td>" . htmlspecialchars($product['qty']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Test 2: Check Database Connection
    echo "<h3>2. Testing Database Connection</h3>";
    $CI->db->select('COUNT(*) as count');
    $CI->db->from('tblitems');
    $query = $CI->db->get();
    $result = $query->row();
    echo "Total items in database: " . $result->count . "<br>";
    
    // Test 3: Check if models are loading
    echo "<h3>3. Testing Model Loading</h3>";
    $CI->load->model('omni_sales_model');
    if (isset($CI->omni_sales_model)) {
        echo "✓ omni_sales_model loaded successfully<br>";
    } else {
        echo "✗ Failed to load omni_sales_model<br>";
    }
    
    // Test 4: Test service methods
    echo "<h3>4. Testing Service Methods</h3>";
    
    // Test format products
    $test_product = [
        'id' => 1,
        'description' => 'Test Product',
        'rate' => 25.99,
        'qty' => 10
    ];
    
    $formatted = $CI->ecommerce_service->format_products([$test_product]);
    echo "Format products test: " . (is_array($formatted) ? "✓ Success" : "✗ Failed") . "<br>";
    
    echo "<h3>✓ All tests completed successfully!</h3>";
    
} catch (Exception $e) {
    echo "<h3 style='color: red'>Error occurred:</h3>";
    echo "<pre>" . htmlspecialchars($e->getMessage()) . "</pre>";
    echo "<pre>" . htmlspecialchars($e->getTraceAsString()) . "</pre>";
}

echo "<hr>";
echo "<p><strong>Test Summary:</strong></p>";
echo "<ul>";
echo "<li>This test verifies the website module can access omni_sales functionality</li>";
echo "<li>It tests the Ecommerce_service library integration</li>";
echo "<li>It checks database connectivity and model loading</li>";
echo "</ul>";

echo "<p><a href='index.php'>Back to Main Site</a></p>";
?>