<?php
// Production Path Update Script
// This script updates all base paths from /erp-ecom/ to /releasepymnstpro/erp-ecom/

$files_to_update = [
    'header_component.php',
    'modern_footer_component.php',
    'cart_component.php',
    'modern_bakery_homepage.php',
    'modern_bakery_about.php',
    'modern_bakery_contact.php',
    'modern_bakery_products.php',
    'modern_bakery_faq.php',
    'modern_bakery_privacy.php',
    'modern_bakery_terms.php',
    'modern_bakery_refund.php',
    'modern_bakery_shipping.php'
];

$old_path = '/erp-ecom/';
$new_path = '/releasepymnstpro/erp-ecom/';

echo "Updating base paths for production...\n\n";

foreach ($files_to_update as $file) {
    if (file_exists($file)) {
        $content = file_get_contents($file);
        $updated_content = str_replace($old_path, $new_path, $content);
        
        if ($content !== $updated_content) {
            file_put_contents($file, $updated_content);
            echo "✓ Updated: $file\n";
        } else {
            echo "- No changes needed: $file\n";
        }
    } else {
        echo "✗ File not found: $file\n";
    }
}

echo "\nProduction path update complete!\n";
echo "Base path changed from '$old_path' to '$new_path'\n";
?>
