<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Website_frontend extends CI_Controller
{
    public function __construct()
    {
        parent::__construct();
    }

    public function homepage()
    {
        $data['title'] = 'Honoré Bakery - Fresh Artisan Breads & Pastries';
        $this->load->view('frontend/homepage', $data);
    }
    
    public function about()
    {
        $data['title'] = 'About Us - Honoré Bakery';
        $this->load->view('frontend/about', $data);
    }
    
    public function contact()
    {
        $data['title'] = 'Contact Us - Honoré Bakery';
        $this->load->view('frontend/contact', $data);
    }
    
    public function products()
    {
        $data['title'] = 'Our Products - Honoré Bakery';
        $data['page_title'] = 'Our Products';
        $data['products'] = [
            [
                'id' => 1,
                'name' => 'Chocolate Cake',
                'price' => 25.00,
                'image' => 'https://via.placeholder.com/300x200/8B4513/FFFFFF?text=Chocolate+Cake',
                'category' => 'Cakes',
                'description' => 'Rich chocolate cake made with premium ingredients',
                'rating' => 4.8,
                'reviews' => 150,
                'w_quantity' => 10
            ],
            [
                'id' => 2,
                'name' => 'Sourdough Bread',
                'price' => 8.50,
                'image' => 'https://via.placeholder.com/300x200/8B4513/FFFFFF?text=Sourdough+Bread',
                'category' => 'Breads',
                'description' => 'Traditional sourdough bread with crispy crust',
                'rating' => 4.9,
                'reviews' => 200,
                'w_quantity' => 15
            ],
            [
                'id' => 3,
                'name' => 'Vanilla Cookies',
                'price' => 12.00,
                'image' => 'https://via.placeholder.com/300x200/8B4513/FFFFFF?text=Vanilla+Cookies',
                'category' => 'Cookies',
                'description' => 'Delicious vanilla cookies with a hint of cinnamon',
                'rating' => 4.7,
                'reviews' => 120,
                'w_quantity' => 20
            ]
        ];
        $data['categories'] = ['All Products', 'Cakes', 'Breads', 'Cookies'];
        $data['base_currency'] = (object)['name' => 'USD', 'symbol' => '$'];
        $data['current_page'] = 1;
        $data['per_page'] = 20;
        $data['total_products'] = 3;
        $data['total_pages'] = 1;
        
        $this->load->view('frontend/products', $data);
    }
    
    public function page($slug = '')
    {
        $data['title'] = ucfirst($slug) . ' - Honoré Bakery';
        $this->load->view('frontend/page', $data);
    }
}

