<?php $this->load->view('frontend/includes/header'); ?>

    <!-- Page Content -->
    <div class="page-content">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="content-section">
                        <h1 class="page-title font-playfair"><?php echo isset($page_title) ? $page_title : 'Page'; ?></h1>
                        
                        <div class="page-body">
                            <?php echo isset($page_content) ? $page_content : 'No content available.'; ?>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <style>
        .page-content {
            padding: 100px 0 60px;
            min-height: 80vh;
        }
        
        .page-title {
            font-size: 3rem;
            font-weight: 700;
            color: var(--primary-color);
            margin-bottom: 2rem;
            text-align: center;
        }
        
        .content-section {
            background: white;
            padding: 60px 40px;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
            margin-bottom: 40px;
        }
        
        .page-body {
            font-size: 1.1rem;
            line-height: 1.8;
            color: var(--text-dark);
        }
        
        .page-body h1, .page-body h2, .page-body h3, .page-body h4, .page-body h5, .page-body h6 {
            color: var(--primary-color);
            margin-top: 2rem;
            margin-bottom: 1rem;
        }
        
        .page-body p {
            margin-bottom: 1.5rem;
        }
        
        .page-body ul, .page-body ol {
            margin-bottom: 1.5rem;
            padding-left: 2rem;
        }
        
        .page-body li {
            margin-bottom: 0.5rem;
        }
        
        .page-body strong {
            color: var(--primary-color);
            font-weight: 600;
        }
        
        .page-body a {
            color: var(--secondary-color);
            text-decoration: none;
            transition: color 0.3s ease;
        }
        
        .page-body a:hover {
            color: var(--primary-color);
            text-decoration: underline;
        }
    </style>

<?php $this->load->view('frontend/includes/footer'); ?>
