<!DOCTYPE html>
<html>
<head>
    <title><?php echo $title; ?></title>
</head>
<body>
    <h1><?php echo $page_title; ?></h1>
    <p>Products count: <?php echo count($products); ?></p>
    
    <?php if (!empty($products)): ?>
        <div style="display: grid; grid-template-columns: repeat(auto-fit, minmax(300px, 1fr)); gap: 20px;">
            <?php foreach ($products as $product): ?>
                <div style="border: 1px solid #ccc; padding: 20px; border-radius: 10px;">
                    <img src="<?php echo $product['image']; ?>" alt="<?php echo $product['name']; ?>" style="width: 100%; height: 200px; object-fit: cover;">
                    <h3><?php echo $product['name']; ?></h3>
                    <p><?php echo $product['description']; ?></p>
                    <p><strong>Price: $<?php echo number_format($product['price'], 2); ?></strong></p>
                    <p>Category: <?php echo $product['category']; ?></p>
                    <p>Rating: <?php echo $product['rating']; ?>/5 (<?php echo $product['reviews']; ?> reviews)</p>
                    <p>Stock: <?php echo $product['w_quantity']; ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    <?php else: ?>
        <p>No products found.</p>
    <?php endif; ?>
</body>
</html>

