<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - Honoré Bakery</title>
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #D2691E;
            --accent-color: #F4A460;
            --text-dark: #2C1810;
            --text-light: #8B7355;
            --bg-light: #FFF8DC;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: "Open Sans", Arial, sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
            background: var(--bg-light);
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
        }
        
        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px;
        }
        
        .logo {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            list-style: none;
        }
        
        .nav-links li {
            margin: 0 20px;
        }
        
        .nav-links a {
            color: var(--text-dark);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .nav-links a:hover {
            color: var(--primary-color);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .hero {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 120px 0 80px;
            text-align: center;
        }
        
        .hero h1 {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        .content {
            padding: 80px 0;
            background: white;
        }
        
        .contact-grid {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 60px;
            margin-top: 40px;
        }
        
        .contact-info {
            background: #f9f9f9;
            padding: 40px;
            border-radius: 15px;
        }
        
        .contact-info h3 {
            color: var(--primary-color);
            margin-bottom: 20px;
        }
        
        .contact-info p {
            margin-bottom: 15px;
            font-size: 1.1rem;
        }
        
        .form-group {
            margin-bottom: 20px;
        }
        
        .form-group label {
            display: block;
            margin-bottom: 5px;
            font-weight: 600;
            color: var(--primary-color);
        }
        
        .form-group input,
        .form-group textarea {
            width: 100%;
            padding: 15px;
            border: 2px solid #e9ecef;
            border-radius: 10px;
            font-size: 1rem;
            transition: border-color 0.3s;
        }
        
        .form-group input:focus,
        .form-group textarea:focus {
            outline: none;
            border-color: var(--primary-color);
        }
        
        .btn {
            background: var(--primary-color);
            color: white;
            padding: 15px 30px;
            border: none;
            border-radius: 50px;
            font-weight: 600;
            cursor: pointer;
            transition: all 0.3s;
        }
        
        .btn:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 40px 0;
            text-align: center;
        }
        
        @media (max-width: 768px) {
            .contact-grid {
                grid-template-columns: 1fr;
                gap: 30px;
            }
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <a href="bakery_homepage.php" class="logo">Honoré Bakery</a>
            <ul class="nav-links">
                <li><a href="bakery_homepage.php">Home</a></li>
                <li><a href="bakery_about.php">About</a></li>
                <li><a href="bakery_contact.php">Contact</a></li>
                <li><a href="bakery_products.php">Products</a></li>
            </ul>
        </div>
    </nav>

    <section class="hero">
        <div class="container">
            <h1>Contact Us</h1>
            <p>We'd love to hear from you! Visit us, call us, or send us a message.</p>
        </div>
    </section>

    <section class="content">
        <div class="container">
            <div class="contact-grid">
                <div class="contact-info">
                    <h3>Visit Us</h3>
                    <p><strong>Address:</strong><br>123 Baker Street<br>Downtown District<br>City, State 12345</p>
                    
                    <p><strong>Phone:</strong><br>(555) 123-BAKE<br>(555) 123-2253</p>
                    
                    <p><strong>Email:</strong><br>hello@honorebakery.com<br>orders@honorebakery.com</p>
                    
                    <h3>Store Hours</h3>
                    <p><strong>Monday - Friday:</strong><br>6:00 AM - 8:00 PM</p>
                    <p><strong>Saturday:</strong><br>7:00 AM - 7:00 PM</p>
                    <p><strong>Sunday:</strong><br>8:00 AM - 6:00 PM</p>
                </div>
                
                <div>
                    <h3>Send us a Message</h3>
                    <form>
                        <div class="form-group">
                            <label for="name">Your Name</label>
                            <input type="text" id="name" name="name" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="email">Email Address</label>
                            <input type="email" id="email" name="email" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="phone">Phone Number</label>
                            <input type="tel" id="phone" name="phone">
                        </div>
                        
                        <div class="form-group">
                            <label for="subject">Subject</label>
                            <input type="text" id="subject" name="subject" required>
                        </div>
                        
                        <div class="form-group">
                            <label for="message">Message</label>
                            <textarea id="message" name="message" rows="5" required></textarea>
                        </div>
                        
                        <button type="submit" class="btn">Send Message</button>
                    </form>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <h3>Honoré Bakery</h3>
            <p>123 Baker Street, Downtown | (555) 123-BAKE | hello@honorebakery.com</p>
            <p>&copy; 2024 Honoré Bakery. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>