<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Our Products - Honoré Bakery</title>
    <style>
        :root {
            --primary-color: #8B4513;
            --secondary-color: #D2691E;
            --accent-color: #F4A460;
            --text-dark: #2C1810;
            --text-light: #8B7355;
            --bg-light: #FFF8DC;
        }
        
        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }
        
        body {
            font-family: "Open Sans", Arial, sans-serif;
            line-height: 1.6;
            color: var(--text-dark);
            background: var(--bg-light);
        }
        
        .navbar {
            background: rgba(255, 255, 255, 0.95);
            padding: 15px 0;
            box-shadow: 0 2px 10px rgba(0,0,0,0.1);
            position: fixed;
            width: 100%;
            top: 0;
            z-index: 1000;
        }
        
        .nav-container {
            max-width: 1200px;
            margin: 0 auto;
            display: flex;
            justify-content: space-between;
            align-items: center;
            padding: 0 20px;
        }
        
        .logo {
            font-size: 2rem;
            font-weight: bold;
            color: var(--primary-color);
            text-decoration: none;
        }
        
        .nav-links {
            display: flex;
            list-style: none;
        }
        
        .nav-links li {
            margin: 0 20px;
        }
        
        .nav-links a {
            color: var(--text-dark);
            text-decoration: none;
            font-weight: 500;
            transition: color 0.3s;
        }
        
        .nav-links a:hover {
            color: var(--primary-color);
        }
        
        .container {
            max-width: 1200px;
            margin: 0 auto;
            padding: 0 20px;
        }
        
        .hero {
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--secondary-color) 100%);
            color: white;
            padding: 120px 0 80px;
            text-align: center;
        }
        
        .hero h1 {
            font-size: 4rem;
            margin-bottom: 20px;
        }
        
        .content {
            padding: 80px 0;
            background: white;
        }
        
        .product-grid {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(350px, 1fr));
            gap: 40px;
            margin-top: 40px;
        }
        
        .product-card {
            background: white;
            border-radius: 20px;
            padding: 40px;
            box-shadow: 0 15px 40px rgba(0,0,0,0.1);
            text-align: center;
            transition: transform 0.3s;
            border: 1px solid rgba(139, 69, 19, 0.1);
        }
        
        .product-card:hover {
            transform: translateY(-10px);
        }
        
        .product-icon {
            font-size: 5rem;
            margin-bottom: 20px;
        }
        
        .product-title {
            font-size: 1.8rem;
            color: var(--primary-color);
            margin-bottom: 15px;
            font-weight: 700;
        }
        
        .product-description {
            color: var(--text-light);
            margin-bottom: 20px;
            line-height: 1.6;
        }
        
        .product-price {
            font-size: 2rem;
            color: var(--secondary-color);
            font-weight: bold;
            margin-bottom: 25px;
        }
        
        .btn {
            background: var(--primary-color);
            color: white;
            padding: 15px 30px;
            text-decoration: none;
            border-radius: 50px;
            font-weight: 600;
            display: inline-block;
            transition: all 0.3s;
        }
        
        .btn:hover {
            background: var(--secondary-color);
            transform: translateY(-2px);
        }
        
        .footer {
            background: var(--primary-color);
            color: white;
            padding: 40px 0;
            text-align: center;
        }
    </style>
</head>
<body>
    <nav class="navbar">
        <div class="nav-container">
            <a href="bakery_homepage.php" class="logo">Honoré Bakery</a>
            <ul class="nav-links">
                <li><a href="bakery_homepage.php">Home</a></li>
                <li><a href="bakery_about.php">About</a></li>
                <li><a href="bakery_contact.php">Contact</a></li>
                <li><a href="bakery_products.php">Products</a></li>
            </ul>
        </div>
    </nav>

    <section class="hero">
        <div class="container">
            <h1>Our Products</h1>
            <p>Handcrafted with love, tradition, and the finest ingredients</p>
        </div>
    </section>

    <section class="content">
        <div class="container">
            <div class="product-grid">
                <div class="product-card">
                    <div class="product-icon">🍞</div>
                    <h3 class="product-title">Artisan Sourdough</h3>
                    <p class="product-description">Traditional sourdough bread with a perfect crust and tangy flavor, fermented for 24 hours using our secret starter culture.</p>
                    <div class="product-price">$8.99</div>
                    <a href="bakery_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🥐</div>
                    <h3 class="product-title">Chocolate Croissants</h3>
                    <p class="product-description">Buttery, flaky croissants filled with rich Belgian chocolate, baked fresh every morning using traditional French techniques.</p>
                    <div class="product-price">$4.50</div>
                    <a href="bakery_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🧁</div>
                    <h3 class="product-title">French Macarons</h3>
                    <p class="product-description">Delicate French macarons in 6 different flavors, perfect for special occasions and elegant gatherings.</p>
                    <div class="product-price">$18.99</div>
                    <a href="bakery_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🍪</div>
                    <h3 class="product-title">Cinnamon Rolls</h3>
                    <p class="product-description">Soft, gooey cinnamon rolls with cream cheese frosting, made with our secret recipe.</p>
                    <div class="product-price">$6.99</div>
                    <a href="bakery_contact.php" class="btn">Order Now</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">🎂</div>
                    <h3 class="product-title">Custom Cakes</h3>
                    <p class="product-description">Beautiful custom cakes for birthdays, weddings, and special celebrations.</p>
                    <div class="product-price">From $45</div>
                    <a href="bakery_contact.php" class="btn">Order Custom</a>
                </div>
                
                <div class="product-card">
                    <div class="product-icon">☕</div>
                    <h3 class="product-title">Fresh Coffee</h3>
                    <p class="product-description">Premium coffee beans roasted daily, paired perfectly with our baked goods.</p>
                    <div class="product-price">$3.50</div>
                    <a href="bakery_contact.php" class="btn">Order Now</a>
                </div>
            </div>
        </div>
    </section>

    <footer class="footer">
        <div class="container">
            <h3>Honoré Bakery</h3>
            <p>123 Baker Street, Downtown | (555) 123-BAKE | hello@honorebakery.com</p>
            <p>&copy; 2024 Honoré Bakery. All rights reserved.</p>
        </div>
    </footer>
</body>
</html>