    <!-- Shopping Cart Sidebar -->
    <div id="cart-sidebar" class="fixed top-0 right-0 h-full w-96 bg-white shadow-2xl transform translate-x-full transition-transform duration-300 z-50">
        <div class="flex flex-col h-full">
            <!-- Cart Header -->
            <div class="flex items-center justify-between p-6 border-b">
                <h3 class="text-xl font-semibold">Shopping Cart</h3>
                <button id="cart-close" class="text-gray-500 hover:text-gray-700">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
            
            <!-- Cart Items -->
            <div class="flex-1 overflow-y-auto custom-scrollbar p-6">
                <div id="cart-items" class="space-y-4">
                    <!-- Cart items will be dynamically added here -->
                </div>
                
                <!-- Empty Cart Message -->
                <div id="empty-cart" class="text-center py-12">
                    <i class="fas fa-shopping-cart text-4xl text-gray-300 mb-4"></i>
                    <p class="text-gray-500">Your cart is currently empty</p>
                </div>
            </div>
            
            <!-- Cart Footer -->
            <div class="border-t p-6">
                <div class="flex justify-between items-center mb-4">
                    <span class="text-lg font-semibold">Subtotal:</span>
                    <span id="cart-total" class="text-xl font-bold text-amber-600">₹0</span>
                </div>
                <button class="w-full bg-amber-600 hover:bg-amber-700 text-white py-3 rounded-lg font-semibold transition-colors">
                    Checkout
                </button>
            </div>
        </div>
    </div>

    <!-- Cart Overlay -->
    <div id="cart-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden"></div>

    <!-- Cart JavaScript -->
    <script>
        // Cart functionality
        class CartManager {
            constructor() {
                this.cart = JSON.parse(localStorage.getItem('cart')) || [];
                this.init();
            }
            
            init() {
                this.initCart();
                this.updateCartUI();
            }
            
            initCart() {
                const cartToggle = document.getElementById('cart-toggle');
                const cartSidebar = document.getElementById('cart-sidebar');
                const cartClose = document.getElementById('cart-close');
                const cartOverlay = document.getElementById('cart-overlay');
                
                if (cartToggle && cartSidebar && cartClose && cartOverlay) {
                    cartToggle.addEventListener('click', (e) => {
                        e.preventDefault();
                        cartSidebar.classList.remove('translate-x-full');
                        cartOverlay.classList.remove('hidden');
                        document.body.style.overflow = 'hidden';
                    });
                    
                    cartClose.addEventListener('click', () => {
                        cartSidebar.classList.add('translate-x-full');
                        cartOverlay.classList.add('hidden');
                        document.body.style.overflow = 'auto';
                    });
                    
                    cartOverlay.addEventListener('click', () => {
                        cartSidebar.classList.add('translate-x-full');
                        cartOverlay.classList.add('hidden');
                        document.body.style.overflow = 'auto';
                    });
                } else {
                    // Fallback: try to add click listener to cart toggle even if other elements are missing
                    if (cartToggle) {
                        cartToggle.addEventListener('click', (e) => {
                            e.preventDefault();
                        });
                    }
                }
                
                // Add to cart functionality - improved event delegation
                document.addEventListener('click', (e) => {
                    // Check if the clicked element or its parent has the add-to-cart class
                    const addToCartButton = e.target.closest('.add-to-cart');
                    if (addToCartButton) {
                        console.log('Add to cart button clicked!', addToCartButton);
                        const productId = addToCartButton.dataset.productId;
                        console.log('Product ID:', productId);
                        this.addToCart(productId);
                    }
                });
            }
            
            addToCart(productId) {
                // Mock product data - in real app, this would come from API
                const products = {
                    // Homepage products (numeric IDs)
                    '1': { id: '1', name: 'Artisan Sourdough Bread', price: 450, image: 'fas fa-bread-slice', category: 'bread' },
                    '2': { id: '2', name: 'Chocolate Croissants', price: 320, image: 'fas fa-cookie-bite', category: 'pastries' },
                    '3': { id: '3', name: 'French Macarons', price: 1899, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '4': { id: '4', name: 'Sun Drenched Bouquet', price: 760, image: 'fas fa-seedling', category: 'flowers' },
                    '5': { id: '5', name: 'Chocolate Chip Cookies', price: 280, image: 'fas fa-cookie-bite', category: 'cookies' },
                    '6': { id: '6', name: 'Vanilla Cupcakes', price: 420, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '7': { id: '7', name: 'Whole Wheat Bread', price: 380, image: 'fas fa-bread-slice', category: 'bread' },
                    '8': { id: '8', name: 'Strawberry Tart', price: 650, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '9': { id: '9', name: 'Lavender Bouquet', price: 890, image: 'fas fa-seedling', category: 'flowers' },
                    '10': { id: '10', name: 'Cinnamon Rolls', price: 350, image: 'fas fa-cookie-bite', category: 'pastries' },
                    '11': { id: '11', name: 'Banana Bread', price: 320, image: 'fas fa-bread-slice', category: 'bread' },
                    '12': { id: '12', name: 'Red Velvet Cake', price: 1200, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '13': { id: '13', name: 'Mixed Berry Tart', price: 580, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '14': { id: '14', name: 'Almond Croissants', price: 340, image: 'fas fa-cookie-bite', category: 'pastries' },
                    '15': { id: '15', name: 'Rose Bouquet', price: 950, image: 'fas fa-seedling', category: 'flowers' },
                    '16': { id: '16', name: 'Oatmeal Cookies', price: 260, image: 'fas fa-cookie-bite', category: 'cookies' },
                    '17': { id: '17', name: 'Carrot Cake', price: 780, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '18': { id: '18', name: 'Tulip Bouquet', price: 680, image: 'fas fa-seedling', category: 'flowers' },
                    '19': { id: '19', name: 'Sourdough Rolls', price: 290, image: 'fas fa-bread-slice', category: 'bread' },
                    '20': { id: '20', name: 'Chocolate Muffins', price: 380, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '21': { id: '21', name: 'Lemon Tart', price: 520, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '22': { id: '22', name: 'Peach Cobbler', price: 450, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '23': { id: '23', name: 'Apple Pie', price: 680, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '24': { id: '24', name: 'Blueberry Scones', price: 320, image: 'fas fa-cookie-bite', category: 'pastries' },
                    '25': { id: '25', name: 'Cherry Blossom Bouquet', price: 1200, image: 'fas fa-seedling', category: 'flowers' },
                    '26': { id: '26', name: 'Pumpkin Bread', price: 380, image: 'fas fa-bread-slice', category: 'bread' },
                    '27': { id: '27', name: 'Tiramisu', price: 890, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '28': { id: '28', name: 'Cheesecake', price: 750, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '29': { id: '29', name: 'Eclair', price: 420, image: 'fas fa-cookie-bite', category: 'pastries' },
                    '30': { id: '30', name: 'Sunflower Bouquet', price: 650, image: 'fas fa-seedling', category: 'flowers' },
                    '31': { id: '31', name: 'Bagels', price: 280, image: 'fas fa-bread-slice', category: 'bread' },
                    '32': { id: '32', name: 'Donuts', price: 320, image: 'fas fa-cookie-bite', category: 'pastries' },
                    '33': { id: '33', name: 'Cupcakes', price: 350, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '34': { id: '34', name: 'Orchid Bouquet', price: 1500, image: 'fas fa-seedling', category: 'flowers' },
                    '35': { id: '35', name: 'Pretzels', price: 240, image: 'fas fa-bread-slice', category: 'bread' },
                    '36': { id: '36', name: 'Danish Pastry', price: 380, image: 'fas fa-cookie-bite', category: 'pastries' },
                    '37': { id: '37', name: 'Fruit Tart', price: 580, image: 'fas fa-birthday-cake', category: 'cakes' },
                    '38': { id: '38', name: 'Lily Bouquet', price: 850, image: 'fas fa-seedling', category: 'flowers' },
                    '39': { id: '39', name: 'Focaccia', price: 420, image: 'fas fa-bread-slice', category: 'bread' },
                    '40': { id: '40', name: 'Cannoli', price: 450, image: 'fas fa-cookie-bite', category: 'pastries' },
                    
                    // Products page products (string IDs)
                    'artisan-sourdough': { id: 'artisan-sourdough', name: 'Artisan Sourdough', price: 450, image: 'fas fa-bread-slice', category: 'bread' },
                    'chocolate-croissants': { id: 'chocolate-croissants', name: 'Chocolate Croissants', price: 320, image: 'fas fa-cookie-bite', category: 'pastries' },
                    'french-macarons': { id: 'french-macarons', name: 'French Macarons', price: 1899, image: 'fas fa-birthday-cake', category: 'cakes' },
                    'sun-drenched-bouquet': { id: 'sun-drenched-bouquet', name: 'Sun Drenched Bouquet', price: 760, image: 'fas fa-seedling', category: 'flowers' },
                    'chocolate-chip-cookies': { id: 'chocolate-chip-cookies', name: 'Chocolate Chip Cookies', price: 280, image: 'fas fa-cookie-bite', category: 'cookies' },
                    'vanilla-cupcakes': { id: 'vanilla-cupcakes', name: 'Vanilla Cupcakes', price: 420, image: 'fas fa-birthday-cake', category: 'cakes' },
                    'whole-wheat-bread': { id: 'whole-wheat-bread', name: 'Whole Wheat Bread', price: 380, image: 'fas fa-bread-slice', category: 'bread' },
                    'strawberry-tart': { id: 'strawberry-tart', name: 'Strawberry Tart', price: 650, image: 'fas fa-birthday-cake', category: 'cakes' },
                    'lavender-bouquet': { id: 'lavender-bouquet', name: 'Lavender Bouquet', price: 890, image: 'fas fa-seedling', category: 'flowers' },
                    'cinnamon-rolls': { id: 'cinnamon-rolls', name: 'Cinnamon Rolls', price: 350, image: 'fas fa-cookie-bite', category: 'pastries' }
                };
                
                const product = products[productId];
                if (!product) {
                    console.log('Product not found for ID:', productId);
                    return;
                }
                
                console.log('Adding product to cart:', product);
                
                const existingItem = this.cart.find(item => item.id === productId);
                if (existingItem) {
                    existingItem.quantity += 1;
                } else {
                    this.cart.push({
                        id: productId,
                        name: product.name,
                        price: product.price,
                        image: product.image,
                        quantity: 1
                    });
                }
                
                this.saveCart();
                this.updateCartUI();
                this.showNotification(`${product.name} added to cart!`);
            }
            
            removeFromCart(productId) {
                this.cart = this.cart.filter(item => item.id !== productId);
                this.saveCart();
                this.updateCartUI();
            }
            
            updateQuantity(productId, newQuantity) {
                const item = this.cart.find(item => item.id === productId);
                if (item) {
                    if (newQuantity <= 0) {
                        this.removeFromCart(productId);
                    } else {
                        item.quantity = newQuantity;
                        this.saveCart();
                        this.updateCartUI();
                    }
                }
            }
            
            saveCart() {
                localStorage.setItem('cart', JSON.stringify(this.cart));
            }
            
            updateCartUI() {
                const cartItems = document.getElementById('cart-items');
                const emptyCart = document.getElementById('empty-cart');
                const cartTotal = document.getElementById('cart-total');
                const cartCount = document.getElementById('cart-count');
                
                // Always update header cart count, even if cart sidebar doesn't exist
                if (cartCount) {
                    const totalItems = this.cart.reduce((sum, item) => sum + item.quantity, 0);
                    cartCount.textContent = totalItems;
                }
                
                // Only update cart sidebar if it exists
                if (!cartItems || !emptyCart || !cartTotal) return;
                
                if (this.cart.length === 0) {
                    cartItems.innerHTML = '';
                    emptyCart.style.display = 'block';
                    cartTotal.textContent = '₹0';
                } else {
                    emptyCart.style.display = 'none';
                    
                    cartItems.innerHTML = this.cart.map(item => `
                        <div class="flex items-center space-x-4 p-4 bg-gray-50 rounded-lg">
                            <div class="w-12 h-12 bg-gradient-to-br from-amber-500 to-amber-700 rounded-full flex items-center justify-center">
                                <i class="${item.image} text-white"></i>
                            </div>
                            <div class="flex-1">
                                <h4 class="font-semibold text-gray-900">${item.name}</h4>
                                <p class="text-amber-600 font-semibold">₹${item.price}</p>
                            </div>
                            <div class="flex items-center space-x-2">
                                <button onclick="cartManager.updateQuantity('${item.id}', ${item.quantity - 1})" class="w-8 h-8 bg-gray-200 rounded-full flex items-center justify-center hover:bg-gray-300">
                                    <i class="fas fa-minus text-xs"></i>
                                </button>
                                <span class="w-8 text-center font-semibold">${item.quantity}</span>
                                <button onclick="cartManager.updateQuantity('${item.id}', ${item.quantity + 1})" class="w-8 h-8 bg-gray-200 rounded-full flex items-center justify-center hover:bg-gray-300">
                                    <i class="fas fa-plus text-xs"></i>
                                </button>
                                <button onclick="cartManager.removeFromCart('${item.id}')" class="w-8 h-8 bg-red-100 rounded-full flex items-center justify-center hover:bg-red-200 ml-2">
                                    <i class="fas fa-trash text-red-600 text-xs"></i>
                                </button>
                            </div>
                        </div>
                    `).join('');
                    
                    const total = this.cart.reduce((sum, item) => sum + (item.price * item.quantity), 0);
                    cartTotal.textContent = `₹${total}`;
                }
            }
            
            showNotification(message) {
                const notification = document.createElement('div');
                notification.className = 'fixed top-4 right-4 bg-green-500 text-white px-6 py-3 rounded-lg shadow-lg z-50 transform translate-x-full transition-transform duration-300';
                notification.innerHTML = `
                    <div class="flex items-center">
                        <i class="fas fa-check-circle mr-2"></i>
                        <span>${message}</span>
                    </div>
                `;
                
                document.body.appendChild(notification);
                
                // Animate in
                setTimeout(() => {
                    notification.classList.remove('translate-x-full');
                }, 100);
                
                // Animate out
                setTimeout(() => {
                    notification.classList.add('translate-x-full');
                    setTimeout(() => {
                        document.body.removeChild(notification);
                    }, 300);
                }, 2000);
            }
        }
        
        // Initialize cart manager when DOM is ready
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Cart component loading...');
            
            // Wait a bit for all components to load
            setTimeout(() => {
                const cartManager = new CartManager();
                console.log('Cart manager initialized:', cartManager);
            }, 100);
        });
    </script>
