<?php
// Check what products are available in omni_sales
error_reporting(E_ALL);
ini_set('display_errors', 1);

try {
    require_once('index.php');
    $CI =& get_instance();
    $CI->load->model('omni_sales_model');
    
    echo "Checking omni_sales products...\n";
    
    // Test the exact same method we're using
    $data_product = $CI->omni_sales_model->get_list_product_by_group(2, 0, 0, '', 0, 20);
    
    echo "Products found: " . count($data_product['list_product']) . "\n";
    
    if (count($data_product['list_product']) > 0) {
        echo "First few products:\n";
        for ($i = 0; $i < min(5, count($data_product['list_product'])); $i++) {
            $item = $data_product['list_product'][$i];
            echo "- ID: {$item['id']}, Name: {$item['description']}\n";
        }
    } else {
        echo "No products found in omni_sales channel 2\n";
        
        // Check what channels exist
        echo "\nChecking available channels...\n";
        $CI->db->select('id, channel_name');
        $CI->db->from('tblsales_channel');
        $query = $CI->db->get();
        $channels = $query->result_array();
        
        foreach ($channels as $channel) {
            echo "Channel ID: {$channel['id']}, Name: {$channel['channel_name']}\n";
        }
        
        // Check if products are in tblitems
        echo "\nChecking tblitems...\n";
        $CI->db->select('id, description, rate');
        $CI->db->from('tblitems');
        $CI->db->where('rate >', 0);
        $CI->db->limit(5);
        $query = $CI->db->get();
        $items = $query->result_array();
        
        echo "Items in tblitems: " . count($items) . "\n";
        foreach ($items as $item) {
            echo "- ID: {$item['id']}, Name: {$item['description']}, Rate: {$item['rate']}\n";
        }
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}

echo "\nCheck completed.\n";
?>

