<?php
// Debug script to check product images
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'erp_ecom';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "=== Checking tblfiles table ===\n";
    $stmt = $pdo->prepare('SELECT rel_id, file_name, rel_type FROM tblfiles WHERE rel_type = "commodity_item_file" LIMIT 5');
    $stmt->execute();
    $files = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    if (count($files) > 0) {
        foreach ($files as $file) {
            echo "Product ID: {$file['rel_id']}, File: {$file['file_name']}, Type: {$file['rel_type']}\n";
        }
    } else {
        echo "No files found with commodity_item_file\n";
    }
    
    echo "\n=== Checking all rel_types ===\n";
    $stmt = $pdo->prepare('SELECT DISTINCT rel_type FROM tblfiles');
    $stmt->execute();
    $rel_types = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    foreach ($rel_types as $type) {
        echo "- {$type['rel_type']}\n";
    }
    
    echo "\n=== Checking product images in manufacturing directory ===\n";
    $manufacturing_path = 'modules/manufacturing/uploads/products/';
    if (is_dir($manufacturing_path)) {
        $dirs = scandir($manufacturing_path);
        $count = 0;
        foreach ($dirs as $dir) {
            if ($dir != '.' && $dir != '..' && is_numeric($dir) && $count < 5) {
                echo "Product directory: $dir\n";
                $files_in_dir = scandir($manufacturing_path . $dir);
                foreach ($files_in_dir as $file) {
                    if ($file != '.' && $file != '..' && $file != 'index.html') {
                        echo "  - $file\n";
                    }
                }
                $count++;
            }
        }
    }
    
} catch (PDOException $e) {
    echo 'Database error: ' . $e->getMessage();
}
?>

