<?php
// Debug script to check what products are in the database
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Debugging products from database...\n";

try {
    // Load CodeIgniter
    require_once('index.php');
    $CI =& get_instance();
    
    // Test database connection
    $CI->db->select('id, description, long_description, rate, sku_code, group_id');
    $CI->db->from('tblitems');
    $CI->db->where('rate >', 0);
    $CI->db->where('id >', 10);
    $CI->db->limit(10);
    $query = $CI->db->get();
    $products = $query->result_array();
    
    echo "Found " . count($products) . " products in database:\n";
    foreach ($products as $product) {
        echo "- ID: {$product['id']}, Name: {$product['description']}, Price: {$product['rate']}\n";
    }
    
    // Test omni_sales_model
    $CI->load->model('omni_sales_model');
    echo "\nTesting omni_sales_model...\n";
    
    if (count($products) > 0) {
        $first_product = $products[0];
        $image = $CI->omni_sales_model->get_image_items($first_product['id']);
        echo "Image for product {$first_product['id']}: $image\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}

echo "\nDebug completed.\n";
?>

