<?php
// Debug script to check products query
$host = 'localhost';
$username = 'root';
$password = '';
$database = 'erp_ecom';

try {
    $pdo = new PDO("mysql:host=$host;dbname=$database", $username, $password);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<h2>Products Query Debug</h2>";
    
    // Test 1: All products with rate > 0
    echo "<h3>1. All products with rate > 0:</h3>";
    $stmt = $pdo->query("SELECT id, description, rate FROM tblitems WHERE rate > 0 ORDER BY id ASC LIMIT 20");
    $all_products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "<p>Found " . count($all_products) . " products</p>";
    
    if (!empty($all_products)) {
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr style='background: #f0f0f0;'><th>ID</th><th>Description</th><th>Rate</th></tr>";
        foreach ($all_products as $product) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($product['id']) . "</td>";
            echo "<td>" . htmlspecialchars($product['description']) . "</td>";
            echo "<td>" . htmlspecialchars($product['rate']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Test 2: Products with id > 10
    echo "<h3>2. Products with id > 10 and rate > 0:</h3>";
    $stmt = $pdo->query("SELECT id, description, rate FROM tblitems WHERE rate > 0 AND id > 10 ORDER BY id ASC LIMIT 20");
    $filtered_products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "<p>Found " . count($filtered_products) . " products</p>";
    
    if (!empty($filtered_products)) {
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr style='background: #f0f0f0;'><th>ID</th><th>Description</th><th>Rate</th></tr>";
        foreach ($filtered_products as $product) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($product['id']) . "</td>";
            echo "<td>" . htmlspecialchars($product['description']) . "</td>";
            echo "<td>" . htmlspecialchars($product['rate']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Test 3: After filtering out non-bakery items
    echo "<h3>3. After filtering out non-bakery items:</h3>";
    $bakery_products = [];
    foreach ($filtered_products as $item) {
        $description = strtolower($item['description']);
        if (strpos($description, 'mother board') === false && 
            strpos($description, 'computer') === false &&
            strpos($description, 'hardware') === false) {
            $bakery_products[] = $item;
        }
    }
    echo "<p>Found " . count($bakery_products) . " bakery products</p>";
    
    if (!empty($bakery_products)) {
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr style='background: #f0f0f0;'><th>ID</th><th>Description</th><th>Rate</th></tr>";
        foreach ($bakery_products as $product) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($product['id']) . "</td>";
            echo "<td>" . htmlspecialchars($product['description']) . "</td>";
            echo "<td>" . htmlspecialchars($product['rate']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
    // Test 4: Check if there are any products with rate = 0
    echo "<h3>4. Products with rate = 0 (might be excluded):</h3>";
    $stmt = $pdo->query("SELECT id, description, rate FROM tblitems WHERE rate = 0 ORDER BY id ASC LIMIT 10");
    $zero_rate_products = $stmt->fetchAll(PDO::FETCH_ASSOC);
    echo "<p>Found " . count($zero_rate_products) . " products with rate = 0</p>";
    
    if (!empty($zero_rate_products)) {
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr style='background: #f0f0f0;'><th>ID</th><th>Description</th><th>Rate</th></tr>";
        foreach ($zero_rate_products as $product) {
            echo "<tr>";
            echo "<td>" . htmlspecialchars($product['id']) . "</td>";
            echo "<td>" . htmlspecialchars($product['description']) . "</td>";
            echo "<td>" . htmlspecialchars($product['rate']) . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    }
    
} catch (PDOException $e) {
    echo "<h2>Database Error:</h2>";
    echo "<p style='color: red;'>" . $e->getMessage() . "</p>";
}
?>

