<?php
// Mobile-First Responsive Header Component for Honoré Bakery
?>

<style>
.search-dropdown {
    background: white;
    box-shadow: 0 10px 25px rgba(0, 0, 0, 0.1);
}
.font-playfair { font-family: 'Playfair Display', serif; }
.font-inter { font-family: 'Inter', sans-serif; }
.gradient-text {
    background: linear-gradient(135deg, #f59e0b, #d97706);
    -webkit-background-clip: text;
    -webkit-text-fill-color: transparent;
    background-clip: text;
}

/* Force mobile responsiveness */
@media (max-width: 767px) {
    .md\:hidden {
        display: block !important;
    }
    .hidden.md\:block {
        display: none !important;
    }
    .md\:flex {
        display: none !important;
    }
    .hidden.md\:flex {
        display: none !important;
    }
}
</style>

<!-- Top Announcement Bar -->
<div class="bg-amber-800 text-white py-1 px-2">
    <div class="max-w-7xl mx-auto">
        <!-- Mobile Layout -->
        <div class="block md:hidden text-center text-xs leading-tight">
            <div class="font-medium">HANDCRAFTING FLOWERS NOW</div>
            <div class="text-xs opacity-90">DUE TO HEAVY RAINS, DELIVERIES MAY DELAY.</div>
            <div class="font-medium text-xs">ORDER BY 7PM TO ENJOY SAME DAY DELIVERY</div>
        </div>
        
        <!-- Desktop Layout -->
        <div class="hidden md:flex justify-between items-center text-sm">
            <div class="flex items-center space-x-6">
                <span class="font-medium">HANDCRAFTING FLOWERS NOW</span>
                <span>DUE TO HEAVY RAINS, DELIVERIES MAY DELAY.</span>
            </div>
            <div class="text-right">
                <span class="font-medium">ORDER BY 7PM TO ENJOY SAME DAY DELIVERY</span>
            </div>
        </div>
    </div>
</div>

<!-- Main Header -->
<header class="bg-white border-b border-gray-200 sticky top-0 z-50">
    
    <!-- Mobile Header -->
    <div class="block md:hidden">
        <div class="px-3 py-2">
            <div class="flex items-center justify-between">
                <!-- Left: Search -->
                <button id="mobile-search-btn" class="text-gray-600 hover:text-amber-600 transition-colors">
                    <i class="fas fa-search text-lg"></i>
                </button>
                
                <!-- Center: Logo -->
                <a href="/erp-ecom/" class="flex items-center">
                    <div class="w-7 h-7 bg-gradient-to-br from-amber-500 to-amber-700 rounded-full flex items-center justify-center mr-2">
                        <i class="fas fa-bread-slice text-white text-sm"></i>
                    </div>
                    <span class="text-lg font-playfair font-bold gradient-text">Honoré Bakery</span>
                </a>
                
                <!-- Right: Cart + Menu -->
                <div class="flex items-center space-x-3">
                    <!-- Cart -->
                    <button id="cart-toggle" class="text-gray-600 hover:text-amber-600 transition-colors relative">
                        <i class="fas fa-shopping-bag text-lg"></i>
                        <span id="cart-count" class="absolute -top-1 -right-1 bg-rose-500 text-white text-xs rounded-full h-4 w-4 flex items-center justify-center">0</span>
                    </button>
                    
                    <!-- Mobile Menu Toggle -->
                    <button id="mobile-menu-toggle" class="text-gray-600 hover:text-amber-600 transition-colors">
                        <i class="fas fa-bars text-lg"></i>
                    </button>
                </div>
            </div>
        </div>
        
        <!-- Mobile Menu -->
        <div id="mobile-menu" class="hidden bg-white border-b border-gray-200">
            <div class="px-4 py-4 space-y-4">
                <!-- Mobile Search -->
                <div class="pb-3 border-b border-gray-100">
                    <button id="mobile-search-menu-btn" class="flex items-center w-full text-left text-gray-600 hover:text-amber-600 transition-colors">
                        <i class="fas fa-search mr-3"></i>
                        <span class="font-medium">Search Products</span>
                    </button>
                </div>
                
                <!-- Navigation Links -->
                <div class="space-y-2">
                    <a href="/erp-ecom/" class="block px-2 py-2 text-gray-900 hover:text-amber-600 font-medium transition-colors rounded-lg hover:bg-gray-50">Home</a>
                    
                    <!-- Mobile Collections -->
                    <div class="px-2">
                        <button id="mobile-collections-toggle" class="flex items-center justify-between w-full py-2 text-gray-900 hover:text-amber-600 font-medium transition-colors rounded-lg hover:bg-gray-50">
                            <span>Collections</span>
                            <i class="fas fa-chevron-down text-xs transition-transform duration-200" id="collections-arrow"></i>
                        </button>
                        <div id="mobile-collections-menu" class="hidden pl-4 mt-2 space-y-1">
                            <div class="mb-3">
                                <h3 class="font-semibold text-gray-900 mb-2 text-sm">Baked Goods</h3>
                                <a href="/erp-ecom/products" class="block py-1 text-sm text-gray-600 hover:text-amber-600 rounded px-2">Celebration Cakes</a>
                                <a href="/erp-ecom/products" class="block py-1 text-sm text-gray-600 hover:text-amber-600 rounded px-2">Cake Loaves</a>
                                <a href="/erp-ecom/products" class="block py-1 text-sm text-gray-600 hover:text-amber-600 rounded px-2">Boulangerie</a>
                                <a href="/erp-ecom/products" class="block py-1 text-sm text-gray-600 hover:text-amber-600 rounded px-2">Cookies & Biscuits</a>
                            </div>
                            <div>
                                <h3 class="font-semibold text-gray-900 mb-2 text-sm">Special</h3>
                                <a href="/erp-ecom/products" class="block py-1 text-sm text-gray-600 hover:text-amber-600 rounded px-2">Flowers</a>
                                <a href="/erp-ecom/products" class="block py-1 text-sm text-gray-600 hover:text-amber-600 rounded px-2">Hampers</a>
                                <a href="/erp-ecom/products" class="block py-1 text-sm text-gray-600 hover:text-amber-600 rounded px-2">Eggless Collection</a>
                                <a href="/erp-ecom/products" class="block py-1 text-sm text-gray-600 hover:text-amber-600 rounded px-2">Wedding Cakes</a>
                            </div>
                        </div>
                    </div>
                    
                    <a href="/erp-ecom/contact" class="block px-2 py-2 text-gray-900 hover:text-amber-600 font-medium transition-colors rounded-lg hover:bg-gray-50">Contact Us</a>
                    <a href="/erp-ecom/about" class="block px-2 py-2 text-gray-900 hover:text-amber-600 font-medium transition-colors rounded-lg hover:bg-gray-50">About Us</a>
                    <a href="/erp-ecom/contact" class="block px-2 py-2 text-gray-900 hover:text-amber-600 font-medium transition-colors rounded-lg hover:bg-gray-50">Track Order</a>
                    <a href="/erp-ecom/faq" class="block px-2 py-2 text-gray-900 hover:text-amber-600 font-medium transition-colors rounded-lg hover:bg-gray-50">FAQ</a>
                </div>
                
                <!-- Mobile User Actions -->
                <div class="pt-3 border-t border-gray-100 space-y-2">
                    <a href="tel:+919876543210" class="flex items-center px-2 py-2 text-gray-600 hover:text-amber-600 transition-colors rounded-lg hover:bg-gray-50">
                        <i class="fas fa-phone mr-3"></i>
                        <span>Call Us</span>
                    </a>
                    <a href="/erp-ecom/contact" class="flex items-center px-2 py-2 text-gray-600 hover:text-amber-600 transition-colors rounded-lg hover:bg-gray-50">
                        <i class="fas fa-user mr-3"></i>
                        <span>Login / Register</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
    
    <!-- Desktop Header -->
    <div class="hidden md:block">
        <!-- Top Row -->
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <!-- Left: Search -->
                <div class="flex-shrink-0">
                    <button id="desktop-search-btn" class="flex items-center space-x-2 text-gray-600 hover:text-amber-600 transition-colors">
                        <i class="fas fa-search text-lg"></i>
                        <span class="font-medium">SEARCH</span>
                    </button>
                </div>
                
                <!-- Center: Logo -->
                <div class="flex-shrink-0">
                    <a href="/erp-ecom/" class="flex items-center">
                        <div class="w-10 h-10 bg-gradient-to-br from-amber-500 to-amber-700 rounded-full flex items-center justify-center mr-3">
                            <i class="fas fa-bread-slice text-white text-lg"></i>
                        </div>
                        <span class="text-3xl font-playfair font-bold gradient-text">Honoré Bakery</span>
                    </a>
                </div>
                
                <!-- Right: Actions -->
                <div class="flex items-center space-x-4">
                    <!-- Phone -->
                    <a href="tel:+919876543210" class="text-gray-600 hover:text-amber-600 transition-colors">
                        <i class="fas fa-phone text-lg"></i>
                    </a>
                    
                    <!-- User Account -->
                    <div class="relative group">
                        <button class="text-gray-600 hover:text-amber-600 transition-colors">
                            <i class="fas fa-user text-lg"></i>
                        </button>
                        <div class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-xl opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                            <div class="py-2">
                                <a href="/erp-ecom/contact" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Login</a>
                                <a href="/erp-ecom/contact" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Register</a>
                                <a href="/erp-ecom/contact" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">My Account</a>
                                <a href="/erp-ecom/contact" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Track Order</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Cart -->
                    <div class="relative">
                        <button id="cart-toggle-desktop" class="text-gray-600 hover:text-amber-600 transition-colors relative">
                            <i class="fas fa-shopping-bag text-lg"></i>
                            <span id="cart-count-desktop" class="absolute -top-1 -right-1 bg-rose-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center">0</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Desktop Navigation -->
        <div class="bg-white border-b border-gray-200">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <nav class="flex items-center justify-center space-x-8 py-3">
                    <a href="/erp-ecom/" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors">Home</a>
                    
                    <!-- Collections Dropdown -->
                    <div class="relative group">
                        <button class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors flex items-center">
                            Collections
                            <i class="fas fa-chevron-down ml-1 text-xs"></i>
                        </button>
                        <div class="absolute left-0 mt-2 w-80 bg-white rounded-lg shadow-xl opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                            <div class="grid grid-cols-2 gap-4 p-6">
                                <div>
                                    <h3 class="font-semibold text-gray-900 mb-3">Baked Goods</h3>
                                    <ul class="space-y-2">
                                        <li><a href="/erp-ecom/products" class="text-gray-600 hover:text-amber-600 text-sm">Celebration Cakes</a></li>
                                        <li><a href="/erp-ecom/products" class="text-gray-600 hover:text-amber-600 text-sm">Cake Loaves</a></li>
                                        <li><a href="/erp-ecom/products" class="text-gray-600 hover:text-amber-600 text-sm">Boulangerie</a></li>
                                        <li><a href="/erp-ecom/products" class="text-gray-600 hover:text-amber-600 text-sm">Cookies & Biscuits</a></li>
                                    </ul>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900 mb-3">Special</h3>
                                    <ul class="space-y-2">
                                        <li><a href="/erp-ecom/products" class="text-gray-600 hover:text-amber-600 text-sm">Flowers</a></li>
                                        <li><a href="/erp-ecom/products" class="text-gray-600 hover:text-amber-600 text-sm">Hampers</a></li>
                                        <li><a href="/erp-ecom/products" class="text-gray-600 hover:text-amber-600 text-sm">Eggless Collection</a></li>
                                        <li><a href="/erp-ecom/products" class="text-gray-600 hover:text-amber-600 text-sm">Wedding Cakes</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <a href="/erp-ecom/contact" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors">Contact Us</a>
                    <a href="/erp-ecom/about" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors">About Us</a>
                    <a href="/erp-ecom/contact" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors">Track Order</a>
                    <a href="/erp-ecom/faq" class="text-gray-900 hover:text-amber-600 px-3 py-2 text-sm font-medium transition-colors">FAQ</a>
                </nav>
            </div>
        </div>
    </div>
</header>

<!-- Search Dropdown -->
<div id="search-dropdown" class="fixed top-0 left-0 right-0 z-50 search-dropdown transform -translate-y-full transition-transform duration-300">
    <div class="max-w-4xl mx-auto px-4 py-6">
        <!-- Search Input -->
        <div class="relative mb-6">
            <input type="text" id="search-input" placeholder="Search products..." 
                   class="w-full px-6 py-4 pr-16 border-2 border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent text-lg">
            <button id="search-submit" class="absolute right-4 top-4 text-gray-400 hover:text-amber-600">
                <i class="fas fa-search text-xl"></i>
            </button>
        </div>
        
        <!-- Popular Searches -->
        <div class="mb-6">
            <h3 class="text-sm font-medium text-gray-500 mb-3">Popular Searches:</h3>
            <div class="flex flex-wrap gap-3">
                <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Chocolates</button>
                <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Eggless</button>
                <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Fruits</button>
                <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Cakes</button>
                <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Bread</button>
            </div>
        </div>
        
        <!-- Close Button -->
        <div class="text-center">
            <button id="search-close" class="text-gray-400 hover:text-gray-600 text-sm">
                <i class="fas fa-times mr-2"></i>Close Search
            </button>
        </div>
    </div>
</div>

<!-- Search Overlay -->
<div id="search-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden"></div>

<script>
// Header Component JavaScript
document.addEventListener('DOMContentLoaded', function() {
    console.log('Header component loading...');
    
    // Search functionality
    const searchDropdown = document.getElementById('search-dropdown');
    const searchClose = document.getElementById('search-close');
    const searchOverlay = document.getElementById('search-overlay');
    const searchInput = document.getElementById('search-input');
    const searchSubmit = document.getElementById('search-submit');
    
    // Mobile search buttons
    const mobileSearchBtn = document.getElementById('mobile-search-btn');
    const mobileSearchMenuBtn = document.getElementById('mobile-search-menu-btn');
    
    // Desktop search button
    const desktopSearchBtn = document.getElementById('desktop-search-btn');
    
    // Mobile menu functionality
    const mobileMenuToggle = document.getElementById('mobile-menu-toggle');
    const mobileMenu = document.getElementById('mobile-menu');
    const mobileCollectionsToggle = document.getElementById('mobile-collections-toggle');
    const mobileCollectionsMenu = document.getElementById('mobile-collections-menu');
    const collectionsArrow = document.getElementById('collections-arrow');
    
    // Cart functionality
    const cartToggle = document.getElementById('cart-toggle');
    const cartToggleDesktop = document.getElementById('cart-toggle-desktop');
    
    console.log('Mobile elements found:', {
        mobileMenuToggle: !!mobileMenuToggle,
        mobileMenu: !!mobileMenu,
        mobileSearchBtn: !!mobileSearchBtn
    });
    
    // Open search dropdown
    function openSearch() {
        if (searchDropdown && searchOverlay) {
            searchDropdown.classList.remove('-translate-y-full');
            searchOverlay.classList.remove('hidden');
            document.body.style.overflow = 'hidden';
            setTimeout(() => {
                if (searchInput) {
                    searchInput.focus();
                }
            }, 100);
        }
    }
    
    // Close search dropdown
    function closeSearch() {
        if (searchDropdown && searchOverlay) {
            searchDropdown.classList.add('-translate-y-full');
            searchOverlay.classList.add('hidden');
            document.body.style.overflow = 'auto';
        }
    }
    
    // Search event listeners
    if (mobileSearchBtn) {
        mobileSearchBtn.addEventListener('click', (e) => {
            e.preventDefault();
            console.log('Mobile search button clicked');
            openSearch();
        });
    }
    
    if (mobileSearchMenuBtn) {
        mobileSearchMenuBtn.addEventListener('click', (e) => {
            e.preventDefault();
            console.log('Mobile search menu button clicked');
            if (mobileMenu) {
                mobileMenu.classList.add('hidden');
            }
            openSearch();
        });
    }
    
    if (desktopSearchBtn) {
        desktopSearchBtn.addEventListener('click', (e) => {
            e.preventDefault();
            console.log('Desktop search button clicked');
            openSearch();
        });
    }
    
    if (searchClose) {
        searchClose.addEventListener('click', closeSearch);
    }
    
    if (searchOverlay) {
        searchOverlay.addEventListener('click', closeSearch);
    }
    
    // Search functionality
    if (searchSubmit) {
        searchSubmit.addEventListener('click', () => {
            const query = searchInput.value.trim();
            if (query) {
                window.location.href = `/erp-ecom/products?search=${encodeURIComponent(query)}`;
            }
        });
    }
    
    if (searchInput) {
        searchInput.addEventListener('keypress', (e) => {
            if (e.key === 'Enter') {
                const query = searchInput.value.trim();
                if (query) {
                    window.location.href = `/erp-ecom/products?search=${encodeURIComponent(query)}`;
                }
            }
        });
    }
    
    // Mobile menu functionality
    if (mobileMenuToggle && mobileMenu) {
        mobileMenuToggle.addEventListener('click', () => {
            console.log('Mobile menu toggle clicked');
            mobileMenu.classList.toggle('hidden');
            console.log('Mobile menu hidden:', mobileMenu.classList.contains('hidden'));
        });
    }
    
    if (mobileCollectionsToggle && mobileCollectionsMenu && collectionsArrow) {
        mobileCollectionsToggle.addEventListener('click', () => {
            mobileCollectionsMenu.classList.toggle('hidden');
            collectionsArrow.classList.toggle('rotate-180');
        });
    }
    
    // Cart functionality - sync both cart buttons
    function syncCartCounts() {
        const cartCount = document.getElementById('cart-count');
        const cartCountDesktop = document.getElementById('cart-count-desktop');
        
        if (cartCount && cartCountDesktop) {
            const count = cartCount.textContent;
            cartCountDesktop.textContent = count;
        }
    }
    
    // Initialize cart count sync
    syncCartCounts();
    
    // Set up cart toggle events
    if (cartToggle) {
        cartToggle.addEventListener('click', (e) => {
            e.preventDefault();
            console.log('Mobile cart toggle clicked');
            // Cart functionality will be handled by cart_component.php
        });
    }
    
    if (cartToggleDesktop) {
        cartToggleDesktop.addEventListener('click', (e) => {
            e.preventDefault();
            console.log('Desktop cart toggle clicked');
            // Cart functionality will be handled by cart_component.php
        });
    }
    
    console.log('Header component initialized');
});
</script>