<?php
// Manual Website module activation and test
echo "<h1>Manual Website Module Activation</h1>";

// Check if we can manually load the Website_frontend controller
echo "<h2>Testing Direct Controller Access</h2>";

try {
    // Set up basic environment
    $_SERVER['REQUEST_METHOD'] = 'GET';
    $_SERVER['REQUEST_URI'] = '/';
    $_SERVER['HTTP_HOST'] = 'localhost';
    
    // Load CodeIgniter bootstrap
    define('BASEPATH', realpath('system') . '/');
    define('APPPATH', realpath('application') . '/');
    define('EXT', '.php');
    
    // Load the Website_frontend controller directly
    if (file_exists('application/controllers/Website_frontend.php')) {
        echo "<p>✅ Website_frontend controller file exists</p>";
        
        // Try to include the controller
        include_once('application/controllers/Website_frontend.php');
        
        if (class_exists('Website_frontend')) {
            echo "<p>✅ Website_frontend class loaded successfully</p>";
            
            // Test if we can instantiate the controller
            try {
                $controller = new Website_frontend();
                echo "<p>✅ Website_frontend controller instantiated successfully</p>";
                
                // Test homepage method
                if (method_exists($controller, 'homepage')) {
                    echo "<p>✅ Homepage method exists</p>";
                } else {
                    echo "<p>❌ Homepage method not found</p>";
                }
                
                // Test about method
                if (method_exists($controller, 'about')) {
                    echo "<p>✅ About method exists</p>";
                } else {
                    echo "<p>❌ About method not found</p>";
                }
                
                // Test contact method
                if (method_exists($controller, 'contact')) {
                    echo "<p>✅ Contact method exists</p>";
                } else {
                    echo "<p>❌ Contact method not found</p>";
                }
                
            } catch (Exception $e) {
                echo "<p>❌ Error instantiating controller: " . $e->getMessage() . "</p>";
            }
        } else {
            echo "<p>❌ Website_frontend class not found</p>";
        }
    } else {
        echo "<p>❌ Website_frontend controller file not found</p>";
    }
    
} catch (Exception $e) {
    echo "<p>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<h2>Alternative Solution: Create Simple Test Pages</h2>";

// Create simple test pages that don't rely on the module system
$simple_homepage = '<?php
echo "<!DOCTYPE html>
<html>
<head>
    <title>Honoré Bakery - Test Homepage</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; background: #f8f4e6; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 40px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        h1 { color: #8B4513; text-align: center; }
        .nav { text-align: center; margin: 20px 0; }
        .nav a { margin: 0 15px; color: #8B4513; text-decoration: none; font-weight: bold; }
        .nav a:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class=\"container\">
        <h1>Honoré Bakery</h1>
        <p style=\"text-align: center; font-size: 18px; color: #666;\">Fresh Artisan Breads & Pastries</p>
        
        <div class=\"nav\">
            <a href=\"simple_homepage.php\">Home</a>
            <a href=\"simple_about.php\">About</a>
            <a href=\"simple_contact.php\">Contact</a>
            <a href=\"simple_products.php\">Products</a>
        </div>
        
        <h2>Welcome to Honoré Bakery</h2>
        <p>Founded in 1985, Honoré Bakery has been serving the community with authentic French baking traditions for over three decades.</p>
        
        <h3>Our Signature Products</h3>
        <ul>
            <li>Artisan Sourdough Bread</li>
            <li>Chocolate Croissants</li>
            <li>French Macarons</li>
            <li>Custom Cakes</li>
            <li>Fresh Coffee</li>
        </ul>
        
        <h3>Visit Us</h3>
        <p><strong>Location:</strong> 123 Baker Street, Downtown</p>
        <p><strong>Phone:</strong> (555) 123-BAKE</p>
        <p><strong>Hours:</strong> Mon-Fri: 6AM-8PM, Sat: 6AM-8PM, Sun: 7AM-6PM</p>
        
        <p style=\"text-align: center; margin-top: 40px; color: #999;\">
            <em>This is a simple test page. The full website module needs to be activated for complete functionality.</em>
        </p>
    </div>
</body>
</html>";
?>';

file_put_contents('simple_homepage.php', $simple_homepage);
echo "<p>✅ Created simple_homepage.php</p>";

$simple_about = '<?php
echo "<!DOCTYPE html>
<html>
<head>
    <title>About Us - Honoré Bakery</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; background: #f8f4e6; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 40px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        h1 { color: #8B4513; text-align: center; }
        .nav { text-align: center; margin: 20px 0; }
        .nav a { margin: 0 15px; color: #8B4513; text-decoration: none; font-weight: bold; }
        .nav a:hover { text-decoration: underline; }
    </style>
</head>
<body>
    <div class=\"container\">
        <h1>About Honoré Bakery</h1>
        
        <div class=\"nav\">
            <a href=\"simple_homepage.php\">Home</a>
            <a href=\"simple_about.php\">About</a>
            <a href=\"simple_contact.php\">Contact</a>
            <a href=\"simple_products.php\">Products</a>
        </div>
        
        <h2>Our Story</h2>
        <p>Founded in 1985, Honoré Bakery has been serving the community with authentic French baking traditions for over three decades.</p>
        
        <p>Our journey began when Master Baker Pierre Honoré immigrated from France with a dream to bring the authentic taste of French patisserie to America. Starting as a small family business in a modest kitchen, we have grown into a beloved neighborhood institution while maintaining our commitment to traditional techniques and the finest ingredients.</p>
        
        <h3>Our Philosophy</h3>
        <ul>
            <li><strong>Quality First:</strong> We use only the finest, locally-sourced organic ingredients</li>
            <li><strong>Traditional Methods:</strong> Our techniques have been perfected over generations</li>
            <li><strong>Daily Freshness:</strong> Everything is baked fresh every morning</li>
            <li><strong>Community Focus:</strong> We\'re proud to be part of the local community</li>
        </ul>
        
        <h3>Meet Our Team</h3>
        <p><strong>Pierre Honoré</strong> - Master Baker & Founder</p>
        <p><strong>Marie Dubois</strong> - Head Pastry Chef</p>
        <p><strong>Jean-Luc Martin</strong> - Sourdough Specialist</p>
        
        <p style=\"text-align: center; margin-top: 40px; color: #999;\">
            <em>This is a simple test page. The full website module needs to be activated for complete functionality.</em>
        </p>
    </div>
</body>
</html>";
?>';

file_put_contents('simple_about.php', $simple_about);
echo "<p>✅ Created simple_about.php</p>";

$simple_contact = '<?php
echo "<!DOCTYPE html>
<html>
<head>
    <title>Contact Us - Honoré Bakery</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; background: #f8f4e6; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 40px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        h1 { color: #8B4513; text-align: center; }
        .nav { text-align: center; margin: 20px 0; }
        .nav a { margin: 0 15px; color: #8B4513; text-decoration: none; font-weight: bold; }
        .nav a:hover { text-decoration: underline; }
        .contact-info { background: #f9f9f9; padding: 20px; border-radius: 5px; margin: 20px 0; }
    </style>
</head>
<body>
    <div class=\"container\">
        <h1>Contact Honoré Bakery</h1>
        
        <div class=\"nav\">
            <a href=\"simple_homepage.php\">Home</a>
            <a href=\"simple_about.php\">About</a>
            <a href=\"simple_contact.php\">Contact</a>
            <a href=\"simple_products.php\">Products</a>
        </div>
        
        <div class=\"contact-info\">
            <h3>Visit Us</h3>
            <p><strong>Address:</strong> 123 Baker Street, Downtown District, City, State 12345</p>
            <p><strong>Phone:</strong> (555) 123-BAKE</p>
            <p><strong>Email:</strong> hello@honorebakery.com</p>
        </div>
        
        <div class=\"contact-info\">
            <h3>Store Hours</h3>
            <p><strong>Monday - Friday:</strong> 6:00 AM - 8:00 PM</p>
            <p><strong>Saturday:</strong> 7:00 AM - 7:00 PM</p>
            <p><strong>Sunday:</strong> 8:00 AM - 6:00 PM</p>
        </div>
        
        <h3>Send us a Message</h3>
        <form>
            <p><input type=\"text\" placeholder=\"Your Name\" style=\"width: 100%; padding: 10px; margin: 5px 0; border: 1px solid #ddd; border-radius: 5px;\"></p>
            <p><input type=\"email\" placeholder=\"Your Email\" style=\"width: 100%; padding: 10px; margin: 5px 0; border: 1px solid #ddd; border-radius: 5px;\"></p>
            <p><textarea placeholder=\"Your Message\" rows=\"4\" style=\"width: 100%; padding: 10px; margin: 5px 0; border: 1px solid #ddd; border-radius: 5px;\"></textarea></p>
            <p><button type=\"submit\" style=\"background: #8B4513; color: white; padding: 10px 20px; border: none; border-radius: 5px; cursor: pointer;\">Send Message</button></p>
        </form>
        
        <p style=\"text-align: center; margin-top: 40px; color: #999;\">
            <em>This is a simple test page. The full website module needs to be activated for complete functionality.</em>
        </p>
    </div>
</body>
</html>";
?>';

file_put_contents('simple_contact.php', $simple_contact);
echo "<p>✅ Created simple_contact.php</p>";

$simple_products = '<?php
echo "<!DOCTYPE html>
<html>
<head>
    <title>Our Products - Honoré Bakery</title>
    <style>
        body { font-family: Arial, sans-serif; margin: 40px; background: #f8f4e6; }
        .container { max-width: 800px; margin: 0 auto; background: white; padding: 40px; border-radius: 10px; box-shadow: 0 4px 6px rgba(0,0,0,0.1); }
        h1 { color: #8B4513; text-align: center; }
        .nav { text-align: center; margin: 20px 0; }
        .nav a { margin: 0 15px; color: #8B4513; text-decoration: none; font-weight: bold; }
        .nav a:hover { text-decoration: underline; }
        .product { border: 1px solid #ddd; padding: 20px; margin: 20px 0; border-radius: 5px; background: #f9f9f9; }
    </style>
</head>
<body>
    <div class=\"container\">
        <h1>Our Products</h1>
        
        <div class=\"nav\">
            <a href=\"simple_homepage.php\">Home</a>
            <a href=\"simple_about.php\">About</a>
            <a href=\"simple_contact.php\">Contact</a>
            <a href=\"simple_products.php\">Products</a>
        </div>
        
        <div class=\"product\">
            <h3>Artisan Sourdough Bread</h3>
            <p>Traditional sourdough bread with a perfect crust and tangy flavor, fermented for 24 hours using our secret starter culture.</p>
            <p><strong>Price:</strong> $8.99</p>
        </div>
        
        <div class=\"product\">
            <h3>Chocolate Croissants</h3>
            <p>Buttery, flaky croissants filled with rich Belgian chocolate, baked fresh every morning using traditional French techniques.</p>
            <p><strong>Price:</strong> $4.50</p>
        </div>
        
        <div class=\"product\">
            <h3>French Macarons</h3>
            <p>Delicate French macarons in 6 different flavors, perfect for special occasions and elegant gatherings.</p>
            <p><strong>Price:</strong> $18.99</p>
        </div>
        
        <div class=\"product\">
            <h3>Cinnamon Rolls</h3>
            <p>Soft, gooey cinnamon rolls with cream cheese frosting, made with our secret recipe.</p>
            <p><strong>Price:</strong> $6.99</p>
        </div>
        
        <div class=\"product\">
            <h3>Custom Cakes</h3>
            <p>Beautiful custom cakes for birthdays, weddings, and special celebrations.</p>
            <p><strong>Price:</strong> From $45</p>
        </div>
        
        <div class=\"product\">
            <h3>Fresh Coffee</h3>
            <p>Premium coffee beans roasted daily, paired perfectly with our baked goods.</p>
            <p><strong>Price:</strong> $3.50</p>
        </div>
        
        <p style=\"text-align: center; margin-top: 40px; color: #999;\">
            <em>This is a simple test page. The full website module needs to be activated for complete functionality.</em>
        </p>
    </div>
</body>
</html>";
?>';

file_put_contents('simple_products.php', $simple_products);
echo "<p>✅ Created simple_products.php</p>";

echo "<hr>";
echo "<h2>Test Simple Pages</h2>";
echo "<p><a href='simple_homepage.php' target='_blank'>Test Simple Homepage</a></p>";
echo "<p><a href='simple_about.php' target='_blank'>Test Simple About Page</a></p>";
echo "<p><a href='simple_contact.php' target='_blank'>Test Simple Contact Page</a></p>";
echo "<p><a href='simple_products.php' target='_blank'>Test Simple Products Page</a></p>";
?>
