<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>About Us - Honoré Bakery</title>
    <meta name="description" content="Learn about Honoré Bakery's story, our commitment to quality, and the passionate team behind our artisan breads, pastries, and flowers.">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'playfair': ['Playfair Display', 'serif'],
                        'inter': ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'amber': {
                            50: '#fffbeb',
                            100: '#fef3c7',
                            200: '#fde68a',
                            300: '#fcd34d',
                            400: '#fbbf24',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309',
                            800: '#92400e',
                            900: '#78350f',
                        }
                    },
                    animation: {
                        'fade-in': 'fadeIn 0.5s ease-in-out',
                        'slide-up': 'slideUp 0.5s ease-out',
                        'float': 'float 3s ease-in-out infinite',
                    },
                    keyframes: {
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' },
                        },
                        slideUp: {
                            '0%': { transform: 'translateY(20px)', opacity: '0' },
                            '100%': { transform: 'translateY(0)', opacity: '1' },
                        },
                        float: {
                            '0%, 100%': { transform: 'translateY(0px)' },
                            '50%': { transform: 'translateY(-10px)' },
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        .glass-effect {
            background: rgba(255, 255, 255, 0.25);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.18);
        }
        
        .gradient-text {
            background: linear-gradient(135deg, #d97706, #f59e0b, #fbbf24);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .parallax-bg {
            background-attachment: fixed;
            background-position: center;
            background-repeat: no-repeat;
            background-size: cover;
        }
        
        .team-card {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .team-card:hover {
            transform: translateY(-8px) scale(1.02);
            box-shadow: 0 25px 50px -12px rgba(0, 0, 0, 0.25);
        }
        
        .stat-card {
            transition: all 0.3s ease;
        }
        
        .stat-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.15);
        }
        
        .category-scroll::-webkit-scrollbar {
            display: none;
        }
        
        .category-scroll {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        
        .search-dropdown {
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.95);
        }
    </style>
</head>
<body class="font-inter bg-amber-50 text-gray-900">
    <?php include 'header_component.php'; ?>

    <!-- Main Content -->
    <main>
        <!-- Hero Section -->
        <section class="relative h-screen flex items-center justify-center overflow-hidden">
            <!-- Background Image -->
            <div class="absolute inset-0 bg-gradient-to-br from-amber-100 via-amber-200 to-amber-300"></div>
            
            <!-- Overlay -->
            <div class="absolute inset-0 bg-gradient-to-r from-amber-900/40 to-amber-700/40"></div>
            
            <!-- Content -->
            <div class="relative z-10 text-center text-white max-w-4xl mx-auto px-4">
                <h1 class="text-6xl md:text-8xl font-playfair font-bold mb-6 animate-fade-in">
                    <span class="block">Our</span>
                    <span class="block gradient-text">Story</span>
                </h1>
                <p class="text-xl md:text-2xl mb-8 text-amber-100 animate-slide-up">
                    Crafting exceptional bakery experiences with passion, tradition, and innovation since 2010.
                </p>
                <div class="animate-slide-up">
                    <button class="bg-amber-600 hover:bg-amber-700 text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                        <i class="fas fa-play mr-2"></i>Watch Our Story
                    </button>
                </div>
            </div>
            
            <!-- Floating Elements -->
            <div class="absolute top-20 left-10 floating">
                <i class="fas fa-bread-slice text-4xl text-amber-300 opacity-60"></i>
            </div>
            <div class="absolute top-40 right-20 floating" style="animation-delay: 1s;">
                <i class="fas fa-birthday-cake text-3xl text-rose-300 opacity-60"></i>
            </div>
            <div class="absolute bottom-40 left-20 floating" style="animation-delay: 2s;">
                <i class="fas fa-cookie-bite text-3xl text-amber-300 opacity-60"></i>
            </div>
            <div class="absolute bottom-20 right-10 floating" style="animation-delay: 3s;">
                <i class="fas fa-seedling text-3xl text-green-300 opacity-60"></i>
            </div>
        </section>

        <!-- Our Story Section -->
        <section class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-16 items-center">
                    <div>
                        <h2 class="text-4xl md:text-5xl font-playfair font-bold text-gray-900 mb-6">
                            The <span class="gradient-text">Honoré</span> Journey
                        </h2>
                        <div class="space-y-6 text-lg text-gray-600">
                            <p>
                                Founded in 2010 by master baker Marie Honoré, our bakery began as a small family business with a simple mission: to bring the authentic taste of French artisanal baking to our community.
                            </p>
                            <p>
                                What started as a passion project in a tiny kitchen has grown into a beloved institution, serving thousands of customers who have become part of our extended family. Every day, we wake up before dawn to knead, proof, and bake with the same dedication and love that Marie brought to her first loaf.
                            </p>
                            <p>
                                Today, we're proud to offer not just exceptional breads and pastries, but also beautiful flowers and comprehensive catering services, all while maintaining our commitment to quality, sustainability, and community.
                            </p>
                        </div>
                    </div>
                    <div class="relative">
                        <div class="bg-gradient-to-br from-amber-100 to-amber-200 rounded-3xl p-8 h-96 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-8xl text-amber-600"></i>
                        </div>
                        <div class="absolute -bottom-6 -right-6 bg-white rounded-2xl p-6 shadow-xl">
                            <div class="text-center">
                                <div class="text-3xl font-bold text-amber-600 mb-2">14+</div>
                                <div class="text-gray-600">Years of Excellence</div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Our Values Section -->
        <section class="py-20 bg-amber-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-4xl md:text-5xl font-playfair font-bold text-gray-900 mb-4">
                        Our <span class="gradient-text">Values</span>
                    </h2>
                    <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                        The principles that guide everything we do, from sourcing ingredients to serving our customers.
                    </p>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    <div class="text-center">
                        <div class="w-20 h-20 bg-amber-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="fas fa-leaf text-3xl text-amber-600"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-4">Quality First</h3>
                        <p class="text-gray-600">We use only the finest, locally-sourced organic ingredients in all our products, ensuring exceptional taste and nutritional value.</p>
                    </div>
                    
                    <div class="text-center">
                        <div class="w-20 h-20 bg-amber-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="fas fa-heart text-3xl text-amber-600"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-4">Made with Love</h3>
                        <p class="text-gray-600">Every product is crafted with passion and care, following traditional techniques passed down through generations.</p>
                    </div>
                    
                    <div class="text-center">
                        <div class="w-20 h-20 bg-amber-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="fas fa-recycle text-3xl text-amber-600"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-4">Sustainability</h3>
                        <p class="text-gray-600">We're committed to eco-friendly practices, from biodegradable packaging to supporting local farmers and suppliers.</p>
                    </div>
                    
                    <div class="text-center">
                        <div class="w-20 h-20 bg-amber-100 rounded-full flex items-center justify-center mx-auto mb-6">
                            <i class="fas fa-users text-3xl text-amber-600"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-4">Community</h3>
                        <p class="text-gray-600">We believe in giving back to our community through local partnerships, charity events, and supporting local causes.</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Statistics Section -->
        <section class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-4xl md:text-5xl font-playfair font-bold text-gray-900 mb-4">
                        Our <span class="gradient-text">Impact</span>
                    </h2>
                    <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                        Numbers that tell the story of our growth, impact, and commitment to excellence.
                    </p>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-8">
                    <div class="stat-card bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-8 text-center">
                        <div class="text-4xl font-bold text-amber-600 mb-2">50K+</div>
                        <div class="text-gray-600 mb-2">Happy Customers</div>
                        <div class="text-sm text-gray-500">Served with love and care</div>
                    </div>
                    
                    <div class="stat-card bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-8 text-center">
                        <div class="text-4xl font-bold text-amber-600 mb-2">100+</div>
                        <div class="text-gray-600 mb-2">Products</div>
                        <div class="text-sm text-gray-500">Freshly baked daily</div>
                    </div>
                    
                    <div class="stat-card bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-8 text-center">
                        <div class="text-4xl font-bold text-amber-600 mb-2">5</div>
                        <div class="text-gray-600 mb-2">Store Locations</div>
                        <div class="text-sm text-gray-500">Across the city</div>
                    </div>
                    
                    <div class="stat-card bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-8 text-center">
                        <div class="text-4xl font-bold text-amber-600 mb-2">4.9</div>
                        <div class="text-gray-600 mb-2">Average Rating</div>
                        <div class="text-sm text-gray-500">Based on 2,500+ reviews</div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Team Section -->
        <section class="py-20 bg-amber-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-4xl md:text-5xl font-playfair font-bold text-gray-900 mb-4">
                        Meet Our <span class="gradient-text">Team</span>
                    </h2>
                    <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                        The passionate individuals behind Honoré Bakery, dedicated to bringing you the finest bakery experiences.
                    </p>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <!-- Team Member 1 -->
                    <div class="team-card bg-white rounded-2xl shadow-lg overflow-hidden">
                        <div class="relative h-64 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <div class="w-32 h-32 bg-amber-300 rounded-full flex items-center justify-center">
                                <span class="text-4xl font-bold text-amber-700">MH</span>
                            </div>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Marie Honoré</h3>
                            <p class="text-amber-600 font-medium mb-3">Founder & Master Baker</p>
                            <p class="text-gray-600 text-sm">With over 20 years of experience in French artisanal baking, Marie founded Honoré Bakery with a vision to bring authentic European flavors to our community.</p>
                            <div class="flex space-x-2 mt-4">
                                <a href="#" class="w-8 h-8 bg-amber-100 rounded-full flex items-center justify-center hover:bg-amber-200 transition-colors">
                                    <i class="fab fa-linkedin text-amber-600 text-sm"></i>
                                </a>
                                <a href="#" class="w-8 h-8 bg-amber-100 rounded-full flex items-center justify-center hover:bg-amber-200 transition-colors">
                                    <i class="fab fa-instagram text-amber-600 text-sm"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Team Member 2 -->
                    <div class="team-card bg-white rounded-2xl shadow-lg overflow-hidden">
                        <div class="relative h-64 bg-gradient-to-br from-rose-100 to-rose-200 flex items-center justify-center">
                            <div class="w-32 h-32 bg-rose-300 rounded-full flex items-center justify-center">
                                <span class="text-4xl font-bold text-rose-700">AC</span>
                            </div>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Antoine Chevalier</h3>
                            <p class="text-amber-600 font-medium mb-3">Head Pastry Chef</p>
                            <p class="text-gray-600 text-sm">Antoine brings his expertise from Parisian patisseries to create our signature pastries and celebration cakes that customers love.</p>
                            <div class="flex space-x-2 mt-4">
                                <a href="#" class="w-8 h-8 bg-amber-100 rounded-full flex items-center justify-center hover:bg-amber-200 transition-colors">
                                    <i class="fab fa-linkedin text-amber-600 text-sm"></i>
                                </a>
                                <a href="#" class="w-8 h-8 bg-amber-100 rounded-full flex items-center justify-center hover:bg-amber-200 transition-colors">
                                    <i class="fab fa-instagram text-amber-600 text-sm"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Team Member 3 -->
                    <div class="team-card bg-white rounded-2xl shadow-lg overflow-hidden">
                        <div class="relative h-64 bg-gradient-to-br from-green-100 to-green-200 flex items-center justify-center">
                            <div class="w-32 h-32 bg-green-300 rounded-full flex items-center justify-center">
                                <span class="text-4xl font-bold text-green-700">SM</span>
                            </div>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Sophie Martin</h3>
                            <p class="text-amber-600 font-medium mb-3">Floral Designer</p>
                            <p class="text-gray-600 text-sm">Sophie creates stunning floral arrangements that complement our bakery products, bringing beauty and elegance to every occasion.</p>
                            <div class="flex space-x-2 mt-4">
                                <a href="#" class="w-8 h-8 bg-amber-100 rounded-full flex items-center justify-center hover:bg-amber-200 transition-colors">
                                    <i class="fab fa-linkedin text-amber-600 text-sm"></i>
                                </a>
                                <a href="#" class="w-8 h-8 bg-amber-100 rounded-full flex items-center justify-center hover:bg-amber-200 transition-colors">
                                    <i class="fab fa-instagram text-amber-600 text-sm"></i>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Awards & Recognition -->
        <section class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-4xl md:text-5xl font-playfair font-bold text-gray-900 mb-4">
                        Awards & <span class="gradient-text">Recognition</span>
                    </h2>
                    <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                        Our commitment to excellence has been recognized by industry leaders and our community.
                    </p>
                </div>
                
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8">
                    <div class="bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-8 text-center">
                        <div class="w-16 h-16 bg-amber-200 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-trophy text-2xl text-amber-600"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Best Bakery 2023</h3>
                        <p class="text-gray-600 text-sm">City Food & Beverage Awards</p>
                    </div>
                    
                    <div class="bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-8 text-center">
                        <div class="w-16 h-16 bg-amber-200 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-star text-2xl text-amber-600"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Excellence in Service</h3>
                        <p class="text-gray-600 text-sm">Customer Choice Awards 2023</p>
                    </div>
                    
                    <div class="bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-8 text-center">
                        <div class="w-16 h-16 bg-amber-200 rounded-full flex items-center justify-center mx-auto mb-4">
                            <i class="fas fa-leaf text-2xl text-amber-600"></i>
                        </div>
                        <h3 class="text-lg font-semibold text-gray-900 mb-2">Sustainable Business</h3>
                        <p class="text-gray-600 text-sm">Green Business Council 2023</p>
                    </div>
                </div>
            </div>
        </section>

        <!-- Call to Action -->
        <section class="py-20 bg-gradient-to-r from-amber-600 to-amber-700">
            <div class="max-w-4xl mx-auto text-center px-4 sm:px-6 lg:px-8">
                <h2 class="text-4xl md:text-5xl font-playfair font-bold text-white mb-4">
                    Join Our Story
                </h2>
                <p class="text-xl text-amber-100 mb-8">
                    Experience the difference that passion, quality, and tradition make in every bite.
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="/products" class="bg-white text-amber-600 px-8 py-4 rounded-full text-lg font-semibold hover:bg-amber-50 transition-colors">
                        <i class="fas fa-shopping-bag mr-2"></i>Shop Now
                    </a>
                    <a href="/contact" class="border-2 border-white text-white hover:bg-white hover:text-amber-600 px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300">
                        <i class="fas fa-envelope mr-2"></i>Get in Touch
                    </a>
                </div>
            </div>
        </section>
    </main>

    <?php include 'modern_footer_component.php'; ?>

    <!-- JavaScript -->
    <script>
        // Add some interactive effects
        document.addEventListener('DOMContentLoaded', () => {
            // Animate elements on scroll
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('animate-fade-in');
                    }
                });
            }, observerOptions);
            
            // Observe all cards and sections
            document.querySelectorAll('.team-card, .stat-card, section').forEach(element => {
                observer.observe(element);
            });
            
            // Counter animation for statistics
            const counters = document.querySelectorAll('.stat-card .text-4xl');
            counters.forEach(counter => {
                const target = parseInt(counter.textContent.replace(/[^\d]/g, ''));
                const increment = target / 100;
                let current = 0;
                
                const updateCounter = () => {
                    if (current < target) {
                        current += increment;
                        counter.textContent = Math.ceil(current) + counter.textContent.replace(/[\d]/g, '').replace(/[^\D]/g, '');
                        requestAnimationFrame(updateCounter);
                    } else {
                        counter.textContent = target + counter.textContent.replace(/[\d]/g, '').replace(/[^\D]/g, '');
                    }
                };
                
                // Start counter when element is visible
                const counterObserver = new IntersectionObserver((entries) => {
                    entries.forEach(entry => {
                        if (entry.isIntersecting) {
                            updateCounter();
                            counterObserver.unobserve(entry.target);
                        }
                    });
                });
                
                counterObserver.observe(counter);
            });
        });
    </script>
    
    <?php include 'cart_component.php'; ?>
</body>
</html>
