<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contact Us - Honoré Bakery</title>
    <meta name="description" content="Get in touch with Honoré Bakery. Contact us for orders, inquiries, or visit our stores. We're here to help with all your bakery and floral needs.">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'playfair': ['Playfair Display', 'serif'],
                        'inter': ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'amber': {
                            50: '#fffbeb',
                            100: '#fef3c7',
                            200: '#fde68a',
                            300: '#fcd34d',
                            400: '#fbbf24',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309',
                            800: '#92400e',
                            900: '#78350f',
                        }
                    },
                    animation: {
                        'fade-in': 'fadeIn 0.5s ease-in-out',
                        'slide-up': 'slideUp 0.5s ease-out',
                        'bounce-slow': 'bounce 2s infinite',
                    },
                    keyframes: {
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' },
                        },
                        slideUp: {
                            '0%': { transform: 'translateY(20px)', opacity: '0' },
                            '100%': { transform: 'translateY(0)', opacity: '1' },
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        .glass-effect {
            background: rgba(255, 255, 255, 0.25);
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.18);
        }
        
        .gradient-text {
            background: linear-gradient(135deg, #d97706, #f59e0b, #fbbf24);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .form-input {
            transition: all 0.3s ease;
        }
        
        .form-input:focus {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px rgba(217, 119, 6, 0.2);
        }
        
        .contact-card {
            transition: all 0.3s cubic-bezier(0.4, 0, 0.2, 1);
        }
        
        .contact-card:hover {
            transform: translateY(-5px);
            box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.15);
        }
        
        .map-container {
            border-radius: 20px;
            overflow: hidden;
            box-shadow: 0 20px 40px -12px rgba(0, 0, 0, 0.15);
        }
        
        .category-scroll::-webkit-scrollbar {
            display: none;
        }
        
        .category-scroll {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        
        .search-dropdown {
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.95);
        }
    </style>
</head>
<body class="font-inter bg-amber-50 text-gray-900">
    <?php include 'header_component.php'; ?>

    <!-- Main Content -->
    <main>
        <!-- Hero Section -->
        <section class="py-16 bg-gradient-to-r from-amber-600 to-amber-700">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h1 class="text-5xl md:text-6xl font-playfair font-bold text-white mb-4">
                    Get in <span class="text-amber-200">Touch</span>
                </h1>
                <p class="text-xl text-amber-100 max-w-3xl mx-auto">
                    We'd love to hear from you! Whether you have questions, need assistance, or want to place a special order, we're here to help.
                </p>
            </div>
        </section>

        <!-- Contact Form & Info -->
        <section class="py-20">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="grid grid-cols-1 lg:grid-cols-2 gap-16">
                    <!-- Contact Form -->
                    <div class="bg-white rounded-3xl shadow-2xl p-8 lg:p-12">
                        <h2 class="text-3xl font-playfair font-bold text-gray-900 mb-8">
                            Send us a <span class="gradient-text">Message</span>
                        </h2>
                        
                        <form id="contact-form" class="space-y-6">
                            <!-- Name -->
                            <div>
                                <label for="name" class="block text-sm font-medium text-gray-700 mb-2">
                                    Full Name *
                                </label>
                                <div class="relative">
                                    <input type="text" id="name" name="name" required
                                           class="form-input w-full px-4 py-3 pl-12 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent"
                                           placeholder="Enter your full name">
                                    <i class="fas fa-user absolute left-4 top-4 text-gray-400"></i>
                                </div>
                            </div>
                            
                            <!-- Email -->
                            <div>
                                <label for="email" class="block text-sm font-medium text-gray-700 mb-2">
                                    Email Address *
                                </label>
                                <div class="relative">
                                    <input type="email" id="email" name="email" required
                                           class="form-input w-full px-4 py-3 pl-12 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent"
                                           placeholder="Enter your email address">
                                    <i class="fas fa-envelope absolute left-4 top-4 text-gray-400"></i>
                                </div>
                            </div>
                            
                            <!-- Phone -->
                            <div>
                                <label for="phone" class="block text-sm font-medium text-gray-700 mb-2">
                                    Phone Number
                                </label>
                                <div class="relative">
                                    <input type="tel" id="phone" name="phone"
                                           class="form-input w-full px-4 py-3 pl-12 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent"
                                           placeholder="Enter your phone number">
                                    <i class="fas fa-phone absolute left-4 top-4 text-gray-400"></i>
                                </div>
                            </div>
                            
                            <!-- Subject -->
                            <div>
                                <label for="subject" class="block text-sm font-medium text-gray-700 mb-2">
                                    Subject *
                                </label>
                                <div class="relative">
                                    <select id="subject" name="subject" required
                                            class="form-input w-full px-4 py-3 pl-12 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent">
                                        <option value="">Select a subject</option>
                                        <option value="general">General Inquiry</option>
                                        <option value="order">Order Inquiry</option>
                                        <option value="catering">Catering Services</option>
                                        <option value="custom">Custom Order</option>
                                        <option value="complaint">Complaint</option>
                                        <option value="feedback">Feedback</option>
                                        <option value="other">Other</option>
                                    </select>
                                    <i class="fas fa-tag absolute left-4 top-4 text-gray-400"></i>
                                </div>
                            </div>
                            
                            <!-- Message -->
                            <div>
                                <label for="message" class="block text-sm font-medium text-gray-700 mb-2">
                                    Message *
                                </label>
                                <div class="relative">
                                    <textarea id="message" name="message" rows="6" required
                                              class="form-input w-full px-4 py-3 pl-12 border border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent resize-none"
                                              placeholder="Tell us how we can help you..."></textarea>
                                    <i class="fas fa-comment absolute left-4 top-4 text-gray-400"></i>
                                </div>
                            </div>
                            
                            <!-- Submit Button -->
                            <button type="submit" id="submit-btn"
                                    class="w-full bg-gradient-to-r from-amber-600 to-amber-700 hover:from-amber-700 hover:to-amber-800 text-white py-4 rounded-xl font-semibold transition-all duration-300 transform hover:scale-105 shadow-lg">
                                <span id="submit-text">Send Message</span>
                                <div id="submit-spinner" class="hidden">
                                    <i class="fas fa-spinner fa-spin mr-2"></i>
                                    Sending...
                                </div>
                            </button>
                        </form>
                    </div>
                    
                    <!-- Contact Information -->
                    <div class="space-y-8">
                        <!-- Contact Cards -->
                        <div class="space-y-6">
                            <h2 class="text-3xl font-playfair font-bold text-gray-900 mb-8">
                                Contact <span class="gradient-text">Information</span>
                            </h2>
                            
                            <!-- Phone -->
                            <div class="contact-card bg-white rounded-2xl p-6 shadow-lg">
                                <div class="flex items-center">
                                    <div class="w-12 h-12 bg-amber-100 rounded-full flex items-center justify-center mr-4">
                                        <i class="fas fa-phone text-amber-600"></i>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-semibold text-gray-900">Phone</h3>
                                        <p class="text-gray-600">+91 98765 43210</p>
                                        <p class="text-sm text-gray-500">Mon-Fri: 8AM-8PM, Sat-Sun: 9AM-6PM</p>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Email -->
                            <div class="contact-card bg-white rounded-2xl p-6 shadow-lg">
                                <div class="flex items-center">
                                    <div class="w-12 h-12 bg-amber-100 rounded-full flex items-center justify-center mr-4">
                                        <i class="fas fa-envelope text-amber-600"></i>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-semibold text-gray-900">Email</h3>
                                        <p class="text-gray-600">hello@honorebakery.com</p>
                                        <p class="text-sm text-gray-500">We'll respond within 24 hours</p>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Address -->
                            <div class="contact-card bg-white rounded-2xl p-6 shadow-lg">
                                <div class="flex items-center">
                                    <div class="w-12 h-12 bg-amber-100 rounded-full flex items-center justify-center mr-4">
                                        <i class="fas fa-map-marker-alt text-amber-600"></i>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-semibold text-gray-900">Main Store</h3>
                                        <p class="text-gray-600">123 Baker Street<br>Downtown District<br>Mumbai, Maharashtra 400001</p>
                                        <p class="text-sm text-gray-500">Free parking available</p>
                                    </div>
                                </div>
                            </div>
                            
                            <!-- Hours -->
                            <div class="contact-card bg-white rounded-2xl p-6 shadow-lg">
                                <div class="flex items-center">
                                    <div class="w-12 h-12 bg-amber-100 rounded-full flex items-center justify-center mr-4">
                                        <i class="fas fa-clock text-amber-600"></i>
                                    </div>
                                    <div>
                                        <h3 class="text-lg font-semibold text-gray-900">Store Hours</h3>
                                        <div class="text-gray-600 space-y-1">
                                            <p>Monday - Friday: 6:00 AM - 8:00 PM</p>
                                            <p>Saturday: 6:00 AM - 8:00 PM</p>
                                            <p>Sunday: 7:00 AM - 6:00 PM</p>
                                        </div>
                                        <p class="text-sm text-gray-500 mt-2">Delivery available until 9PM</p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Quick Actions -->
                        <div class="bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-4">Quick Actions</h3>
                            <div class="space-y-3">
                                <a href="/orders" class="flex items-center p-3 bg-white rounded-lg hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-shipping-fast text-amber-600 mr-3"></i>
                                    <span class="text-gray-700">Track Your Order</span>
                                </a>
                                <a href="/products" class="flex items-center p-3 bg-white rounded-lg hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-shopping-bag text-amber-600 mr-3"></i>
                                    <span class="text-gray-700">Browse Products</span>
                                </a>
                                <a href="/events" class="flex items-center p-3 bg-white rounded-lg hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-calendar-alt text-amber-600 mr-3"></i>
                                    <span class="text-gray-700">Book Catering</span>
                                </a>
                                <a href="/stores" class="flex items-center p-3 bg-white rounded-lg hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-map-marker-alt text-amber-600 mr-3"></i>
                                    <span class="text-gray-700">Find Store Near You</span>
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>

        <!-- Map Section -->
        <section class="py-20 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-16">
                    <h2 class="text-4xl md:text-5xl font-playfair font-bold text-gray-900 mb-4">
                        Find Us on the <span class="gradient-text">Map</span>
                    </h2>
                    <p class="text-xl text-gray-600 max-w-3xl mx-auto">
                        Visit our main store or any of our locations across the city. We're always happy to welcome you!
                    </p>
                </div>
                
                <!-- Map Placeholder -->
                <div class="map-container bg-gradient-to-br from-amber-100 to-amber-200 h-96 flex items-center justify-center">
                    <div class="text-center">
                        <i class="fas fa-map-marked-alt text-6xl text-amber-600 mb-4"></i>
                        <h3 class="text-2xl font-semibold text-gray-900 mb-2">Interactive Map</h3>
                        <p class="text-gray-600 mb-4">Click to view our store locations</p>
                        <button class="bg-amber-600 hover:bg-amber-700 text-white px-6 py-3 rounded-lg font-semibold transition-colors">
                            <i class="fas fa-external-link-alt mr-2"></i>Open in Maps
                        </button>
                    </div>
                </div>
                
                <!-- Store Locations -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-8 mt-16">
                    <div class="bg-white rounded-2xl p-6 shadow-lg">
                        <h3 class="text-xl font-semibold text-gray-900 mb-3">Main Store</h3>
                        <div class="space-y-2 text-gray-600">
                            <p><i class="fas fa-map-marker-alt text-amber-600 mr-2"></i>123 Baker Street, Downtown</p>
                            <p><i class="fas fa-phone text-amber-600 mr-2"></i>+91 98765 43210</p>
                            <p><i class="fas fa-clock text-amber-600 mr-2"></i>6AM - 8PM Daily</p>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-2xl p-6 shadow-lg">
                        <h3 class="text-xl font-semibold text-gray-900 mb-3">Westside Branch</h3>
                        <div class="space-y-2 text-gray-600">
                            <p><i class="fas fa-map-marker-alt text-amber-600 mr-2"></i>456 Market Square, Westside</p>
                            <p><i class="fas fa-phone text-amber-600 mr-2"></i>+91 98765 43211</p>
                            <p><i class="fas fa-clock text-amber-600 mr-2"></i>7AM - 7PM Daily</p>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-2xl p-6 shadow-lg">
                        <h3 class="text-xl font-semibold text-gray-900 mb-3">Eastside Branch</h3>
                        <div class="space-y-2 text-gray-600">
                            <p><i class="fas fa-map-marker-alt text-amber-600 mr-2"></i>789 Garden Plaza, Eastside</p>
                            <p><i class="fas fa-phone text-amber-600 mr-2"></i>+91 98765 43212</p>
                            <p><i class="fas fa-clock text-amber-600 mr-2"></i>6AM - 8PM Daily</p>
                        </div>
                    </div>
                </div>
            </div>
        </section>

    </main>

    <?php include 'modern_footer_component.php'; ?>

    <!-- JavaScript -->
    <script>
        // Contact Form JavaScript
        class ContactForm {
            constructor() {
                this.init();
            }
            
            init() {
                this.initFormSubmission();
                this.initFormValidation();
            }
            
            initFormSubmission() {
                const form = document.getElementById('contact-form');
                const submitBtn = document.getElementById('submit-btn');
                const submitText = document.getElementById('submit-text');
                const submitSpinner = document.getElementById('submit-spinner');
                
                form.addEventListener('submit', async (e) => {
                    e.preventDefault();
                    
                    // Show loading state
                    submitText.classList.add('hidden');
                    submitSpinner.classList.remove('hidden');
                    submitBtn.disabled = true;
                    
                    // Get form data
                    const formData = new FormData(form);
                    const contactData = {
                        name: formData.get('name'),
                        email: formData.get('email'),
                        phone: formData.get('phone'),
                        subject: formData.get('subject'),
                        message: formData.get('message')
                    };
                    
                    try {
                        // Simulate API call
                        await this.simulateContactSubmission(contactData);
                        
                        // Show success message
                        this.showNotification('Message sent successfully! We\'ll get back to you soon.', 'success');
                        
                        // Reset form
                        form.reset();
                        
                    } catch (error) {
                        // Show error message
                        this.showNotification(error.message, 'error');
                    } finally {
                        // Reset form state
                        submitText.classList.remove('hidden');
                        submitSpinner.classList.add('hidden');
                        submitBtn.disabled = false;
                    }
                });
            }
            
            async simulateContactSubmission(contactData) {
                // Simulate API delay
                await new Promise(resolve => setTimeout(resolve, 2000));
                
                // Simulate validation
                if (!contactData.name || !contactData.email || !contactData.subject || !contactData.message) {
                    throw new Error('Please fill in all required fields');
                }
                
                if (!this.isValidEmail(contactData.email)) {
                    throw new Error('Please enter a valid email address');
                }
                
                // Simulate successful submission
                return { success: true, messageId: 'MSG_' + Date.now() };
            }
            
            isValidEmail(email) {
                const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
                return emailRegex.test(email);
            }
            
            initFormValidation() {
                const inputs = document.querySelectorAll('.form-input');
                
                inputs.forEach(input => {
                    input.addEventListener('blur', () => {
                        this.validateField(input);
                    });
                    
                    input.addEventListener('input', () => {
                        this.clearFieldError(input);
                    });
                });
            }
            
            validateField(field) {
                const value = field.value.trim();
                const fieldName = field.name;
                
                // Clear previous errors
                this.clearFieldError(field);
                
                // Validate based on field type
                if (field.required && !value) {
                    this.showFieldError(field, `${this.getFieldLabel(fieldName)} is required`);
                    return false;
                }
                
                if (fieldName === 'email' && value && !this.isValidEmail(value)) {
                    this.showFieldError(field, 'Please enter a valid email address');
                    return false;
                }
                
                if (fieldName === 'phone' && value && !this.isValidPhone(value)) {
                    this.showFieldError(field, 'Please enter a valid phone number');
                    return false;
                }
                
                return true;
            }
            
            isValidPhone(phone) {
                const phoneRegex = /^[\+]?[1-9][\d]{0,15}$/;
                return phoneRegex.test(phone.replace(/\s/g, ''));
            }
            
            getFieldLabel(fieldName) {
                const labels = {
                    name: 'Name',
                    email: 'Email',
                    phone: 'Phone',
                    subject: 'Subject',
                    message: 'Message'
                };
                return labels[fieldName] || fieldName;
            }
            
            showFieldError(field, message) {
                field.classList.add('border-red-500', 'focus:ring-red-500');
                
                const errorDiv = document.createElement('div');
                errorDiv.className = 'text-red-500 text-sm mt-1 field-error';
                errorDiv.textContent = message;
                
                field.parentNode.appendChild(errorDiv);
            }
            
            clearFieldError(field) {
                field.classList.remove('border-red-500', 'focus:ring-red-500');
                
                const errorDiv = field.parentNode.querySelector('.field-error');
                if (errorDiv) {
                    errorDiv.remove();
                }
            }
            
            showNotification(message, type = 'info') {
                // Remove existing notifications
                const existingNotifications = document.querySelectorAll('.notification');
                existingNotifications.forEach(notification => notification.remove());
                
                // Create notification
                const notification = document.createElement('div');
                notification.className = 'notification fixed top-20 right-4 px-6 py-3 rounded-lg shadow-lg z-50 transform translate-x-full transition-transform duration-300';
                
                // Set colors based on type
                switch (type) {
                    case 'success':
                        notification.className += ' bg-green-500 text-white';
                        break;
                    case 'error':
                        notification.className += ' bg-red-500 text-white';
                        break;
                    case 'info':
                        notification.className += ' bg-blue-500 text-white';
                        break;
                    default:
                        notification.className += ' bg-gray-500 text-white';
                }
                
                // Set icon based on type
                let icon = 'fas fa-info-circle';
                switch (type) {
                    case 'success':
                        icon = 'fas fa-check-circle';
                        break;
                    case 'error':
                        icon = 'fas fa-exclamation-circle';
                        break;
                    case 'info':
                        icon = 'fas fa-info-circle';
                        break;
                }
                
                notification.innerHTML = `<i class="${icon} mr-2"></i>${message}`;
                
                document.body.appendChild(notification);
                
                // Animate in
                setTimeout(() => {
                    notification.classList.remove('translate-x-full');
                }, 100);
                
                // Animate out
                setTimeout(() => {
                    notification.classList.add('translate-x-full');
                    setTimeout(() => {
                        if (notification.parentNode) {
                            notification.parentNode.removeChild(notification);
                        }
                    }, 300);
                }, 4000);
            }
        }
        
        // Initialize the contact form
        const contactForm = new ContactForm();
        
        // Add some interactive effects
        document.addEventListener('DOMContentLoaded', () => {
            // Animate elements on scroll
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('animate-fade-in');
                    }
                });
            }, observerOptions);
            
            // Observe all cards and sections
            document.querySelectorAll('.contact-card, section').forEach(element => {
                observer.observe(element);
            });
        });
    </script>
    
    <?php include 'cart_component.php'; ?>
</body>
</html>
