<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>FAQ - Honoré Bakery</title>
    <meta name="description" content="Frequently Asked Questions about Honoré Bakery - Find answers to common questions about our products, delivery, orders, and services.">
    <meta name="keywords" content="FAQ, frequently asked questions, bakery questions, delivery, orders, custom cakes">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'playfair': ['Playfair Display', 'serif'],
                        'inter': ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'amber': {
                            50: '#fffbeb',
                            100: '#fef3c7',
                            200: '#fde68a',
                            300: '#fcd34d',
                            400: '#fbbf24',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309',
                            800: '#92400e',
                            900: '#78350f',
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        .gradient-text {
            background: linear-gradient(135deg, #d97706, #f59e0b, #fbbf24);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .faq-item {
            transition: all 0.3s ease;
        }
        
        .faq-item:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 25px -5px rgba(0, 0, 0, 0.1);
        }
        
        .faq-answer {
            max-height: 0;
            overflow: hidden;
            transition: max-height 0.3s ease-out;
        }
        
        .faq-answer.active {
            max-height: 200px;
        }
        
        .faq-icon {
            transition: transform 0.3s ease;
        }
        
        .faq-icon.rotated {
            transform: rotate(180deg);
        }
    </style>
</head>
<body class="font-inter bg-amber-50 text-gray-900">
    <?php include 'header_component.php'; ?>

    <!-- Main Content -->
    <main>
        <!-- Hero Section -->
        <section class="py-16 bg-gradient-to-r from-amber-600 to-amber-700">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h1 class="text-5xl md:text-6xl font-playfair font-bold text-white mb-4">
                    Frequently Asked <span class="text-amber-200">Questions</span>
                </h1>
                <p class="text-xl text-amber-100 max-w-3xl mx-auto">
                    Find answers to common questions about our products, delivery, orders, and services.
                </p>
            </div>
        </section>

        <!-- FAQ Section -->
        <section class="py-20 bg-white">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                
                <!-- Search Bar -->
                <div class="mb-12">
                    <div class="relative max-w-2xl mx-auto">
                        <input type="text" id="faq-search" placeholder="Search our FAQ..." 
                               class="w-full px-6 py-4 pr-16 border-2 border-gray-200 rounded-xl focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent text-lg">
                        <button class="absolute right-4 top-4 text-gray-400 hover:text-amber-600">
                            <i class="fas fa-search text-xl"></i>
                        </button>
                    </div>
                </div>

                <!-- FAQ Items -->
                <div class="space-y-6">
                    
                    <!-- Order Confirmation -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Why haven't I received confirmation of my order?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">It may be possible that the confirmation email has gone into your junk/spam/promotion folder. Please check there for your confirmation, particularly for Gmail, Hotmail, Outlook & Yahoo accounts. If you still haven't received a confirmation email, please contact our customer service at +91 98765 43210, and they will be happy to help.</p>
                        </div>
                    </div>

                    <!-- How to Place Order -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">How do we place an order?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">You can place your order on our website or visit our stores directly. For custom orders, please call us at +91 98765 43210. We're happy to help with any questions you may have about our products or services.</p>
                        </div>
                    </div>

                    <!-- Store Locations -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Where are your stores located?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">We have three convenient locations: Main Store at 123 Baker Street, Downtown; Westside Branch at 456 Market Square, Westside; and Eastside Branch at 789 Garden Plaza, Eastside. All our deliveries are fulfilled from our main kitchen located in Downtown.</p>
                        </div>
                    </div>

                    <!-- Phone Orders -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Can we place an order through phone or email?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">Yes! You can place orders by calling us at +91 98765 43210 or emailing us at hello@honorebakery.com. Our customer service team will be happy to help with any questions regarding online orders, complaints, or returns.</p>
                        </div>
                    </div>

                    <!-- Damaged Products -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">I received a damaged product. What should I do?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">We are sorry to hear about your damaged product. We conduct intensive quality checks in line with the highest standards. However, if you receive an item that is not in perfect condition, please contact us at +91 98765 43210 within 4 hours of delivery, and we will either replace the product or provide a refund up to 30% of the cost after receiving a picture of the damaged product.</p>
                        </div>
                    </div>

                    <!-- Immediate Orders -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Can we get a cake immediately?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">We only bake to order because we're BIG on fresh. It will take a minimum of 4 hours. However, we do have some of our bestsellers available at our stores that can be picked up immediately. You can call us at +91 98765 43210, and we'll try our best to accommodate your request.</p>
                        </div>
                    </div>

                    <!-- Bestsellers -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">What are your bestsellers?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">Our most popular items include Chocolate Truffle Cake, Red Velvet Cake, Tiramisu, Chocolate Chip Cookies, Croissants, and our signature Sourdough Bread. We also have seasonal specialties that change throughout the year.</p>
                        </div>
                    </div>

                    <!-- Custom Cakes -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">How do we place an order for a customized cake?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">Call us at +91 98765 43210 or visit our stores. We need a minimum of 48 hours' notice to execute a customized cake. For elaborate designs, we may require up to one week's notice. We can accommodate dietary restrictions and special themes.</p>
                        </div>
                    </div>

                    <!-- Pickup -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Can we pick up the cake? Why are delivery charges so high?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">Yes, you can pick up orders from any of our three store locations. Our delivery charges are based on distance and delivery partner costs. We offer free delivery on orders above ₹500. For urgent deliveries, additional charges may apply.</p>
                        </div>
                    </div>

                    <!-- Why Honoré Bakery -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Why Honoré Bakery?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">Our ganache/frosting to sponge ratio is higher and in line with most European baking. We use only dairy cream and premium ingredients. We don't compromise on quality - most places use cheaper ingredients to make cakes appear fluffy and big, but looks can be deceptive. We're committed to educating customers about quality ingredients and authentic baking.</p>
                        </div>
                    </div>

                    <!-- Cancel Orders -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">How can I cancel or amend my order?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">No changes or cancellations can be done on the same day of delivery. To cancel or amend your order, please call us at +91 98765 43210 or email your request along with the order number to hello@honorebakery.com at least 24 hours before delivery.</p>
                        </div>
                    </div>

                    <!-- Refunds -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Do you offer refunds on cancellations?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">We do not offer refunds on cancellations, but we will provide you with Honoré Bakery store credit that can be used within 45 days of the date of issue. This credit can be used for any future orders.</p>
                        </div>
                    </div>

                    <!-- Vegetarian Options -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Do you have vegetarian options?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">Yes! We have a variety of eggless options including Chocolate Truffle Cake, Vanilla Sponge Cake, Blueberry Cheesecake, Pineapple Cake, Red Velvet Cake, and many more. All our eggless products are clearly marked and prepared separately to avoid cross-contamination.</p>
                        </div>
                    </div>

                    <!-- Sugar-Free Options -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">Do you have sugar-free cakes?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">Yes, we offer sugar-free cakes using natural sweeteners like Stevia and Erythritol. Our sugar-free options include Chocolate Cake, Vanilla Cake, and some specialty flavors. Please call us to discuss your specific requirements.</p>
                        </div>
                    </div>

                    <!-- Delivery Hours -->
                    <div class="faq-item bg-white rounded-2xl shadow-lg border border-gray-100">
                        <button class="w-full text-left p-6 focus:outline-none focus:ring-2 focus:ring-amber-500 rounded-2xl" onclick="toggleFAQ(this)">
                            <div class="flex justify-between items-center">
                                <h3 class="text-lg font-semibold text-gray-900">What are your delivery hours?</h3>
                                <i class="fas fa-chevron-down text-amber-600 faq-icon"></i>
                            </div>
                        </button>
                        <div class="faq-answer px-6 pb-6">
                            <p class="text-gray-600">We offer delivery from 8AM to 9PM, seven days a week. Orders placed before 7PM will be delivered the same day. For urgent orders, please call us directly at +91 98765 43210, and we'll try our best to accommodate your request.</p>
                        </div>
                    </div>

                </div>

            </div>
        </section>

        <!-- Contact Section - Full Width -->
        <section class="py-16 bg-amber-50">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h3 class="text-2xl font-playfair font-bold text-gray-900 mb-4">
                    Still have <span class="gradient-text">questions?</span>
                </h3>
                <p class="text-gray-600 mb-6">
                    Can't find the answer you're looking for? We're here to help!
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center">
                    <a href="tel:+919876543210" class="bg-amber-600 hover:bg-amber-700 text-white px-8 py-3 rounded-full font-semibold transition-colors">
                        <i class="fas fa-phone mr-2"></i> Call Us
                    </a>
                    <a href="mailto:hello@honorebakery.com" class="border-2 border-amber-600 text-amber-600 hover:bg-amber-600 hover:text-white px-8 py-3 rounded-full font-semibold transition-colors">
                        <i class="fas fa-envelope mr-2"></i> Email Us
                    </a>
                </div>
            </div>
        </section>
    </main>

    <?php include 'modern_footer_component.php'; ?>

    <!-- JavaScript -->
    <script>
        // FAQ Toggle Function
        function toggleFAQ(button) {
            const content = button.nextElementSibling;
            const icon = button.querySelector('.faq-icon');
            
            if (content.classList.contains('active')) {
                content.classList.remove('active');
                icon.classList.remove('rotated');
            } else {
                // Close all other FAQ items
                document.querySelectorAll('.faq-answer.active').forEach(item => {
                    item.classList.remove('active');
                });
                document.querySelectorAll('.faq-icon.rotated').forEach(item => {
                    item.classList.remove('rotated');
                });
                
                // Open current FAQ item
                content.classList.add('active');
                icon.classList.add('rotated');
            }
        }

        // FAQ Search Functionality
        document.addEventListener('DOMContentLoaded', function() {
            const searchInput = document.getElementById('faq-search');
            const faqItems = document.querySelectorAll('.faq-item');
            
            if (searchInput) {
                searchInput.addEventListener('input', function() {
                    const searchTerm = this.value.toLowerCase();
                    
                    faqItems.forEach(item => {
                        const question = item.querySelector('h3').textContent.toLowerCase();
                        const answer = item.querySelector('.faq-answer p').textContent.toLowerCase();
                        
                        if (question.includes(searchTerm) || answer.includes(searchTerm)) {
                            item.style.display = 'block';
                        } else {
                            item.style.display = 'none';
                        }
                    });
                });
            }
        });
    </script>
    
    <?php include 'cart_component.php'; ?>
</body>
</html>
