<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Honoré Bakery - Artisan Breads, Pastries & Flowers</title>
    <meta name="description" content="Premium artisan bakery offering fresh breads, pastries, cakes, and beautiful flowers. Handcrafted with love, delivered with care across multiple cities.">
    <meta name="keywords" content="artisan bakery, fresh bread, pastries, cakes, flowers, delivery, premium quality">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'playfair': ['Playfair Display', 'serif'],
                        'inter': ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'amber': {
                            50: '#fffbeb',
                            100: '#fef3c7',
                            200: '#fde68a',
                            300: '#fcd34d',
                            400: '#fbbf24',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309',
                            800: '#92400e',
                            900: '#78350f',
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        .gradient-text {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .font-playfair { font-family: 'Playfair Display', serif; }
        .font-inter { font-family: 'Inter', sans-serif; }
        
        /* Smooth scrolling */
        html {
            scroll-behavior: smooth;
        }
        
        /* Custom animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(30px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }
        
        .animate-fadeInUp {
            animation: fadeInUp 0.6s ease-out;
        }
        
        /* Floating icons animation */
        @keyframes float {
            0%, 100% { transform: translateY(0px); }
            50% { transform: translateY(-10px); }
        }
        
        .animate-float {
            animation: float 3s ease-in-out infinite;
        }
        
        .animate-float-delayed {
            animation: float 3s ease-in-out infinite 1.5s;
        }
        
        /* Hero Slider Styles */
        .hero-slide {
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            transition: opacity 2s ease-in-out;
        }
        
        .hero-slide.active {
            opacity: 1;
        }
        
        .hero-slide:not(.active) {
            opacity: 0;
        }
        
        /* Enhanced Title Effects - Minimal Style */
        .hero-title-enhanced {
            text-shadow: 
                0 0 8px rgba(255, 255, 255, 0.9),
                0 0 16px rgba(255, 255, 255, 0.7),
                2px 2px 4px rgba(0, 0, 0, 0.8),
                -2px -2px 4px rgba(0, 0, 0, 0.8),
                2px -2px 4px rgba(0, 0, 0, 0.8),
                -2px 2px 4px rgba(0, 0, 0, 0.8);
            color: #f59e0b;
        }
        
        /* Enhanced Tagline Effects - Minimal Style */
        .hero-tagline-enhanced {
            text-shadow: 
                0 0 6px rgba(0, 0, 0, 0.9),
                0 0 12px rgba(0, 0, 0, 0.7),
                2px 2px 3px rgba(0, 0, 0, 0.9);
            background: rgba(0, 0, 0, 0.4);
            padding: 1rem 2rem;
            border-radius: 0.5rem;
            border: 1px solid rgba(255, 255, 255, 0.3);
        }
    </style>
</head>
<body class="font-inter bg-amber-50 text-gray-900">
    <?php include 'header_component.php'; ?>
    
    <!-- Main Content -->
    <main>
        <!-- Hero Section -->
        <section class="relative h-screen flex items-center justify-center overflow-hidden">
            <!-- Background Image Slider -->
            <div class="absolute inset-0 bg-gradient-to-br from-amber-100 via-amber-200 to-amber-300">
                <!-- Slider Images -->
                <div class="hero-slider absolute inset-0">
                    <div class="hero-slide active opacity-100" style="background-image: url('modules/website/uploads/bakery1.jpg'); background-size: cover; background-position: center; background-repeat: no-repeat;"></div>
                    <div class="hero-slide opacity-0" style="background-image: url('modules/website/uploads/bakery2.jpg'); background-size: cover; background-position: center; background-repeat: no-repeat;"></div>
                </div>
                <!-- Overlay for better text readability -->
                <div class="absolute inset-0 bg-black bg-opacity-30"></div>
            </div>
            
            <!-- Floating Icons -->
            <div class="absolute top-20 left-10 text-amber-200 text-4xl animate-float">
                <i class="fas fa-bread-slice"></i>
            </div>
            <div class="absolute top-32 right-16 text-amber-200 text-3xl animate-float-delayed">
                <i class="fas fa-birthday-cake"></i>
            </div>
            <div class="absolute bottom-32 left-16 text-amber-200 text-3xl animate-float">
                <i class="fas fa-cookie-bite"></i>
            </div>
            <div class="absolute bottom-20 right-12 text-green-300 text-2xl animate-float-delayed">
                <i class="fas fa-seedling"></i>
            </div>
            
            <!-- Hero Content -->
            <div class="relative z-10 text-center px-4 max-w-4xl mx-auto">
                <h1 class="text-6xl md:text-8xl font-playfair font-bold hero-title-enhanced mb-6 animate-fadeInUp">
                    Honoré Bakery
                </h1>
                <p class="text-xl md:text-2xl text-white mb-8 leading-relaxed animate-fadeInUp hero-tagline-enhanced" style="animation-delay: 0.2s;">
                    Handcrafted with love, delivered with care. Premium quality breads, pastries, cakes, and beautiful flowers for every occasion.
                </p>
                <div class="flex flex-col sm:flex-row gap-4 justify-center animate-fadeInUp" style="animation-delay: 0.4s;">
                    <a href="/releasepymnstpro/erp-ecom/products" class="bg-amber-600 hover:bg-amber-700 text-white px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 flex items-center justify-center">
                        <i class="fas fa-shopping-bag mr-3"></i>
                        Shop Now
                    </a>
                    <a href="/releasepymnstpro/erp-ecom/about" class="border-2 border-white text-white hover:bg-white hover:text-amber-600 px-8 py-4 rounded-full text-lg font-semibold transition-all duration-300 transform hover:scale-105 flex items-center justify-center">
                        <i class="fas fa-play mr-3"></i>
                        Our Story
                    </a>
                </div>
            </div>
        </section>

        <!-- Category Navigation -->
        <section class="py-16 bg-white">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="text-center mb-12">
                    <h2 class="text-4xl font-playfair font-bold text-gray-900 mb-4">Our Collections</h2>
                    <p class="text-lg text-gray-600 max-w-2xl mx-auto">Discover our handcrafted selection of artisanal breads, decadent pastries, celebration cakes, and beautiful floral arrangements.</p>
                </div>
                
                <div class="grid grid-cols-2 md:grid-cols-4 gap-6">
                    <!-- Breads -->
                    <a href="/releasepymnstpro/erp-ecom/products" class="group bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-6 text-center hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                        <div class="w-16 h-16 bg-amber-500 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-amber-600 transition-colors">
                            <i class="fas fa-bread-slice text-white text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Breads</h3>
                        <p class="text-gray-600 text-sm">Artisan sourdough, baguettes, and specialty loaves</p>
                    </a>
                    
                    <!-- Pastries -->
                    <a href="/releasepymnstpro/erp-ecom/products" class="group bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-6 text-center hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                        <div class="w-16 h-16 bg-amber-500 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-amber-600 transition-colors">
                            <i class="fas fa-cookie-bite text-white text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Pastries</h3>
                        <p class="text-gray-600 text-sm">Croissants, danishes, and sweet treats</p>
                    </a>
                    
                    <!-- Cakes -->
                    <a href="/releasepymnstpro/erp-ecom/products" class="group bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-6 text-center hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                        <div class="w-16 h-16 bg-amber-500 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-amber-600 transition-colors">
                            <i class="fas fa-birthday-cake text-white text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Cakes</h3>
                        <p class="text-gray-600 text-sm">Celebration cakes and custom designs</p>
                    </a>
                    
                    <!-- Flowers -->
                    <a href="/releasepymnstpro/erp-ecom/products" class="group bg-gradient-to-br from-amber-50 to-amber-100 rounded-2xl p-6 text-center hover:shadow-xl transition-all duration-300 transform hover:scale-105">
                        <div class="w-16 h-16 bg-amber-500 rounded-full flex items-center justify-center mx-auto mb-4 group-hover:bg-amber-600 transition-colors">
                            <i class="fas fa-seedling text-white text-2xl"></i>
                        </div>
                        <h3 class="text-xl font-semibold text-gray-900 mb-2">Flowers</h3>
                        <p class="text-gray-600 text-sm">Fresh bouquets and floral arrangements</p>
                    </a>
                </div>
            </div>
        </section>

        <!-- Product Filter Section -->
        <section class="py-16 bg-gray-50">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <!-- Filter Bar -->
                <div class="bg-transparent rounded-lg p-6 mb-12">
                    <div class="flex flex-wrap gap-4 justify-center items-center">
                        <!-- Eggless Toggle -->
                        <div class="flex items-center">
                            <input type="checkbox" id="eggless-toggle" class="sr-only">
                            <label for="eggless-toggle" class="flex items-center cursor-pointer">
                                <div class="relative">
                                    <input type="checkbox" id="eggless-checkbox" class="sr-only">
                                    <div class="w-10 h-6 bg-gray-300 rounded-full shadow-inner transition-colors duration-300 ease-in-out"></div>
                                    <div class="absolute top-1 left-1 w-4 h-4 bg-white rounded-full shadow transition-transform duration-300 ease-in-out"></div>
                                </div>
                                <span class="ml-3 text-sm font-medium text-gray-700">Eggless Only</span>
                            </label>
                        </div>
                        
                        <!-- Collection Filter -->
                        <div class="flex items-center">
                            <label for="collection-select" class="text-sm font-medium text-gray-700 mr-3">Collection:</label>
                            <select id="collection-select" class="bg-white border border-gray-300 rounded-lg px-4 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent">
                                <option value="">All Collections</option>
                                <option value="bread">Breads</option>
                                <option value="pastries">Pastries</option>
                                <option value="cakes">Cakes</option>
                                <option value="cookies">Cookies & Biscuits</option>
                                <option value="flowers">Flowers</option>
                            </select>
                        </div>
                        
                        <!-- City Filter -->
                        <div class="flex items-center">
                            <label for="city-select" class="text-sm font-medium text-gray-700 mr-3">City:</label>
                            <select id="city-select" class="bg-white border border-gray-300 rounded-lg px-4 py-2 text-sm focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent">
                                <option value="">All Cities</option>
                                <option value="mumbai">Mumbai</option>
                                <option value="delhi">Delhi</option>
                                <option value="bangalore">Bangalore</option>
                                <option value="chennai">Chennai</option>
                                <option value="hyderabad">Hyderabad</option>
                                <option value="pune">Pune</option>
                            </select>
                        </div>
                    </div>
                </div>
                
                <!-- Products Grid -->
                <div id="products-grid" class="grid grid-cols-1 sm:grid-cols-2 lg:grid-cols-3 xl:grid-cols-4 gap-6">
                    <!-- Product 1 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="bread" data-eggless="false" data-cities="mumbai,delhi,bangalore">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Artisan Sourdough Bread</h3>
                            <p class="text-gray-600 text-sm mb-4">Traditional sourdough with a crispy crust and soft interior</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹450</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 2 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="pastries" data-eggless="false" data-cities="mumbai,delhi,chennai">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Chocolate Croissants</h3>
                            <p class="text-gray-600 text-sm mb-4">Buttery croissants filled with rich chocolate</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹320</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 3 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cakes" data-eggless="true" data-cities="mumbai,bangalore,hyderabad">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-birthday-cake text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Vanilla Sponge Cake</h3>
                            <p class="text-gray-600 text-sm mb-4">Light and fluffy eggless vanilla sponge cake</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹680</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 4 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cookies" data-eggless="true" data-cities="delhi,chennai,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Chocolate Chip Cookies</h3>
                            <p class="text-gray-600 text-sm mb-4">Soft and chewy eggless chocolate chip cookies</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹280</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 5 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="bread" data-eggless="false" data-cities="mumbai,bangalore,hyderabad">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Whole Wheat Bread</h3>
                            <p class="text-gray-600 text-sm mb-4">Nutritious whole wheat bread with seeds</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹380</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 6 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="pastries" data-eggless="false" data-cities="delhi,chennai,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Almond Danish</h3>
                            <p class="text-gray-600 text-sm mb-4">Flaky pastry with almond cream filling</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹420</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 7 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cakes" data-eggless="true" data-cities="mumbai,delhi,bangalore">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-birthday-cake text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Chocolate Truffle Cake</h3>
                            <p class="text-gray-600 text-sm mb-4">Rich eggless chocolate cake with truffle frosting</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹850</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 8 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="flowers" data-eggless="true" data-cities="mumbai,chennai,hyderabad">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-seedling text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Mixed Flower Bouquet</h3>
                            <p class="text-gray-600 text-sm mb-4">Fresh seasonal flowers arranged beautifully</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹650</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 9 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="bread" data-eggless="false" data-cities="bangalore,hyderabad,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Multigrain Loaf</h3>
                            <p class="text-gray-600 text-sm mb-4">Healthy multigrain bread with nuts and seeds</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹520</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 10 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="pastries" data-eggless="true" data-cities="mumbai,delhi,chennai">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Eggless Muffins</h3>
                            <p class="text-gray-600 text-sm mb-4">Soft and moist eggless blueberry muffins</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹350</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 11 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cakes" data-eggless="false" data-cities="bangalore,hyderabad,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-birthday-cake text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Red Velvet Cake</h3>
                            <p class="text-gray-600 text-sm mb-4">Classic red velvet with cream cheese frosting</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹720</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 12 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cookies" data-eggless="true" data-cities="mumbai,bangalore,hyderabad">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Oatmeal Raisin Cookies</h3>
                            <p class="text-gray-600 text-sm mb-4">Chewy eggless oatmeal cookies with raisins</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹320</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 13 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="bread" data-eggless="false" data-cities="delhi,chennai,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">French Baguette</h3>
                            <p class="text-gray-600 text-sm mb-4">Authentic French baguette with crispy crust</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹280</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 14 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="pastries" data-eggless="false" data-cities="mumbai,delhi,bangalore">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Cinnamon Roll</h3>
                            <p class="text-gray-600 text-sm mb-4">Sweet cinnamon roll with cream cheese glaze</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹380</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 15 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cakes" data-eggless="true" data-cities="chennai,hyderabad,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-birthday-cake text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Strawberry Shortcake</h3>
                            <p class="text-gray-600 text-sm mb-4">Light eggless cake with fresh strawberries</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹580</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 16 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="flowers" data-eggless="true" data-cities="delhi,bangalore,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-seedling text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Rose Bouquet</h3>
                            <p class="text-gray-600 text-sm mb-4">Elegant bouquet of fresh red roses</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹750</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 17 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="bread" data-eggless="true" data-cities="mumbai,delhi,chennai">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Eggless White Bread</h3>
                            <p class="text-gray-600 text-sm mb-4">Soft and fluffy eggless white bread</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹350</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 18 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="pastries" data-eggless="true" data-cities="bangalore,hyderabad,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Eggless Donuts</h3>
                            <p class="text-gray-600 text-sm mb-4">Soft eggless donuts with chocolate glaze</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹450</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 19 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cakes" data-eggless="false" data-cities="mumbai,chennai,hyderabad">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-birthday-cake text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Tiramisu Cake</h3>
                            <p class="text-gray-600 text-sm mb-4">Classic Italian tiramisu layered cake</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹920</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 20 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cookies" data-eggless="false" data-cities="delhi,bangalore,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Macarons</h3>
                            <p class="text-gray-600 text-sm mb-4">Delicate French macarons in various flavors</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹680</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 21 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="bread" data-eggless="false" data-cities="mumbai,bangalore,hyderabad">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Rye Bread</h3>
                            <p class="text-gray-600 text-sm mb-4">Traditional rye bread with caraway seeds</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹420</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 22 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="pastries" data-eggless="true" data-cities="delhi,chennai,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Eggless Pancakes</h3>
                            <p class="text-gray-600 text-sm mb-4">Fluffy eggless pancakes with maple syrup</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹380</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 23 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cakes" data-eggless="true" data-cities="mumbai,delhi,bangalore">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-birthday-cake text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Carrot Cake</h3>
                            <p class="text-gray-600 text-sm mb-4">Moist eggless carrot cake with cream cheese</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹650</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 24 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="flowers" data-eggless="true" data-cities="bangalore,hyderabad,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-seedling text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Sunflower Bouquet</h3>
                            <p class="text-gray-600 text-sm mb-4">Bright and cheerful sunflower arrangement</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹580</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 25 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="bread" data-eggless="false" data-cities="chennai,hyderabad,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Focaccia Bread</h3>
                            <p class="text-gray-600 text-sm mb-4">Italian focaccia with herbs and olive oil</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹480</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 26 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="pastries" data-eggless="false" data-cities="mumbai,delhi,chennai">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Eclairs</h3>
                            <p class="text-gray-600 text-sm mb-4">Cream-filled eclairs with chocolate glaze</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹520</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 27 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cakes" data-eggless="true" data-cities="delhi,chennai,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-birthday-cake text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Lemon Drizzle Cake</h3>
                            <p class="text-gray-600 text-sm mb-4">Tangy eggless lemon cake with drizzle</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹580</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 28 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cookies" data-eggless="true" data-cities="mumbai,bangalore,hyderabad">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Gingerbread Cookies</h3>
                            <p class="text-gray-600 text-sm mb-4">Spiced eggless gingerbread cookies</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹380</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 29 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="bread" data-eggless="true" data-cities="bangalore,hyderabad,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Eggless Brioche</h3>
                            <p class="text-gray-600 text-sm mb-4">Rich and buttery eggless brioche bread</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹550</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 30 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="pastries" data-eggless="true" data-cities="mumbai,delhi,bangalore">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Eggless Waffles</h3>
                            <p class="text-gray-600 text-sm mb-4">Crispy eggless waffles with berries</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹420</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 31 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cakes" data-eggless="false" data-cities="chennai,hyderabad,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-birthday-cake text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Cheesecake</h3>
                            <p class="text-gray-600 text-sm mb-4">New York style cheesecake with berries</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹780</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 32 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="flowers" data-eggless="true" data-cities="mumbai,delhi,chennai">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-seedling text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Tulip Bouquet</h3>
                            <p class="text-gray-600 text-sm mb-4">Colorful tulip arrangement for spring</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹620</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 33 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="bread" data-eggless="false" data-cities="mumbai,delhi,bangalore">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Pumpernickel Bread</h3>
                            <p class="text-gray-600 text-sm mb-4">Dark German pumpernickel with molasses</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹480</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 34 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="pastries" data-eggless="true" data-cities="bangalore,hyderabad,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Eggless Scones</h3>
                            <p class="text-gray-600 text-sm mb-4">Traditional eggless scones with jam</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹350</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 35 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cakes" data-eggless="true" data-cities="mumbai,chennai,hyderabad">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-birthday-cake text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Coffee Cake</h3>
                            <p class="text-gray-600 text-sm mb-4">Moist eggless coffee cake with streusel</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹580</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 36 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cookies" data-eggless="false" data-cities="delhi,bangalore,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Shortbread Cookies</h3>
                            <p class="text-gray-600 text-sm mb-4">Buttery Scottish shortbread cookies</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹420</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 37 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="bread" data-eggless="true" data-cities="delhi,chennai,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-bread-slice text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Eggless Challah</h3>
                            <p class="text-gray-600 text-sm mb-4">Traditional eggless challah bread</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹450</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 38 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="pastries" data-eggless="false" data-cities="mumbai,bangalore,hyderabad">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Profiteroles</h3>
                            <p class="text-gray-600 text-sm mb-4">Light choux pastry with cream filling</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹580</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 39 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cakes" data-eggless="true" data-cities="bangalore,hyderabad,pune">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-birthday-cake text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Pound Cake</h3>
                            <p class="text-gray-600 text-sm mb-4">Classic eggless pound cake with glaze</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹520</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Product 40 -->
                    <div class="product-card bg-white rounded-2xl shadow-lg overflow-hidden hover:shadow-xl transition-all duration-300 transform hover:scale-105" data-category="cookies" data-eggless="true" data-cities="mumbai,delhi,bangalore">
                        <div class="h-48 bg-gradient-to-br from-amber-100 to-amber-200 flex items-center justify-center">
                            <i class="fas fa-cookie-bite text-6xl text-amber-600"></i>
                        </div>
                        <div class="p-6">
                            <h3 class="text-xl font-semibold text-gray-900 mb-2">Cannoli</h3>
                            <p class="text-gray-600 text-sm mb-4">Crispy eggless cannoli with ricotta filling</p>
                            <div class="flex items-center justify-between">
                                <span class="text-2xl font-bold text-amber-600">₹450</span>
                                <button class="add-to-cart bg-amber-600 hover:bg-amber-700 text-white px-4 py-2 rounded-lg transition-colors">
                                    <i class="fas fa-plus mr-2"></i>Add to Cart
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <!-- Modern Footer Component -->
    <?php include 'modern_footer_component.php'; ?>

    <?php include 'cart_component.php'; ?>

    <!-- JavaScript -->
    <script>
        // Modern Bakery Website JavaScript
        class ModernBakery {
            constructor() {
                this.init();
            }
            
            init() {
                this.initScrollAnimations();
                this.initProductFilter();
                this.initHeroSlider();
            }
            
            initScrollAnimations() {
                // Intersection Observer for fade-in animations
                const observer = new IntersectionObserver((entries) => {
                    entries.forEach(entry => {
                        if (entry.isIntersecting) {
                            entry.target.classList.add('animate-fadeInUp');
                        }
                    });
                }, { threshold: 0.1 });
                
                // Observe elements for animation
                document.querySelectorAll('.product-card').forEach(card => {
                    observer.observe(card);
                });
            }
            
            initHeroSlider() {
                const slides = document.querySelectorAll('.hero-slide');
                let currentSlide = 0;
                
                if (slides.length === 0) return;
                
                function showSlide(index) {
                    slides.forEach((slide, i) => {
                        slide.classList.toggle('active', i === index);
                    });
                }
                
                function nextSlide() {
                    currentSlide = (currentSlide + 1) % slides.length;
                    showSlide(currentSlide);
                }
                
                // Start the slider
                showSlide(0);
                
                // Change slide every 5 seconds
                setInterval(nextSlide, 5000);
            }
            
            initProductFilter() {
                const egglessToggle = document.getElementById('eggless-toggle');
                const collectionSelect = document.getElementById('collection-select');
                const citySelect = document.getElementById('city-select');
                const productCards = document.querySelectorAll('.product-card');
                
                // Mock product data with cities
                const productData = {
                    '1': { category: 'bread', eggless: false, cities: ['mumbai', 'delhi', 'bangalore'] },
                    '2': { category: 'pastries', eggless: false, cities: ['mumbai', 'delhi', 'chennai'] },
                    '3': { category: 'cakes', eggless: true, cities: ['mumbai', 'bangalore', 'hyderabad'] },
                    '4': { category: 'cookies', eggless: true, cities: ['delhi', 'chennai', 'pune'] },
                    '5': { category: 'bread', eggless: false, cities: ['mumbai', 'bangalore', 'hyderabad'] },
                    '6': { category: 'pastries', eggless: false, cities: ['delhi', 'chennai', 'pune'] },
                    '7': { category: 'cakes', eggless: true, cities: ['mumbai', 'delhi', 'bangalore'] },
                    '8': { category: 'flowers', eggless: true, cities: ['mumbai', 'chennai', 'hyderabad'] },
                    '9': { category: 'bread', eggless: false, cities: ['bangalore', 'hyderabad', 'pune'] },
                    '10': { category: 'pastries', eggless: true, cities: ['mumbai', 'delhi', 'chennai'] },
                    '11': { category: 'cakes', eggless: false, cities: ['bangalore', 'hyderabad', 'pune'] },
                    '12': { category: 'cookies', eggless: true, cities: ['mumbai', 'bangalore', 'hyderabad'] },
                    '13': { category: 'bread', eggless: false, cities: ['delhi', 'chennai', 'pune'] },
                    '14': { category: 'pastries', eggless: false, cities: ['mumbai', 'delhi', 'bangalore'] },
                    '15': { category: 'cakes', eggless: true, cities: ['chennai', 'hyderabad', 'pune'] },
                    '16': { category: 'flowers', eggless: true, cities: ['delhi', 'bangalore', 'pune'] },
                    '17': { category: 'bread', eggless: true, cities: ['mumbai', 'delhi', 'chennai'] },
                    '18': { category: 'pastries', eggless: true, cities: ['bangalore', 'hyderabad', 'pune'] },
                    '19': { category: 'cakes', eggless: false, cities: ['mumbai', 'chennai', 'hyderabad'] },
                    '20': { category: 'cookies', eggless: false, cities: ['delhi', 'bangalore', 'pune'] },
                    '21': { category: 'bread', eggless: false, cities: ['mumbai', 'bangalore', 'hyderabad'] },
                    '22': { category: 'pastries', eggless: true, cities: ['delhi', 'chennai', 'pune'] },
                    '23': { category: 'cakes', eggless: true, cities: ['mumbai', 'delhi', 'bangalore'] },
                    '24': { category: 'flowers', eggless: true, cities: ['bangalore', 'hyderabad', 'pune'] },
                    '25': { category: 'bread', eggless: false, cities: ['chennai', 'hyderabad', 'pune'] },
                    '26': { category: 'pastries', eggless: false, cities: ['mumbai', 'delhi', 'chennai'] },
                    '27': { category: 'cakes', eggless: true, cities: ['delhi', 'chennai', 'pune'] },
                    '28': { category: 'cookies', eggless: true, cities: ['mumbai', 'bangalore', 'hyderabad'] },
                    '29': { category: 'bread', eggless: true, cities: ['bangalore', 'hyderabad', 'pune'] },
                    '30': { category: 'pastries', eggless: true, cities: ['mumbai', 'delhi', 'bangalore'] },
                    '31': { category: 'cakes', eggless: false, cities: ['chennai', 'hyderabad', 'pune'] },
                    '32': { category: 'flowers', eggless: true, cities: ['mumbai', 'delhi', 'chennai'] },
                    '33': { category: 'bread', eggless: false, cities: ['mumbai', 'delhi', 'bangalore'] },
                    '34': { category: 'pastries', eggless: true, cities: ['bangalore', 'hyderabad', 'pune'] },
                    '35': { category: 'cakes', eggless: true, cities: ['mumbai', 'chennai', 'hyderabad'] },
                    '36': { category: 'cookies', eggless: false, cities: ['delhi', 'bangalore', 'pune'] },
                    '37': { category: 'bread', eggless: true, cities: ['delhi', 'chennai', 'pune'] },
                    '38': { category: 'pastries', eggless: false, cities: ['mumbai', 'bangalore', 'hyderabad'] },
                    '39': { category: 'cakes', eggless: true, cities: ['bangalore', 'hyderabad', 'pune'] },
                    '40': { category: 'cookies', eggless: true, cities: ['mumbai', 'delhi', 'bangalore'] }
                };
                
                function filterProducts() {
                    const isEggless = egglessToggle.checked;
                    const selectedCollection = collectionSelect.value;
                    const selectedCity = citySelect.value;
                    
                    productCards.forEach((card, index) => {
                        const productId = (index + 1).toString();
                        const product = productData[productId];
                        
                        let show = true;
                        
                        // Filter by eggless
                        if (isEggless && !product.eggless) {
                            show = false;
                        }
                        
                        // Filter by collection
                        if (selectedCollection && product.category !== selectedCollection) {
                            show = false;
                        }
                        
                        // Filter by city
                        if (selectedCity && !product.cities.includes(selectedCity)) {
                            show = false;
                        }
                        
                        card.style.display = show ? 'block' : 'none';
                    });
                }
                
                // Event listeners
                egglessToggle.addEventListener('change', filterProducts);
                collectionSelect.addEventListener('change', filterProducts);
                citySelect.addEventListener('change', filterProducts);
            }
        }
        
        // Initialize when DOM is loaded
        document.addEventListener('DOMContentLoaded', function() {
            new ModernBakery();
        });
    </script>
</body>
</html>