<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Shipping Policy - Honoré Bakery</title>
    <meta name="description" content="Shipping Policy for Honoré Bakery. Learn about our delivery options, timelines, and shipping procedures.">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'playfair': ['Playfair Display', 'serif'],
                        'inter': ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'amber': {
                            50: '#fffbeb',
                            100: '#fef3c7',
                            200: '#fde68a',
                            300: '#fcd34d',
                            400: '#fbbf24',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309',
                            800: '#92400e',
                            900: '#78350f',
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        .gradient-text {
            background: linear-gradient(135deg, #f59e0b, #d97706);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
    </style>
</head>
<body class="font-inter bg-gray-50 text-gray-900">
    <?php include 'header_component.php'; ?>

    <main>
        <!-- Page Header -->
        <section class="py-16 bg-gradient-to-r from-amber-600 to-amber-700">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8 text-center">
                <h1 class="text-4xl md:text-5xl font-playfair font-bold text-white mb-4">
                    Shipping <span class="text-amber-200">Policy</span>
                </h1>
                <p class="text-xl text-amber-100">
                    Fast, fresh, and reliable delivery to your doorstep.
                </p>
            </div>
        </section>

        <!-- Shipping Policy Content -->
        <section class="py-16">
            <div class="max-w-4xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="bg-white rounded-lg shadow-lg p-8 md:p-12">
                    <div class="prose prose-lg max-w-none">
                        <p class="text-gray-600 mb-8">
                            <strong>Last updated:</strong> December 2024
                        </p>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">1. Delivery Areas</h2>
                        <p class="text-gray-700 mb-6">
                            We currently deliver to the following areas:
                        </p>
                        <div class="grid md:grid-cols-2 gap-6 mb-8">
                            <div class="bg-amber-50 p-6 rounded-lg">
                                <h3 class="text-lg font-semibold text-gray-900 mb-4">Same Day Delivery</h3>
                                <ul class="space-y-2 text-gray-700">
                                    <li>• Downtown District</li>
                                    <li>• Central Business Area</li>
                                    <li>• University Area</li>
                                    <li>• Tech Park Zone</li>
                                </ul>
                            </div>
                            <div class="bg-amber-50 p-6 rounded-lg">
                                <h3 class="text-lg font-semibold text-gray-900 mb-4">Next Day Delivery</h3>
                                <ul class="space-y-2 text-gray-700">
                                    <li>• Suburban Areas</li>
                                    <li>• Industrial Zones</li>
                                    <li>• Residential Complexes</li>
                                    <li>• Outskirts</li>
                                </ul>
                            </div>
                        </div>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">2. Delivery Timeframes</h2>
                        <div class="bg-amber-50 p-6 rounded-lg mb-8">
                            <h3 class="text-lg font-semibold text-gray-900 mb-4">Order Cut-off Times:</h3>
                            <ul class="space-y-2 text-gray-700">
                                <li><strong>Same Day Delivery:</strong> Orders placed before 7:00 PM</li>
                                <li><strong>Next Day Delivery:</strong> Orders placed before 10:00 PM</li>
                                <li><strong>Custom Cakes:</strong> Orders placed 48 hours in advance</li>
                                <li><strong>Special Occasions:</strong> Orders placed 72 hours in advance</li>
                            </ul>
                        </div>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">3. Delivery Charges</h2>
                        <div class="overflow-x-auto mb-8">
                            <table class="w-full border-collapse border border-gray-300">
                                <thead>
                                    <tr class="bg-amber-100">
                                        <th class="border border-gray-300 px-4 py-2 text-left">Order Value</th>
                                        <th class="border border-gray-300 px-4 py-2 text-left">Delivery Charge</th>
                                        <th class="border border-gray-300 px-4 py-2 text-left">Delivery Time</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td class="border border-gray-300 px-4 py-2">Above ₹500</td>
                                        <td class="border border-gray-300 px-4 py-2">FREE</td>
                                        <td class="border border-gray-300 px-4 py-2">Same Day</td>
                                    </tr>
                                    <tr class="bg-gray-50">
                                        <td class="border border-gray-300 px-4 py-2">₹300 - ₹500</td>
                                        <td class="border border-gray-300 px-4 py-2">₹50</td>
                                        <td class="border border-gray-300 px-4 py-2">Same Day</td>
                                    </tr>
                                    <tr>
                                        <td class="border border-gray-300 px-4 py-2">Below ₹300</td>
                                        <td class="border border-gray-300 px-4 py-2">₹80</td>
                                        <td class="border border-gray-300 px-4 py-2">Next Day</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">4. Special Delivery Services</h2>
                        <div class="grid md:grid-cols-2 gap-6 mb-8">
                            <div class="bg-green-50 p-6 rounded-lg">
                                <h3 class="text-lg font-semibold text-green-800 mb-2">
                                    <i class="fas fa-clock mr-2"></i>Express Delivery
                                </h3>
                                <p class="text-green-700 mb-2">Within 2 hours</p>
                                <p class="text-green-600 text-sm">Additional ₹100 charge</p>
                            </div>
                            <div class="bg-blue-50 p-6 rounded-lg">
                                <h3 class="text-lg font-semibold text-blue-800 mb-2">
                                    <i class="fas fa-calendar mr-2"></i>Scheduled Delivery
                                </h3>
                                <p class="text-blue-700 mb-2">Choose your time slot</p>
                                <p class="text-blue-600 text-sm">No additional charge</p>
                            </div>
                        </div>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">5. Packaging & Handling</h2>
                        <p class="text-gray-700 mb-6">
                            We take special care in packaging your orders to ensure freshness and quality:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Temperature-controlled packaging for perishable items</li>
                            <li>Secure packaging to prevent damage during transit</li>
                            <li>Eco-friendly packaging materials</li>
                            <li>Special handling for custom cakes and delicate items</li>
                            <li>Insulated bags for temperature-sensitive products</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">6. Delivery Process</h2>
                        <ol class="list-decimal list-inside text-gray-700 mb-8 space-y-2">
                            <li>Order confirmation and preparation</li>
                            <li>Quality check and packaging</li>
                            <li>Assignment to delivery partner</li>
                            <li>Real-time tracking updates</li>
                            <li>Delivery confirmation and feedback</li>
                        </ol>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">7. Delivery Tracking</h2>
                        <p class="text-gray-700 mb-6">
                            Track your order in real-time:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>SMS notifications at each stage</li>
                            <li>WhatsApp updates with delivery partner details</li>
                            <li>Email confirmations and receipts</li>
                            <li>Live tracking through our website</li>
                            <li>Estimated delivery time updates</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">8. Delivery Issues</h2>
                        <p class="text-gray-700 mb-6">
                            If you experience any delivery issues:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Contact us immediately at +91 98765 43210</li>
                            <li>Provide your order number and issue description</li>
                            <li>We will investigate and resolve within 2 hours</li>
                            <li>Compensation for delays or damages</li>
                            <li>Free re-delivery for failed attempts</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">9. Weather & Force Majeure</h2>
                        <p class="text-gray-700 mb-6">
                            In case of extreme weather conditions or unforeseen circumstances:
                        </p>
                        <ul class="list-disc list-inside text-gray-700 mb-8 space-y-2">
                            <li>Delivery delays may occur</li>
                            <li>We will notify you of any delays</li>
                            <li>Alternative delivery arrangements will be made</li>
                            <li>Refunds available for cancelled orders</li>
                            <li>Store credit for inconvenience caused</li>
                        </ul>

                        <h2 class="text-2xl font-playfair font-bold text-gray-900 mb-6">10. Contact Information</h2>
                        <p class="text-gray-700 mb-6">
                            For delivery-related queries or support:
                        </p>
                        <div class="bg-amber-50 p-6 rounded-lg">
                            <p class="text-gray-700 mb-2">
                                <strong>Delivery Hotline:</strong> +91 98765 43210
                            </p>
                            <p class="text-gray-700 mb-2">
                                <strong>Email:</strong> delivery@honorebakery.com
                            </p>
                            <p class="text-gray-700 mb-2">
                                <strong>WhatsApp:</strong> +91 98765 43210
                            </p>
                            <p class="text-gray-700 mb-2">
                                <strong>Operating Hours:</strong> 6:00 AM - 10:00 PM (Daily)
                            </p>
                            <p class="text-gray-700">
                                <strong>Address:</strong> 123 Baker Street, Downtown District
                            </p>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    </main>

    <?php include 'modern_footer_component.php'; ?>
    <?php include 'cart_component.php'; ?>
</body>
</html>
