<?php
/**
 * Unique & Elegant Footer Component for Honoré Bakery
 * Inspired by modern design but with unique bakery-themed elements
 */
?>

<!-- Unique Elegant Footer -->
<footer class="bg-white relative overflow-hidden">
    
    <!-- Top Contact Strip -->
    <div class="border-t border-b border-gray-100 py-8">
        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="grid grid-cols-1 md:grid-cols-3 gap-8 text-center md:text-center">
                <div class="group">
                    <h4 class="text-sm font-semibold text-gray-900 mb-2 tracking-wider uppercase">Visit Our Store</h4>
                    <a href="/contact" class="text-gray-600 hover:text-amber-600 transition-colors duration-300 text-sm">
                        Find Our Locations
                    </a>
                </div>
                <div class="group">
                    <h4 class="text-sm font-semibold text-gray-900 mb-2 tracking-wider uppercase">Call Us Now</h4>
                    <a href="tel:+919876543210" class="text-gray-600 hover:text-amber-600 transition-colors duration-300 text-sm">
                        +91 98765 43210
                    </a>
                </div>
                <div class="group">
                    <h4 class="text-sm font-semibold text-gray-900 mb-2 tracking-wider uppercase">Send Us A Message</h4>
                    <a href="mailto:hello@honorebakery.com" class="text-gray-600 hover:text-amber-600 transition-colors duration-300 text-sm">
                        hello@honorebakery.com
                    </a>
                </div>
            </div>
        </div>
    </div>

    <!-- Main Footer Content -->
    <div class="py-16 relative">
        <!-- Decorative Background Elements -->
        <div class="absolute inset-0 overflow-hidden pointer-events-none">
            <!-- Floating Bread Icons -->
            <div class="absolute top-10 left-10 w-8 h-8 opacity-5">
                <i class="fas fa-bread-slice text-amber-600 text-2xl"></i>
            </div>
            <div class="absolute top-20 right-20 w-6 h-6 opacity-5">
                <i class="fas fa-cookie-bite text-amber-600 text-xl"></i>
            </div>
            <div class="absolute bottom-20 left-1/4 w-4 h-4 opacity-5">
                <i class="fas fa-birthday-cake text-amber-600 text-lg"></i>
            </div>
            <div class="absolute bottom-10 right-1/3 w-5 h-5 opacity-5">
                <i class="fas fa-cookie text-amber-600 text-xl"></i>
            </div>
        </div>

        <div class="max-w-6xl mx-auto px-4 sm:px-6 lg:px-8 relative z-10">
            
            <!-- Newsletter Section -->
            <div class="text-center mb-16">
                <div class="max-w-2xl mx-auto">
                    <h3 class="text-2xl font-light text-gray-900 mb-4 tracking-wide">
                        Stay in the loop with our latest creations
                    </h3>
                    <p class="text-gray-600 mb-8 text-sm leading-relaxed">
                        Sign up to our newsletter for exclusive access to new arrivals, style updates and seasonal sales.
                    </p>
                    
                    <!-- Unique Newsletter Form -->
                    <div class="flex flex-col sm:flex-row gap-3 max-w-md mx-auto">
                        <div class="relative flex-1">
                            <input 
                                type="email" 
                                placeholder="Enter your email" 
                                class="w-full px-4 py-3 border border-gray-200 rounded-none bg-transparent focus:outline-none focus:border-amber-500 transition-colors duration-300 text-sm"
                            >
                            <div class="absolute inset-0 border border-gray-200 pointer-events-none"></div>
                        </div>
                        <button class="bg-transparent border border-amber-500 text-gray-900 px-8 py-3 font-medium text-sm tracking-wide uppercase hover:bg-amber-500 hover:text-white transition-all duration-300">
                            Subscribe
                        </button>
                    </div>
                </div>
            </div>

            <!-- Policy Links -->
            <div class="flex flex-wrap justify-center gap-8 mb-12">
                <a href="/erp-ecom/privacy-policy" class="text-gray-600 hover:text-amber-600 text-xs font-medium tracking-widest uppercase transition-colors duration-300">
                    Privacy Policy
                </a>
                <a href="/erp-ecom/terms" class="text-gray-600 hover:text-amber-600 text-xs font-medium tracking-widest uppercase transition-colors duration-300">
                    Terms
                </a>
                <a href="/erp-ecom/refund-policy" class="text-gray-600 hover:text-amber-600 text-xs font-medium tracking-widest uppercase transition-colors duration-300">
                    Refund Policy
                </a>
                <a href="/erp-ecom/shipping-policy" class="text-gray-600 hover:text-amber-600 text-xs font-medium tracking-widest uppercase transition-colors duration-300">
                    Shipping Policy
                </a>
            </div>

            <!-- Social Media & Brand -->
            <div class="text-center">
                <!-- Social Icons -->
                <div class="flex justify-center space-x-6 mb-8">
                    <a href="#" class="w-8 h-8 flex items-center justify-center group">
                        <i class="fab fa-facebook-f text-gray-400 group-hover:text-amber-600 transition-colors duration-300"></i>
                    </a>
                    <a href="#" class="w-8 h-8 flex items-center justify-center group">
                        <i class="fab fa-instagram text-gray-400 group-hover:text-amber-600 transition-colors duration-300"></i>
                    </a>
                    <a href="#" class="w-8 h-8 flex items-center justify-center group">
                        <i class="fab fa-twitter text-gray-400 group-hover:text-amber-600 transition-colors duration-300"></i>
                    </a>
                    <a href="#" class="w-8 h-8 flex items-center justify-center group">
                        <i class="fab fa-youtube text-gray-400 group-hover:text-amber-600 transition-colors duration-300"></i>
                    </a>
                </div>

                <!-- Brand Logo -->
                <div class="flex items-center justify-center mb-6">
                    <div class="w-10 h-10 bg-gradient-to-br from-amber-500 to-orange-600 rounded-full flex items-center justify-center mr-3">
                        <i class="fas fa-bread-slice text-white text-lg"></i>
                    </div>
                    <h2 class="text-2xl font-light text-gray-900 tracking-wide">Honoré Bakery</h2>
                </div>

                <!-- Copyright -->
                <p class="text-gray-500 text-xs tracking-wide">
                    © Copyright Honoré Bakery 2024. All rights reserved.
                </p>
            </div>
        </div>
    </div>

    <!-- Scroll to Top Button -->
    <div class="fixed bottom-8 right-8 z-50">
        <button id="scroll-to-top" class="w-12 h-12 bg-gray-900 hover:bg-amber-600 text-white rounded-full flex items-center justify-center transition-all duration-300 shadow-lg hover:shadow-xl transform hover:scale-110">
            <i class="fas fa-arrow-up text-sm"></i>
        </button>
    </div>
</footer>

<!-- Footer JavaScript -->
<script>
document.addEventListener('DOMContentLoaded', function() {
    // Newsletter subscription functionality
    const subscribeBtn = document.querySelector('footer button');
    const emailInput = document.querySelector('footer input[type="email"]');
    
    if (subscribeBtn && emailInput) {
        subscribeBtn.addEventListener('click', function(e) {
            e.preventDefault();
            const email = emailInput.value.trim();
            
            if (email && isValidEmail(email)) {
                // Show success message
                showNotification('Thank you for subscribing! You\'ll receive our latest updates soon.', 'success');
                emailInput.value = '';
            } else {
                showNotification('Please enter a valid email address.', 'error');
            }
        });
        
        emailInput.addEventListener('keypress', function(e) {
            if (e.key === 'Enter') {
                subscribeBtn.click();
            }
        });
    }
    
    // Scroll to top functionality
    const scrollToTopBtn = document.getElementById('scroll-to-top');
    if (scrollToTopBtn) {
        // Show/hide button based on scroll position
        window.addEventListener('scroll', function() {
            if (window.pageYOffset > 300) {
                scrollToTopBtn.style.opacity = '1';
                scrollToTopBtn.style.visibility = 'visible';
            } else {
                scrollToTopBtn.style.opacity = '0';
                scrollToTopBtn.style.visibility = 'hidden';
            }
        });
        
        // Scroll to top when clicked
        scrollToTopBtn.addEventListener('click', function() {
            window.scrollTo({
                top: 0,
                behavior: 'smooth'
            });
        });
    }
    
    function isValidEmail(email) {
        const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;
        return emailRegex.test(email);
    }
    
    function showNotification(message, type) {
        // Create notification element
        const notification = document.createElement('div');
        notification.className = `fixed top-4 right-4 z-50 px-6 py-4 rounded-lg shadow-lg transition-all duration-300 ${
            type === 'success' ? 'bg-green-500 text-white' : 'bg-red-500 text-white'
        }`;
        notification.textContent = message;
        
        document.body.appendChild(notification);
        
        // Remove notification after 3 seconds
        setTimeout(() => {
            notification.remove();
        }, 3000);
    }
});
</script>
