<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Honoré Bakery - Artisan Breads, Pastries & Flowers</title>
    <meta name="description" content="Premium artisan bakery offering fresh breads, pastries, cakes, and beautiful flowers. Handcrafted with love, delivered with care across multiple cities.">
    <meta name="keywords" content="artisan bakery, fresh bread, pastries, cakes, flowers, delivery, premium quality">
    
    <!-- Tailwind CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <!-- Font Awesome -->
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <!-- Google Fonts -->
    <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@400;700&family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    
    <script>
        tailwind.config = {
            theme: {
                extend: {
                    fontFamily: {
                        'playfair': ['Playfair Display', 'serif'],
                        'inter': ['Inter', 'sans-serif'],
                    },
                    colors: {
                        'amber': {
                            50: '#fffbeb',
                            100: '#fef3c7',
                            200: '#fde68a',
                            300: '#fcd34d',
                            400: '#fbbf24',
                            500: '#f59e0b',
                            600: '#d97706',
                            700: '#b45309',
                            800: '#92400e',
                            900: '#78350f',
                        },
                        'rose': {
                            50: '#fff1f2',
                            100: '#ffe4e6',
                            200: '#fecdd3',
                            300: '#fda4af',
                            400: '#fb7185',
                            500: '#f43f5e',
                            600: '#e11d48',
                            700: '#be123c',
                            800: '#9f1239',
                            900: '#881337',
                        }
                    },
                    animation: {
                        'fade-in': 'fadeIn 0.5s ease-in-out',
                        'slide-down': 'slideDown 0.3s ease-out',
                        'slide-up': 'slideUp 0.3s ease-out',
                    },
                    keyframes: {
                        fadeIn: {
                            '0%': { opacity: '0' },
                            '100%': { opacity: '1' },
                        },
                        slideDown: {
                            '0%': { transform: 'translateY(-100%)', opacity: '0' },
                            '100%': { transform: 'translateY(0)', opacity: '1' },
                        },
                        slideUp: {
                            '0%': { transform: 'translateY(0)', opacity: '1' },
                            '100%': { transform: 'translateY(-100%)', opacity: '0' },
                        }
                    }
                }
            }
        }
    </script>
    
    <style>
        .gradient-text {
            background: linear-gradient(135deg, #d97706, #f59e0b, #fbbf24);
            -webkit-background-clip: text;
            -webkit-text-fill-color: transparent;
            background-clip: text;
        }
        
        .category-scroll::-webkit-scrollbar {
            display: none;
        }
        
        .category-scroll {
            -ms-overflow-style: none;
            scrollbar-width: none;
        }
        
        .search-dropdown {
            backdrop-filter: blur(10px);
            background: rgba(255, 255, 255, 0.95);
        }
    </style>
</head>
<body class="font-inter bg-white text-gray-900">
    <!-- Top Announcement Bar -->
    <div class="bg-amber-800 text-white py-2 px-4">
        <div class="max-w-7xl mx-auto flex justify-between items-center text-sm">
            <div class="flex items-center space-x-6">
                <span class="font-medium">HANDCRAFTING FLOWERS NOW</span>
                <span class="hidden md:inline">DUE TO HEAVY RAINS, DELIVERIES MAY DELAY.</span>
            </div>
            <div class="text-right">
                <span class="font-medium">ORDER BY 7PM TO ENJOY SAME DAY DELIVERY</span>
            </div>
        </div>
    </div>

    <!-- Main Header -->
    <header class="bg-white border-b border-gray-200 sticky top-0 z-50">
        <!-- Top Header Row -->
        <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
            <div class="flex items-center justify-between h-16">
                <!-- Left: Search Button -->
                <div class="flex-shrink-0">
                    <button id="search-toggle" class="flex items-center space-x-2 text-gray-600 hover:text-amber-600 transition-colors">
                        <i class="fas fa-search text-lg"></i>
                        <span class="hidden sm:inline font-medium">SEARCH</span>
                    </button>
                </div>
                
                <!-- Center: Logo -->
                <div class="flex-shrink-0">
                    <a href="/" class="flex items-center">
                        <div class="w-10 h-10 bg-gradient-to-br from-amber-500 to-amber-700 rounded-full flex items-center justify-center mr-3">
                            <i class="fas fa-bread-slice text-white text-lg"></i>
                        </div>
                        <span class="text-3xl font-playfair font-bold gradient-text">Honoré Bakery</span>
                    </a>
                </div>
                
                <!-- Right: User Actions -->
                <div class="flex items-center space-x-4">
                    <!-- Phone -->
                    <a href="tel:+919876543210" class="text-gray-600 hover:text-amber-600 transition-colors">
                        <i class="fas fa-phone text-lg"></i>
                    </a>
                    
                    <!-- User Account -->
                    <div class="relative group">
                        <button class="text-gray-600 hover:text-amber-600 transition-colors">
                            <i class="fas fa-user text-lg"></i>
                        </button>
                        <div class="absolute right-0 mt-2 w-48 bg-white rounded-lg shadow-xl opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                            <div class="py-2">
                                <a href="/login" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Login</a>
                                <a href="/register" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Register</a>
                                <a href="/account" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">My Account</a>
                                <a href="/orders" class="block px-4 py-2 text-sm text-gray-700 hover:bg-gray-100">Track Order</a>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Cart -->
                    <div class="relative">
                        <button class="text-gray-600 hover:text-amber-600 transition-colors relative">
                            <i class="fas fa-shopping-bag text-lg"></i>
                            <span id="cart-count" class="absolute -top-1 -right-1 bg-rose-500 text-white text-xs rounded-full h-5 w-5 flex items-center justify-center">0</span>
                        </button>
                    </div>
                </div>
            </div>
        </div>
        
        <!-- Navigation Row -->
        <div class="bg-gray-800">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <nav class="flex items-center justify-center space-x-8 py-3">
                    <a href="/" class="text-white hover:text-amber-300 px-3 py-2 text-sm font-medium transition-colors">Home</a>
                    
                    <!-- Collections Dropdown -->
                    <div class="relative group">
                        <button class="text-white hover:text-amber-300 px-3 py-2 text-sm font-medium transition-colors flex items-center">
                            Collections
                            <i class="fas fa-chevron-down ml-1 text-xs"></i>
                        </button>
                        <div class="absolute left-0 mt-2 w-80 bg-white rounded-lg shadow-xl opacity-0 invisible group-hover:opacity-100 group-hover:visible transition-all duration-300 z-50">
                            <div class="grid grid-cols-2 gap-4 p-6">
                                <div>
                                    <h3 class="font-semibold text-gray-900 mb-3">Baked Goods</h3>
                                    <ul class="space-y-2">
                                        <li><a href="/collections/cakes" class="text-gray-600 hover:text-amber-600 text-sm">Celebration Cakes</a></li>
                                        <li><a href="/collections/loaves" class="text-gray-600 hover:text-amber-600 text-sm">Cake Loaves</a></li>
                                        <li><a href="/collections/bread" class="text-gray-600 hover:text-amber-600 text-sm">Boulangerie</a></li>
                                        <li><a href="/collections/cookies" class="text-gray-600 hover:text-amber-600 text-sm">Cookies & Biscuits</a></li>
                                    </ul>
                                </div>
                                <div>
                                    <h3 class="font-semibold text-gray-900 mb-3">Special</h3>
                                    <ul class="space-y-2">
                                        <li><a href="/collections/flowers" class="text-gray-600 hover:text-amber-600 text-sm">Flowers</a></li>
                                        <li><a href="/collections/hampers" class="text-gray-600 hover:text-amber-600 text-sm">Hampers</a></li>
                                        <li><a href="/collections/eggless" class="text-gray-600 hover:text-amber-600 text-sm">Eggless Collection</a></li>
                                        <li><a href="/collections/wedding" class="text-gray-600 hover:text-amber-600 text-sm">Wedding Cakes</a></li>
                                    </ul>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <a href="/contact" class="text-white hover:text-amber-300 px-3 py-2 text-sm font-medium transition-colors">Contact Us</a>
                    <a href="/about" class="text-white hover:text-amber-300 px-3 py-2 text-sm font-medium transition-colors">About Us</a>
                    <a href="/orders" class="text-white hover:text-amber-300 px-3 py-2 text-sm font-medium transition-colors">Track Order</a>
                    <a href="/faq" class="text-white hover:text-amber-300 px-3 py-2 text-sm font-medium transition-colors">FAQ</a>
                </nav>
            </div>
        </div>
        
        <!-- Category Navigation -->
        <div class="bg-white border-b border-gray-200">
            <div class="max-w-7xl mx-auto px-4 sm:px-6 lg:px-8">
                <div class="flex items-center py-4">
                    <!-- Left Arrow -->
                    <button id="scroll-left" class="flex-shrink-0 mr-4 text-gray-400 hover:text-amber-600 transition-colors">
                        <i class="fas fa-chevron-left text-lg"></i>
                    </button>
                    
                    <!-- Scrollable Categories -->
                    <div id="categories-container" class="flex-1 overflow-x-auto category-scroll">
                        <div id="categories-scroll" class="flex space-x-6">
                            <!-- Everything -->
                            <div class="flex-shrink-0 text-center cursor-pointer group">
                                <div class="w-16 h-16 border-2 border-amber-500 rounded-full flex items-center justify-center mx-auto mb-2 group-hover:bg-amber-50 transition-colors">
                                    <div class="w-8 h-8 bg-gradient-to-br from-amber-500 to-amber-700 rounded-full flex items-center justify-center">
                                        <i class="fas fa-bread-slice text-white text-sm"></i>
                                    </div>
                                </div>
                                <span class="text-xs font-medium text-gray-700">Everything</span>
                            </div>
                            
                            <!-- Celebration Cakes -->
                            <div class="flex-shrink-0 text-center cursor-pointer group">
                                <div class="w-16 h-16 border-2 border-amber-500 rounded-full flex items-center justify-center mx-auto mb-2 group-hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-birthday-cake text-amber-600 text-xl"></i>
                                </div>
                                <span class="text-xs font-medium text-gray-700">Celebration Cakes</span>
                            </div>
                            
                            <!-- Diwali -->
                            <div class="flex-shrink-0 text-center cursor-pointer group">
                                <div class="w-16 h-16 border-2 border-amber-500 rounded-full flex items-center justify-center mx-auto mb-2 group-hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-fire text-amber-600 text-xl"></i>
                                </div>
                                <span class="text-xs font-medium text-gray-700">Diwali</span>
                            </div>
                            
                            <!-- Cake Loaves -->
                            <div class="flex-shrink-0 text-center cursor-pointer group">
                                <div class="w-16 h-16 border-2 border-amber-500 rounded-full flex items-center justify-center mx-auto mb-2 group-hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-cookie-bite text-amber-600 text-xl"></i>
                                </div>
                                <span class="text-xs font-medium text-gray-700">Cake Loaves</span>
                            </div>
                            
                            <!-- Flowers -->
                            <div class="flex-shrink-0 text-center cursor-pointer group">
                                <div class="w-16 h-16 border-2 border-amber-500 rounded-full flex items-center justify-center mx-auto mb-2 group-hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-seedling text-amber-600 text-xl"></i>
                                </div>
                                <span class="text-xs font-medium text-gray-700">Flowers</span>
                            </div>
                            
                            <!-- Boulangerie & Viennoiserie -->
                            <div class="flex-shrink-0 text-center cursor-pointer group">
                                <div class="w-16 h-16 border-2 border-amber-500 rounded-full flex items-center justify-center mx-auto mb-2 group-hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-bread-slice text-amber-600 text-xl"></i>
                                </div>
                                <span class="text-xs font-medium text-gray-700">Boulangerie & Viennoiserie</span>
                            </div>
                            
                            <!-- Hamper -->
                            <div class="flex-shrink-0 text-center cursor-pointer group">
                                <div class="w-16 h-16 border-2 border-amber-500 rounded-full flex items-center justify-center mx-auto mb-2 group-hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-gift text-amber-600 text-xl"></i>
                                </div>
                                <span class="text-xs font-medium text-gray-700">Hamper</span>
                            </div>
                            
                            <!-- Cookies & Biscuits -->
                            <div class="flex-shrink-0 text-center cursor-pointer group">
                                <div class="w-16 h-16 border-2 border-amber-500 rounded-full flex items-center justify-center mx-auto mb-2 group-hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-cookie text-amber-600 text-xl"></i>
                                </div>
                                <span class="text-xs font-medium text-gray-700">Cookies & Biscuits</span>
                            </div>
                            
                            <!-- Artisanal bites -->
                            <div class="flex-shrink-0 text-center cursor-pointer group">
                                <div class="w-16 h-16 border-2 border-amber-500 rounded-full flex items-center justify-center mx-auto mb-2 group-hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-cookie-bite text-amber-600 text-xl"></i>
                                </div>
                                <span class="text-xs font-medium text-gray-700">Artisanal bites</span>
                            </div>
                            
                            <!-- Eggless Collections -->
                            <div class="flex-shrink-0 text-center cursor-pointer group">
                                <div class="w-16 h-16 border-2 border-amber-500 rounded-full flex items-center justify-center mx-auto mb-2 group-hover:bg-amber-50 transition-colors">
                                    <i class="fas fa-ban text-amber-600 text-xl"></i>
                                </div>
                                <span class="text-xs font-medium text-gray-700">Eggless Collections</span>
                            </div>
                        </div>
                    </div>
                    
                    <!-- Right Arrow -->
                    <button id="scroll-right" class="flex-shrink-0 ml-4 text-gray-400 hover:text-amber-600 transition-colors">
                        <i class="fas fa-chevron-right text-lg"></i>
                    </button>
                </div>
            </div>
        </div>
    </header>

    <!-- Search Dropdown -->
    <div id="search-dropdown" class="fixed top-0 left-0 right-0 z-50 search-dropdown transform -translate-y-full transition-transform duration-300">
        <div class="max-w-4xl mx-auto px-4 py-6">
            <!-- Search Input -->
            <div class="relative mb-6">
                <input type="text" id="search-input" placeholder="Search products..." 
                       class="w-full px-6 py-4 pr-16 border-2 border-gray-300 rounded-xl focus:outline-none focus:ring-2 focus:ring-amber-500 focus:border-transparent text-lg">
                <button id="search-submit" class="absolute right-4 top-4 text-gray-400 hover:text-amber-600">
                    <i class="fas fa-search text-xl"></i>
                </button>
            </div>
            
            <!-- Popular Searches -->
            <div class="mb-6">
                <h3 class="text-sm font-medium text-gray-500 mb-3">Popular Searches:</h3>
                <div class="flex flex-wrap gap-3">
                    <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Chocolates</button>
                    <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Eggless</button>
                    <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Fruits</button>
                    <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Cakes</button>
                    <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Bread</button>
                    <button class="px-4 py-2 bg-gray-100 hover:bg-amber-100 text-gray-700 rounded-full text-sm transition-colors">Flowers</button>
                </div>
            </div>
            
            <!-- Recent Searches -->
            <div class="mb-6">
                <h3 class="text-sm font-medium text-gray-500 mb-3">Recent Searches:</h3>
                <div class="flex flex-wrap gap-3">
                    <button class="px-4 py-2 bg-gray-50 hover:bg-gray-100 text-gray-600 rounded-full text-sm transition-colors">Birthday Cake</button>
                    <button class="px-4 py-2 bg-gray-50 hover:bg-gray-100 text-gray-600 rounded-full text-sm transition-colors">Sourdough Bread</button>
                </div>
            </div>
            
            <!-- Close Button -->
            <div class="text-center">
                <button id="search-close" class="text-gray-400 hover:text-gray-600 transition-colors">
                    <i class="fas fa-times text-xl"></i>
                </button>
            </div>
        </div>
    </div>

    <!-- Search Overlay -->
    <div id="search-overlay" class="fixed inset-0 bg-black bg-opacity-50 z-40 hidden"></div>

    <!-- Main Content -->
    <main class="pt-0">
        <!-- Your page content goes here -->
        <div class="min-h-screen bg-gray-50 flex items-center justify-center">
            <div class="text-center">
                <h1 class="text-4xl font-playfair font-bold text-gray-900 mb-4">
                    Welcome to <span class="gradient-text">Honoré Bakery</span>
                </h1>
                <p class="text-xl text-gray-600 mb-8">
                    Your modern header component is ready! This can be included in all pages.
                </p>
                <div class="space-x-4">
                    <a href="/products" class="bg-amber-600 hover:bg-amber-700 text-white px-6 py-3 rounded-lg font-semibold transition-colors">
                        View Products
                    </a>
                    <a href="/about" class="border-2 border-amber-600 text-amber-600 hover:bg-amber-600 hover:text-white px-6 py-3 rounded-lg font-semibold transition-colors">
                        About Us
                    </a>
                </div>
            </div>
        </div>
    </main>

    <!-- JavaScript -->
    <script>
        // Modern Header Component JavaScript
        class ModernHeader {
            constructor() {
                this.init();
            }
            
            init() {
                this.initSearch();
                this.initCategoryScroll();
                this.initCart();
            }
            
            initSearch() {
                const searchToggle = document.getElementById('search-toggle');
                const searchDropdown = document.getElementById('search-dropdown');
                const searchClose = document.getElementById('search-close');
                const searchOverlay = document.getElementById('search-overlay');
                const searchInput = document.getElementById('search-input');
                const searchSubmit = document.getElementById('search-submit');
                
                // Toggle search dropdown
                searchToggle.addEventListener('click', () => {
                    searchDropdown.classList.remove('-translate-y-full');
                    searchOverlay.classList.remove('hidden');
                    document.body.style.overflow = 'hidden';
                    setTimeout(() => searchInput.focus(), 100);
                });
                
                // Close search dropdown
                const closeSearch = () => {
                    searchDropdown.classList.add('-translate-y-full');
                    searchOverlay.classList.add('hidden');
                    document.body.style.overflow = 'auto';
                };
                
                searchClose.addEventListener('click', closeSearch);
                searchOverlay.addEventListener('click', closeSearch);
                
                // Search functionality
                searchSubmit.addEventListener('click', () => {
                    const query = searchInput.value.trim();
                    if (query) {
                        window.location.href = `/products?search=${encodeURIComponent(query)}`;
                    }
                });
                
                searchInput.addEventListener('keypress', (e) => {
                    if (e.key === 'Enter') {
                        const query = searchInput.value.trim();
                        if (query) {
                            window.location.href = `/products?search=${encodeURIComponent(query)}`;
                        }
                    }
                });
                
                // Popular search buttons
                document.querySelectorAll('.bg-gray-100, .bg-gray-50').forEach(button => {
                    button.addEventListener('click', () => {
                        const query = button.textContent.trim();
                        searchInput.value = query;
                        window.location.href = `/products?search=${encodeURIComponent(query)}`;
                    });
                });
            }
            
            initCategoryScroll() {
                const scrollLeft = document.getElementById('scroll-left');
                const scrollRight = document.getElementById('scroll-right');
                const categoriesContainer = document.getElementById('categories-container');
                const categoriesScroll = document.getElementById('categories-scroll');
                
                let scrollAmount = 200;
                
                scrollLeft.addEventListener('click', () => {
                    categoriesContainer.scrollBy({
                        left: -scrollAmount,
                        behavior: 'smooth'
                    });
                });
                
                scrollRight.addEventListener('click', () => {
                    categoriesContainer.scrollBy({
                        left: scrollAmount,
                        behavior: 'smooth'
                    });
                });
                
                // Update arrow visibility based on scroll position
                const updateArrows = () => {
                    const { scrollLeft, scrollWidth, clientWidth } = categoriesContainer;
                    scrollLeft.style.opacity = scrollLeft > 0 ? '1' : '0.5';
                    scrollRight.style.opacity = scrollLeft < scrollWidth - clientWidth ? '1' : '0.5';
                };
                
                categoriesContainer.addEventListener('scroll', updateArrows);
                updateArrows();
            }
            
            initCart() {
                // Load cart from localStorage
                const cart = JSON.parse(localStorage.getItem('cart')) || [];
                const cartCount = document.getElementById('cart-count');
                const totalItems = cart.reduce((sum, item) => sum + item.quantity, 0);
                cartCount.textContent = totalItems;
            }
        }
        
        // Initialize the header
        const modernHeader = new ModernHeader();
        
        // Add some interactive effects
        document.addEventListener('DOMContentLoaded', () => {
            // Animate elements on scroll
            const observerOptions = {
                threshold: 0.1,
                rootMargin: '0px 0px -50px 0px'
            };
            
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        entry.target.classList.add('animate-fade-in');
                    }
                });
            }, observerOptions);
            
            // Observe all interactive elements
            document.querySelectorAll('.group, button, a').forEach(element => {
                observer.observe(element);
            });
        });
    </script>
</body>
</html>
