<?php

defined('BASEPATH') or exit('No direct script access allowed');

class Receipe_managements extends AdminController
{
    public function __construct()
    {
        parent::__construct();
        $this->load->model('receipe_managements_model');
    }

    private function log_recipe_action($action, $details = [])
    {
        $user_id = get_staff_user_id();
        $created_by = get_staff_full_name($user_id);
        $now = date('Y-m-d H:i:s');

        $this->db->insert(db_prefix() . 'recipe_log', [
            'user_id'    => $user_id,
            'module'     => 'Recipe',
            'action'     => $action,
            'details'    => json_encode($details),
            'created_at' => $now,
            'created_by' => $created_by
        ]);
    }

    /**
	 * Recipe Management
	 * @return [type] 
	 */
	public function recipe_management()
	{
	    if (!has_permission('receipe_managements', '', 'view') ) {
			access_denied('recipe_management');
		}

		$data['title'] = _l('recipe_management');
		
		
		$this->load->view('receipe_managements/recipe_management/recipe_management', $data);
		
	}

	/**
	 * Get recipe products for dropdown
	 * @return [type] 
	 */
	public function get_recipe_products()
	{
		header('Content-Type: application/json');
		
		$products = $this->receipe_managements_model->get_recipe_products();
		echo json_encode(array_values($products));
	}

	/**
	 * Get product component data
	 * @return [type] 
	 */
	public function get_product_component()
	{
		header('Content-Type: application/json');
		
		$product_id = isset($_GET['product_id']) ? intval($_GET['product_id']) : 0;
		$qty = isset($_GET['qty']) ? intval($_GET['qty']) : 1;
		$dayType = isset($_GET['dayType']) ? $_GET['dayType'] : 1;

		$get_groups = $this->receipe_managements_model->get_groups_byid($dayType);
		
		if (!$product_id) {
			echo json_encode(['success' => false, 'message' => 'No product_id provided']);
			return;
		}

		if (empty($get_groups)) {
			echo json_encode(['success' => false, 'message' => 'Invalid group provided.']);
			return;
		}

		$result = $this->receipe_managements_model->get_product_component($product_id, $qty, $get_groups['day_shift']);
		echo json_encode($result);
	}

	/**
	 * Add Recipe page
	 * @return [type] 
	 */
	public function add_recipe()
	{
	    if (!has_permission('receipe_managements', '', 'create') ) {
			access_denied('add_recipe');
		}


		$data['title'] = _l('add_recipe');
		
		$this->load->view('receipe_managements/recipe_management/add_recipe', $data);
	}

	/**
	 * Get components for dropdown
	 * @return [type] 
	 */
	public function get_components()
	{
		header('Content-Type: application/json');
		
		$components = $this->receipe_managements_model->get_components();
		echo json_encode(['success' => true, 'components' => $components]);
	}

	/**
	 * Save recipe data
	 * @return [type] 
	 */
	public function save_recipe()
	{
		header('Content-Type: application/json');
		
		if (!has_permission('receipe_managements', '', 'create')) {
			echo json_encode(['success' => false, 'message' => 'Access denied']);
			return;
		}

		$data = json_decode(file_get_contents('php://input'), true);
		
		if (!$data || !isset($data['product_id']) || !isset($data['components']) || !isset($data['day'])) {
			echo json_encode(['success' => false, 'message' => 'Invalid input']);
			return;
		}

		$result = $this->receipe_managements_model->save_recipe($data);
		echo json_encode($result);
	}

	/**
	 * Add a new product (AJAX)
	 * @return void
	 */
	public function add_product()
	{
	    header('Content-Type: application/json');

	    if (!has_permission('receipe_managements', '', 'create')) {
	        echo json_encode(['success' => false, 'message' => 'Access denied']);
	        return;
	    }

	    $data = json_decode(file_get_contents('php://input'), true);

	    if (!$data || !isset($data['name']) || trim($data['name']) === '') {
	        echo json_encode(['success' => false, 'message' => 'Product name is required']);
	        return;
	    }

	    $user_id = get_staff_user_id();
	    $created_by = get_staff_full_name($user_id);
	    $now = date('Y-m-d H:i:s');
	    $datas = [
	        'created_by' => $created_by,
	        'user_id'    => $user_id,
	        'created_at' => $now,
	        'updated_at' => $now,
	        'description'=> trim($data['name'])
	    ];

	    $product_id = $this->receipe_managements_model->add_itemReceipe($datas);
		
		//Store In log
		$this->log_recipe_action('add_product', ['product_id' => $product_id, 'description' => $datas['description']]);

	    if ($product_id) {
	        echo json_encode(['success' => true, 'product_id' => $product_id]);
	    } else {
	        echo json_encode(['success' => false, 'message' => 'Failed to add product']);
	    }
	}

	public function edit_product()
	{
	    header('Content-Type: application/json');
	    $data = json_decode(file_get_contents('php://input'), true);

	    if (!has_permission('receipe_managements', '', 'edit')) {
	        echo json_encode(['success' => false, 'message' => 'Access denied']);
	        return;
	    }
	    if (!$data || !isset($data['id']) || !isset($data['name']) || trim($data['name']) === '') {
	        echo json_encode(['success' => false, 'message' => 'Product name is required']);
	        return;
	    }

	    $update = [
	        'description' => trim($data['name']),
	        'updated_at' => date('Y-m-d H:i:s')
	    ];
	    $this->db->where('id', $data['id']);
	    $success = $this->db->update(db_prefix() . 'ItemReceipe', $update);

		// Store in log
		$this->log_recipe_action('edit_product', ['product_id' => $data['id'], 'description' => $update['description']]);

	    echo json_encode(['success' => $success]);
	}

	public function get_recipe_groups()
	{
		header('Content-Type: application/json');
		
		$groups = $this->receipe_managements_model->get_groups();
		echo json_encode($groups);
	}

	public function add_day_shift()
	{
	    header('Content-Type: application/json');

	    if (!has_permission('receipe_managements', '', 'create')) {
	        echo json_encode(['success' => false, 'message' => 'Access denied']);
	        return;
	    }

	    $data = json_decode(file_get_contents('php://input'), true);

		$user_id = get_staff_user_id();
	    $created_by = get_staff_full_name($user_id);
	    $now = date('Y-m-d H:i:s');


	    if (!$data || !isset($data['name']) || trim($data['name']) === '') {
	        echo json_encode(['success' => false, 'message' => 'Day shift name is required']);
	        return;
	    }

		$datas = [
	        'created_by' => $created_by,
	        'user_id'    => $user_id,
	        'created_at' => $now,
	        'day_shift'=> trim($data['name'])
	    ];

	    // Save day shift using model (implement this method if not present)
	    $day_shift_id = $this->receipe_managements_model->add_day_shift($datas);

		// Store in log
		$this->log_recipe_action('add_day_shift', ['day_shift_id' => $day_shift_id, 'day_shift' => $datas['day_shift']]);
		

	    if ($day_shift_id) {
	        echo json_encode(['success' => true, 'day_shift' => trim($data['name'])]);
	    } else {
	        echo json_encode(['success' => false, 'message' => 'Failed to add day shift']);
	    }
	}

	/**
	 * Products list
	 * @param  int $id
	 * @return view
	 */
	public function products()
	{
	    if (!has_permission('receipe_managements', '', 'view') ) {
			access_denied('products');
		}

		$data['title'] = _l('products');
		$this->load->view('receipe_managements/recipe_management/products', $data);
	}

	/**
	 * Products table data
	 * @return table
	 */
	public function products_table()
	{
		if (!$this->input->is_ajax_request()) {
			ajax_access_denied();
		}

		$this->app->get_table_data(module_views_path('receipe_managements', 'recipe_management/products_table'));
	}


	public function delete_product($id)
	{
		if (!has_permission('receipe_managements', '', 'delete')) {
			access_denied('receipe_managements');
		}

		// Delete the product from the database
		$this->db->where('id', $id);
		$this->db->delete(db_prefix() . 'ItemReceipe');

		// Store in log
		$this->log_recipe_action('delete_product', ['product_id' => $id]);

		// Optionally, set a success message
		set_alert('success', _l('deleted', _l('product')));

		// Redirect back to the products list
		redirect(admin_url('receipe_managements/products'));
	}
}