<?php
defined('BASEPATH') or exit('No direct script access allowed');

// Recipe Management tables
if (!$CI->db->table_exists(db_prefix() . 'ItemReceipe')) {
  $CI->db->query('CREATE TABLE `' . db_prefix() . "ItemReceipe` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `description` VARCHAR(255) NULL,
    `user_id` INT(11) NULL,
    `created_by` VARCHAR(255) NULL,
    `created_at` DATETIME NULL,
    `updated_at` DATETIME NULL,
    PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'ReceipeItemComponent')) {
  $CI->db->query('CREATE TABLE `' . db_prefix() . "ReceipeItemComponent` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `product_id` int(11) NOT NULL,
    `day_type` VARCHAR(50) NULL,
    `levain` LONGTEXT NULL COMMENT 'JSON data for levain components',
    `autolyse` LONGTEXT NULL COMMENT 'JSON data for autolyse components',
    `seed_mix` LONGTEXT NULL COMMENT 'JSON data for seed_mix components',
    `created_by` VARCHAR(255) NULL,
    `user_id` INT(11) NULL,
    `created_at` DATETIME NULL,
    `updated_at` DATETIME NULL,
    PRIMARY KEY (`id`),
    KEY `product_id` (`product_id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'itemcomponent')) {
  $CI->db->query('CREATE TABLE `' . db_prefix() . "itemcomponent` (
    `id` INT NOT NULL,
    `name` VARCHAR(255) NOT NULL,
    `created_at` DATETIME NOT NULL DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;");
}

if (!$CI->db->table_exists(db_prefix() . 'itemrecipegroup')) {
  $CI->db->query('CREATE TABLE `' . db_prefix() . "itemrecipegroup` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `day_shift` VARCHAR(100) NOT NULL,
    `user_id` int(11) NULL,
    `created_by` varchar(255) NULL,
    `created_at` DATETIME NULL,
    PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}

if (!$CI->db->table_exists(db_prefix() . 'recipe_log')) {
  $CI->db->query('CREATE TABLE `' . db_prefix() . "recipe_log` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` int(11) NULL,
    `module` varchar(100) NOT NULL,
    `action` varchar(100) NOT NULL,
    `details` JSON NULL,
    `created_at` DATETIME NULL,
    `created_by` varchar(255) NULL,
    PRIMARY KEY (`id`)
  ) ENGINE=InnoDB DEFAULT CHARSET=" . $CI->db->char_set . ';');
}


// ...add more tables or columns as needed...