<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
 <div class="content">
   <div class="panel_s">
    <div class="panel-body">
	<div class="clearfix"></div><br>
	 <div class="col-md-12">
	 	<h4><i class="fa fa-list-ul">&nbsp;&nbsp;</i><?php echo html_entity_decode($title); ?></h4>
	 	<hr>
	 </div>
	 <div class="row ">
		<div class="col-md-4 ">
			<?php if (has_permission('receipe_managements', '', 'create') || has_permission('receipe_managements', '', 'edit') ) { ?>
				<a href="javascript:void(0);" id="openAddProductModal" class="btn btn-info pull-left display-block mright5"><?php echo _l('add'); ?></a>
			<?php } ?>
		</div>
	</div>
	     <div class="col-md-3"> 
		    <div class="clearfix"></div><br>
		 </div>
		<div class="clearfix"></div>
        <div class="row">
            <div class="col-md-3">
                <?php echo render_date_input('start_date','start_date',''); ?>
            </div>
            <div class="col-md-3">
                <?php echo render_date_input('end_date','end_date',''); ?>
            </div>
            <div class="col-md-3">
                <div class="form-group">
                    <label class="control-label" for="product_name"><?php echo _l('product_name'); ?></label>
                    <input type="text" class="form-control" name="product_name" placeholder="<?php echo _l('search_by_product_name'); ?>">
                </div>
            </div>
        </div>
		<div class="clearfix"></div>
		<table class="table table-products_list scroll-responsive">
		      <thead>
		        <th>ID#</th>
			    <th><?php echo _l('product_name'); ?></th>
				<th><?php echo _l('created_by'); ?></th>
			    <th><?php echo _l('created_at'); ?></th>
			    <th><?php echo _l('updated_at'); ?></th>
			    <th><?php echo _l('options'); ?></th>
		      </thead>
		      <tbody></tbody>
		      <tfoot>
		         <td></td>
				 <td></td>
		         <td></td>
		         <td></td>
		         <td></td>
		         <td></td>
		      </tfoot>
		   </table>

	</div>
  </div>
 </div>
</div>

<!-- Modal HTML for Add Product -->
<div id="addProductModal" class="modal">
    <div class="modal-content">
        <button type="button" id="closeAddProductModal" class="modal-close" aria-label="Close">&times;</button>
        <h3 class="modal-title"><?php echo _l('add_new_product'); ?></h3>
        <form id="addProductForm">
            <div class="modal-form-group">
                <label for="newProductName" class="modal-label"><?php echo _l('product_name'); ?></label>
                <input type="text" id="newProductName" class="modal-input" required>
                <div id="newProductNameError" class="error-message"></div>
            </div>
            <div class="modal-actions">
                <button type="submit" class="btn btn-primary modal-save-btn"><?php echo _l('save'); ?></button>
            </div>
        </form>
    </div>
</div>

<!-- Modal HTML for Edit Product -->
<div id="editProductModal" class="modal">
    <div class="modal-content">
        <button type="button" id="closeEditProductModal" class="modal-close" aria-label="Close">&times;</button>
        <h3 class="modal-title"><?php echo _l('edit_product'); ?></h3>
        <form id="editProductForm">
            <input type="hidden" id="editProductId">
            <div class="modal-form-group">
                <label for="editProductName" class="modal-label"><?php echo _l('product_name'); ?></label>
                <input type="text" id="editProductName" class="modal-input" required>
                <div id="editProductNameError" class="error-message"></div>
            </div>
            <div class="modal-actions">
                <button type="submit" class="btn btn-primary modal-save-btn"><?php echo _l('save'); ?></button>
            </div>
        </form>
    </div>
</div>

<?php init_tail(); ?>



<script>
(function(){
  "use strict";
  var fnServerParams = {
      "product_name": "[name='product_name']",
      "end_date": "[name='end_date']",
      "start_date": "[name='start_date']",
  };

  initDataTable('.table-products_list', admin_url + 'receipe_managements/products_table', false, false, fnServerParams, [0, 'desc']);

  $('input[name="product_name"], input[name="start_date"], input[name="end_date"]').on('change', function() {
    $('.table-products_list').DataTable().ajax.reload()
                    .columns.adjust()
                    .responsive.recalc();
  });
})(jQuery);

// Show modal on Add Product button click
document.getElementById('openAddProductModal').addEventListener('click', function() {
    showModal('addProductModal');
    document.getElementById('newProductName').value = '';
    document.getElementById('newProductNameError').textContent = '';
});

// Modal show/hide helpers
function showModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) modal.classList.add('show');
}
function hideModal(modalId) {
    const modal = document.getElementById(modalId);
    if (modal) modal.classList.remove('show');
}

// Close modal on close button or clicking outside modal-content
(function() {
    const modal = document.getElementById('addProductModal');
    const closeBtn = document.getElementById('closeAddProductModal');
    if (closeBtn && modal) {
        closeBtn.addEventListener('click', function() {
            hideModal('addProductModal');
        });
    }
    if (modal) {
        modal.addEventListener('click', function(e) {
            if (e.target === modal) hideModal('addProductModal');
        });
    }
})();

// Save new product via AJAX
document.getElementById('addProductForm').addEventListener('submit', function(e) {
    e.preventDefault();
    const name = document.getElementById('newProductName').value.trim();
    const errorDiv = document.getElementById('newProductNameError');
    errorDiv.textContent = '';
    if (!name) {
        errorDiv.textContent = '<?php echo _l('please_enter_product_name'); ?>';
        return;
    }
    fetch('<?php echo admin_url('receipe_managements/add_product'); ?>', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ name })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success && data.product_id) {
            hideModal('addProductModal');
            // Optionally reload the table or show a success message
            $('.table-products_list').DataTable().ajax.reload();
        } else {
            errorDiv.textContent = data.message || '<?php echo _l('server_error'); ?>';
        }
    })
    .catch(() => {
        errorDiv.textContent = '<?php echo _l('server_error'); ?>';
    });
});

// Open Edit Product modal and populate fields
$(document).on('click', '.edit-product-btn', function() {
    const productId = $(this).data('id');
    const productName = $(this).data('name');
    $('#editProductId').val(productId);
    $('#editProductName').val(productName);
    $('#editProductNameError').text('');
    showModal('editProductModal');
});

// Close modal on close button or clicking outside modal-content
(function() {
    const modal = document.getElementById('editProductModal');
    const closeBtn = document.getElementById('closeEditProductModal');
    if (closeBtn && modal) {
        closeBtn.addEventListener('click', function() {
            hideModal('editProductModal');
        });
    }
    if (modal) {
        modal.addEventListener('click', function(e) {
            if (e.target === modal) hideModal('editProductModal');
        });
    }
})();

// Save edited product via AJAX
document.getElementById('editProductForm').addEventListener('submit', function(e) {
    e.preventDefault();
    const id = document.getElementById('editProductId').value;
    const name = document.getElementById('editProductName').value.trim();
    const errorDiv = document.getElementById('editProductNameError');
    errorDiv.textContent = '';
    if (!name) {
        errorDiv.textContent = '<?php echo _l('please_enter_product_name'); ?>';
        return;
    }
    fetch('<?php echo admin_url('receipe_managements/edit_product'); ?>', {
        method: 'POST',
        headers: { 'Content-Type': 'application/json' },
        body: JSON.stringify({ id, name })
    })
    .then(res => res.json())
    .then(data => {
        if (data.success) {
            hideModal('editProductModal');
            $('.table-products_list').DataTable().ajax.reload();
        } else {
            errorDiv.textContent = data.message || '<?php echo _l('server_error'); ?>';
        }
    })
    .catch(() => {
        errorDiv.textContent = '<?php echo _l('server_error'); ?>';
    });
});
</script>