<?php
defined('BASEPATH') or exit('No direct script access allowed');

$CI = &get_instance();

if ($CI->input->is_ajax_request()) {
    if ($CI->input->post()) {
        
        $product_name = $CI->input->post('product_name');
        $end_date = $CI->input->post('end_date');
        $start_date = $CI->input->post('start_date');

        $select = [
            'id',
            'id',
            'id',
            'id',
            'id',
            'id'
        ];

        $where = [];

        // Filter by product name
        if (isset($product_name) && $product_name != '') {
            if (count($where) > 0) {
                array_push($where, ' and ' . db_prefix() . 'ItemReceipe.description LIKE "%' . $CI->db->escape_like_str($product_name) . '%"');
            } else {
                array_push($where, ' where ' . db_prefix() . 'ItemReceipe.description LIKE "%' . $CI->db->escape_like_str($product_name) . '%"');
            }
        }

        // Filter by date range
        if ($end_date != '' && $start_date != '') {
            if (!$CI->receipe_managements_model->check_format_date($start_date)) {
                $start_date = to_sql_date($start_date);
            }

            if (!$CI->receipe_managements_model->check_format_date($end_date)) {
                $end_date = to_sql_date($end_date);
            }

            if (count($where) > 0) {
                array_push($where, ' and date(' . db_prefix() . 'ItemReceipe.created_at) between "' . $start_date . '" and "' . $end_date . '"');
            } else {
                array_push($where, ' where date(' . db_prefix() . 'ItemReceipe.created_at) between "' . $start_date . '" and "' . $end_date . '"');
            }
        }

        $aColumns = $select;
        $sIndexColumn = 'id';
        $sTable = db_prefix() . 'ItemReceipe';
        $join = [];

        $result = data_tables_init($aColumns, $sIndexColumn, $sTable, $join, $where, [
            db_prefix() . 'ItemReceipe.id',
            db_prefix() . 'ItemReceipe.description',
            db_prefix() . 'ItemReceipe.created_by',
            db_prefix() . 'ItemReceipe.created_at',
            db_prefix() . 'ItemReceipe.updated_at'
        ]);

        $output = $result['output'];
        $rResult = $result['rResult'];


        foreach ($rResult as $aRow) {
            $row = [];
            $row[] = $aRow['id'];
            $row[] = $aRow['description'] ? $aRow['description'] : '-';
            $row[] = $aRow['created_by'] ? $aRow['created_by'] : '-';
            $row[] = $aRow['created_at'] ? _dt($aRow['created_at']) : '-';
            $row[] = $aRow['updated_at'] ? _dt($aRow['updated_at']) : '-';

            $option = '';
            

            if (has_permission('receipe_managements', '', 'edit')) {
                $option .= '<a href="javascript:void(0);" data-id="' . $aRow['id'] . '" data-name="' . htmlspecialchars($aRow['description'], ENT_QUOTES) . '" data-toggle="tooltip" data-placement="top" data-title="' . _l('edit') . '" class="btn btn-default btn-icon edit-product-btn">';
                $option .= '<i class="fa fa-edit"></i>';
                $option .= '</a>';
            }

            if (has_permission('receipe_managements', '', 'delete')) {
                $option .= '<a href="' . admin_url('receipe_managements/delete_product/' . $aRow['id']) . '" data-toggle="tooltip" data-placement="top" data-title="' . _l('delete') . '" class="btn btn-danger btn-icon _delete">';
                $option .= '<i class="fa fa-remove"></i>';
                $option .= '</a>';
            }

            $row[] = $option;

            $output['aaData'][] = $row;
        }

        echo json_encode($output);
        die();
    }
}
?>