<?php

defined('BASEPATH') or exit('No direct script access allowed');

/**
 * Website helper functions
 */

/**
 * Get website setting
 */
function get_website_setting($key, $default = null)
{
    $CI = &get_instance();
    $CI->load->model('website/website_model');
    
    $value = $CI->website_model->get_setting($key);
    return $value !== null ? $value : $default;
}

/**
 * Get website pages
 */
function get_website_pages($where = [])
{
    $CI = &get_instance();
    $CI->load->model('website/website_model');
    
    return $CI->website_model->get_pages($where);
}

/**
 * Get website page by slug
 */
function get_website_page($slug)
{
    $CI = &get_instance();
    $CI->load->model('website/website_model');
    
    return $CI->website_model->get_page_by_slug($slug);
}

/**
 * Get website navigation
 */
function get_website_navigation()
{
    $CI = &get_instance();
    $CI->load->model('website/website_model');
    
    return $CI->website_model->get_navigation_tree();
}

/**
 * Render website navigation
 */
function render_website_navigation($class = 'nav', $ul_class = '')
{
    $navigation = get_website_navigation();
    
    if (empty($navigation)) {
        return '';
    }
    
    $html = '<ul class="' . $ul_class . '">';
    
    foreach ($navigation as $item) {
        $html .= '<li>';
        $html .= '<a href="' . $item->url . '" target="' . $item->target . '">' . $item->title . '</a>';
        
        if (!empty($item->children)) {
            $html .= render_website_navigation_item_children($item->children);
        }
        
        $html .= '</li>';
    }
    
    $html .= '</ul>';
    
    return $html;
}

/**
 * Render navigation item children
 */
function render_website_navigation_item_children($children)
{
    $html = '<ul class="submenu">';
    
    foreach ($children as $child) {
        $html .= '<li>';
        $html .= '<a href="' . $child->url . '" target="' . $child->target . '">' . $child->title . '</a>';
        
        if (!empty($child->children)) {
            $html .= render_website_navigation_item_children($child->children);
        }
        
        $html .= '</li>';
    }
    
    $html .= '</ul>';
    
    return $html;
}

/**
 * Get website media
 */
function get_website_media($where = [])
{
    $CI = &get_instance();
    $CI->load->model('website/website_model');
    
    return $CI->website_model->get_media($where);
}

/**
 * Get website templates
 */
function get_website_templates($where = [])
{
    $CI = &get_instance();
    $CI->load->model('website/website_model');
    
    return $CI->website_model->get_templates($where);
}

/**
 * Generate page URL
 */
function website_page_url($slug)
{
    return site_url($slug);
}

/**
 * Generate media URL
 */
function website_media_url($file_path)
{
    return site_url($file_path);
}

/**
 * Format file size
 */
function format_file_size($bytes)
{
    if ($bytes >= 1073741824) {
        return number_format($bytes / 1073741824, 2) . ' GB';
    } elseif ($bytes >= 1048576) {
        return number_format($bytes / 1048576, 2) . ' MB';
    } elseif ($bytes >= 1024) {
        return number_format($bytes / 1024, 2) . ' KB';
    } else {
        return $bytes . ' bytes';
    }
}

/**
 * Get file extension
 */
function get_file_extension($filename)
{
    return strtolower(pathinfo($filename, PATHINFO_EXTENSION));
}

/**
 * Check if file is image
 */
function is_image_file($filename)
{
    $image_extensions = ['jpg', 'jpeg', 'png', 'gif', 'bmp', 'webp', 'svg'];
    $extension = get_file_extension($filename);
    
    return in_array($extension, $image_extensions);
}

/**
 * Check if file is video
 */
function is_video_file($filename)
{
    $video_extensions = ['mp4', 'avi', 'mov', 'wmv', 'flv', 'webm'];
    $extension = get_file_extension($filename);
    
    return in_array($extension, $video_extensions);
}

/**
 * Check if file is document
 */
function is_document_file($filename)
{
    $document_extensions = ['pdf', 'doc', 'docx', 'xls', 'xlsx', 'ppt', 'pptx', 'txt'];
    $extension = get_file_extension($filename);
    
    return in_array($extension, $document_extensions);
}

/**
 * Generate slug from title
 */
function generate_website_slug($title)
{
    $CI = &get_instance();
    $CI->load->model('website/website_model');
    
    return $CI->website_model->generate_slug($title);
}

/**
 * Get page excerpt
 */
function get_page_excerpt($content, $length = 150)
{
    $excerpt = strip_tags($content);
    
    if (strlen($excerpt) > $length) {
        $excerpt = substr($excerpt, 0, $length);
        $excerpt = substr($excerpt, 0, strrpos($excerpt, ' ')) . '...';
    }
    
    return $excerpt;
}

/**
 * Get website statistics
 */
function get_website_stats()
{
    $CI = &get_instance();
    $CI->load->model('website/website_model');
    
    return [
        'pages' => $CI->website_model->get_page_stats(),
        'media' => $CI->website_model->get_media_stats()
    ];
}

/**
 * Check if website module is active
 */
function is_website_module_active()
{
    $CI = &get_instance();
    return $CI->app_modules->is_installed('website');
}

/**
 * Get website module version
 */
function get_website_module_version()
{
    return '1.0.0';
}

/**
 * Render page content
 */
function render_page_content($content)
{
    // Process shortcodes if needed
    $content = do_shortcode($content);
    
    // Process other content filters
    $content = apply_filters('website_page_content', $content);
    
    return $content;
}

/**
 * Do shortcode (placeholder for future shortcode system)
 */
function do_shortcode($content)
{
    // Placeholder for shortcode processing
    return $content;
}

/**
 * Apply filters (placeholder for future filter system)
 */
function apply_filters($filter_name, $content)
{
    // Placeholder for filter system
    return $content;
}
