<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <h4 class="no-margin"><?php echo _l('website_dashboard'); ?></h4>
                        <hr class="hr-panel-heading" />
                        
                        <!-- Statistics Cards -->
                        <div class="row">
                            <div class="col-md-3">
                                <div class="panel panel-info">
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-xs-9">
                                                <div class="huge"><?php echo $pages_count; ?></div>
                                                <div><?php echo _l('total_pages'); ?></div>
                                            </div>
                                            <div class="col-xs-3 text-right">
                                                <i class="fa fa-file-text fa-5x"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <a href="<?php echo admin_url('website/pages'); ?>">
                                        <div class="panel-footer">
                                            <span class="pull-left"><?php echo _l('view_details'); ?></span>
                                            <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                                            <div class="clearfix"></div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="panel panel-success">
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-xs-9">
                                                <div class="huge"><?php echo $templates_count; ?></div>
                                                <div><?php echo _l('total_templates'); ?></div>
                                            </div>
                                            <div class="col-xs-3 text-right">
                                                <i class="fa fa-paint-brush fa-5x"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <a href="<?php echo admin_url('website/templates'); ?>">
                                        <div class="panel-footer">
                                            <span class="pull-left"><?php echo _l('view_details'); ?></span>
                                            <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                                            <div class="clearfix"></div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="panel panel-warning">
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-xs-9">
                                                <div class="huge"><?php echo $media_count; ?></div>
                                                <div><?php echo _l('total_media'); ?></div>
                                            </div>
                                            <div class="col-xs-3 text-right">
                                                <i class="fa fa-image fa-5x"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <a href="<?php echo admin_url('website/media'); ?>">
                                        <div class="panel-footer">
                                            <span class="pull-left"><?php echo _l('view_details'); ?></span>
                                            <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                                            <div class="clearfix"></div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                            
                            <div class="col-md-3">
                                <div class="panel panel-primary">
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-xs-9">
                                                <div class="huge"><?php echo count($recent_pages); ?></div>
                                                <div><?php echo _l('recent_pages'); ?></div>
                                            </div>
                                            <div class="col-xs-3 text-right">
                                                <i class="fa fa-clock-o fa-5x"></i>
                                            </div>
                                        </div>
                                    </div>
                                    <a href="<?php echo admin_url('website/pages'); ?>">
                                        <div class="panel-footer">
                                            <span class="pull-left"><?php echo _l('view_details'); ?></span>
                                            <span class="pull-right"><i class="fa fa-arrow-circle-right"></i></span>
                                            <div class="clearfix"></div>
                                        </div>
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Quick Actions -->
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h3 class="panel-title"><?php echo _l('quick_actions'); ?></h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="row">
                                            <div class="col-md-3">
                                                <a href="<?php echo admin_url('website/add_page'); ?>" class="btn btn-primary btn-block">
                                                    <i class="fa fa-plus"></i> <?php echo _l('add_page'); ?>
                                                </a>
                                            </div>
                                            <div class="col-md-3">
                                                <a href="<?php echo admin_url('website/add_template'); ?>" class="btn btn-success btn-block">
                                                    <i class="fa fa-paint-brush"></i> <?php echo _l('add_template'); ?>
                                                </a>
                                            </div>
                                            <div class="col-md-3">
                                                <a href="<?php echo admin_url('website/media'); ?>" class="btn btn-info btn-block">
                                                    <i class="fa fa-upload"></i> <?php echo _l('upload_media'); ?>
                                                </a>
                                            </div>
                                            <div class="col-md-3">
                                                <a href="<?php echo admin_url('website/settings'); ?>" class="btn btn-warning btn-block">
                                                    <i class="fa fa-cog"></i> <?php echo _l('settings'); ?>
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <!-- Recent Pages -->
                        <?php if (!empty($recent_pages)): ?>
                        <div class="row">
                            <div class="col-md-12">
                                <div class="panel panel-default">
                                    <div class="panel-heading">
                                        <h3 class="panel-title"><?php echo _l('recent_pages'); ?></h3>
                                    </div>
                                    <div class="panel-body">
                                        <div class="table-responsive">
                                            <table class="table table-striped">
                                                <thead>
                                                    <tr>
                                                        <th><?php echo _l('title'); ?></th>
                                                        <th><?php echo _l('status'); ?></th>
                                                        <th><?php echo _l('created_at'); ?></th>
                                                        <th><?php echo _l('actions'); ?></th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <?php foreach ($recent_pages as $page): ?>
                                                    <tr>
                                                        <td>
                                                            <a href="<?php echo admin_url('website/edit_page/' . $page->id); ?>">
                                                                <?php echo $page->title; ?>
                                                            </a>
                                                        </td>
                                                        <td>
                                                            <span class="label label-<?php echo $page->status == 'published' ? 'success' : ($page->status == 'draft' ? 'warning' : 'default'); ?>">
                                                                <?php echo ucfirst($page->status); ?>
                                                            </span>
                                                        </td>
                                                        <td><?php echo _dt($page->created_at); ?></td>
                                                        <td>
                                                            <a href="<?php echo admin_url('website/edit_page/' . $page->id); ?>" class="btn btn-default btn-xs">
                                                                <i class="fa fa-edit"></i>
                                                            </a>
                                                            <a href="<?php echo admin_url('website/preview/' . $page->id); ?>" class="btn btn-info btn-xs" target="_blank">
                                                                <i class="fa fa-eye"></i>
                                                            </a>
                                                        </td>
                                                    </tr>
                                                    <?php endforeach; ?>
                                                </tbody>
                                            </table>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
