<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php init_head(); ?>
<style>
.form-group {
    margin-bottom: 20px;
}
.form-control {
    border-radius: 4px;
    border: 1px solid #ddd;
    padding: 8px 12px;
}
.btn-group .btn {
    margin-right: 10px;
}
.btn-group .btn:last-child {
    margin-right: 0;
}
</style>
<div id="wrapper">
    <div class="content">
        <div class="row">
            <div class="col-md-12">
                <div class="panel_s">
                    <div class="panel-body">
                        <div class="row">
                            <div class="col-md-12">
                                <h4 class="no-margin"><?php echo _l('add_new_page'); ?></h4>
                                <hr class="hr-panel-heading" />
                                
                                <!-- Builder Mode Selection -->
                                <div class="row" style="margin-bottom: 20px;">
                                    <div class="col-md-12">
                                        <div class="btn-group" role="group">
                                            <button type="button" class="btn btn-default active" id="text-editor-mode">
                                                <i class="fa fa-edit"></i> Text Editor
                                            </button>
                                            <button type="button" class="btn btn-primary" id="visual-builder-mode">
                                                <i class="fa fa-paint-brush"></i> Visual Builder
                                            </button>
                                        </div>
                                        <p class="text-muted" style="margin-top: 10px;">
                                            Choose between traditional text editor or visual drag-and-drop page builder
                                        </p>
                                    </div>
                                </div>
                            </div>
                        </div>
                        
                        <div class="row">
                            <div class="col-md-12">
                                <?php echo form_open(admin_url('website/save_page')); ?>
                                
                                <!-- Page Title (Hidden for Visual Builder) -->
                                <input type="hidden" id="page-title" name="title" value="<?php echo set_value('title'); ?>">
                                
                                <div class="row" id="text-editor-content">
                                    <div class="col-md-8">
                                        <div class="form-group">
                                            <label for="title"><?php echo _l('title'); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="title" name="title" value="<?php echo set_value('title'); ?>" required>
                                            <?php echo form_error('title'); ?>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="slug"><?php echo _l('slug'); ?> <span class="text-danger">*</span></label>
                                            <input type="text" class="form-control" id="slug" name="slug" value="<?php echo set_value('slug'); ?>" required>
                                            <small class="text-muted"><?php echo _l('slug_help_text'); ?></small>
                                            <?php echo form_error('slug'); ?>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="excerpt"><?php echo _l('excerpt'); ?></label>
                                            <textarea class="form-control" id="excerpt" name="excerpt" rows="3"><?php echo set_value('excerpt'); ?></textarea>
                                            <?php echo form_error('excerpt'); ?>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="content"><?php echo _l('content'); ?> <span class="text-danger">*</span></label>
                                            <textarea class="form-control" id="content" name="content" rows="10" required><?php echo set_value('content'); ?></textarea>
                                            <?php echo form_error('content'); ?>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-4">
                                        <div class="form-group">
                                            <label for="status"><?php echo _l('status'); ?></label>
                                            <select class="form-control" id="status" name="status">
                                                <option value="draft" <?php echo set_select('status', 'draft', true); ?>><?php echo _l('draft'); ?></option>
                                                <option value="published" <?php echo set_select('status', 'published'); ?>><?php echo _l('published'); ?></option>
                                                <option value="archived" <?php echo set_select('status', 'archived'); ?>><?php echo _l('archived'); ?></option>
                                            </select>
                                            <?php echo form_error('status'); ?>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="template_id"><?php echo _l('template'); ?></label>
                                            <select class="form-control" id="template_id" name="template_id">
                                                <option value=""><?php echo _l('default_template'); ?></option>
                                                <?php if (!empty($templates)): ?>
                                                    <?php foreach ($templates as $template): ?>
                                                        <option value="<?php echo $template->id; ?>" <?php echo set_select('template_id', $template->id); ?>>
                                                            <?php echo $template->name; ?>
                                                        </option>
                                                    <?php endforeach; ?>
                                                <?php endif; ?>
                                            </select>
                                            <?php echo form_error('template_id'); ?>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="featured_image"><?php echo _l('featured_image'); ?></label>
                                            <input type="text" class="form-control" id="featured_image" name="featured_image" value="<?php echo set_value('featured_image'); ?>">
                                            <small class="text-muted"><?php echo _l('featured_image_help_text'); ?></small>
                                            <?php echo form_error('featured_image'); ?>
                                        </div>
                                        
                                        <div class="form-group">
                                            <label for="sort_order"><?php echo _l('sort_order'); ?></label>
                                            <input type="number" class="form-control" id="sort_order" name="sort_order" value="<?php echo set_value('sort_order', 0); ?>" min="0">
                                            <?php echo form_error('sort_order'); ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-12">
                                        <h5><?php echo _l('seo_settings'); ?></h5>
                                        <hr>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="meta_title"><?php echo _l('meta_title'); ?></label>
                                            <input type="text" class="form-control" id="meta_title" name="meta_title" value="<?php echo set_value('meta_title'); ?>">
                                            <small class="text-muted"><?php echo _l('meta_title_help_text'); ?></small>
                                            <?php echo form_error('meta_title'); ?>
                                        </div>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="meta_keywords"><?php echo _l('meta_keywords'); ?></label>
                                            <input type="text" class="form-control" id="meta_keywords" name="meta_keywords" value="<?php echo set_value('meta_keywords'); ?>">
                                            <small class="text-muted"><?php echo _l('meta_keywords_help_text'); ?></small>
                                            <?php echo form_error('meta_keywords'); ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="form-group">
                                            <label for="meta_description"><?php echo _l('meta_description'); ?></label>
                                            <textarea class="form-control" id="meta_description" name="meta_description" rows="3"><?php echo set_value('meta_description'); ?></textarea>
                                            <small class="text-muted"><?php echo _l('meta_description_help_text'); ?></small>
                                            <?php echo form_error('meta_description'); ?>
                                        </div>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-12">
                                        <div class="btn-group">
                                            <button type="submit" class="btn btn-info">
                                                <i class="fa fa-save"></i> <?php echo _l('save_page'); ?>
                                            </button>
                                            <a href="<?php echo admin_url('website/pages'); ?>" class="btn btn-default">
                                                <i class="fa fa-times"></i> <?php echo _l('cancel'); ?>
                                            </a>
                                        </div>
                                    </div>
                                </div>
                                
                                <!-- Visual Builder Container -->
                                <div id="visual-builder-content" style="display: none;">
                                    <div class="alert alert-info">
                                        <i class="fa fa-info-circle"></i>
                                        <strong>Visual Page Builder</strong> - Drag and drop components to build your page visually.
                                        <a href="<?php echo admin_url('website/page_builder'); ?>" class="btn btn-primary btn-sm pull-right">
                                            <i class="fa fa-external-link"></i> Open Visual Builder
                                        </a>
                                    </div>
                                </div>
                                
                                <?php echo form_close(); ?>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?php init_tail(); ?>
<script>
$(document).ready(function() {
    // Mode switching
    $('#text-editor-mode').click(function() {
        $(this).removeClass('btn-default').addClass('btn-primary');
        $('#visual-builder-mode').removeClass('btn-primary').addClass('btn-default');
        $('#text-editor-content').show();
        $('#visual-builder-content').hide();
    });
    
    $('#visual-builder-mode').click(function() {
        $(this).removeClass('btn-default').addClass('btn-primary');
        $('#text-editor-mode').removeClass('btn-primary').addClass('btn-default');
        $('#text-editor-content').hide();
        $('#visual-builder-content').show();
    });
    
    // Auto-generate slug from title
    $('#title').on('blur', function() {
        var title = $(this).val();
        if (title && !$('#slug').val()) {
            var slug = title.toLowerCase()
                .replace(/[^a-z0-9\s-]/g, '')
                .replace(/\s+/g, '-')
                .replace(/-+/g, '-')
                .trim('-');
            $('#slug').val(slug);
        }
        
        // Update hidden page title for visual builder
        $('#page-title').val(title);
    });
    
    // Initialize CKEditor for content
    if (typeof CKEDITOR !== 'undefined') {
        CKEDITOR.replace('content', {
            height: 300,
            toolbar: [
                { name: 'basicstyles', items: ['Bold', 'Italic', 'Underline', 'Strike'] },
                { name: 'paragraph', items: ['NumberedList', 'BulletedList', '-', 'Outdent', 'Indent'] },
                { name: 'links', items: ['Link', 'Unlink'] },
                { name: 'insert', items: ['Image', 'Table'] },
                { name: 'styles', items: ['Format', 'Font', 'FontSize'] },
                { name: 'colors', items: ['TextColor', 'BGColor'] },
                { name: 'tools', items: ['Maximize'] }
            ]
        });
    }
});
</script>
