<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php $this->load->view('frontend/includes/header'); ?>

<div class="container-fluid py-5">
    <div class="container">
        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="page-header text-center">
                    <h1 class="display-4 text-primary">Shopping Cart</h1>
                    <p class="lead">Review your items before checkout</p>
                </div>
            </div>
        </div>

        <div class="row">
            <div class="col-12">
                <div id="cart-content">
                    <!-- Cart items will be loaded here via JavaScript -->
                    <div class="text-center py-5">
                        <i class="fa fa-spinner fa-spin fa-3x text-muted"></i>
                        <p class="mt-3">Loading cart...</p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<style>
.cart-item {
    border: 1px solid #e9ecef;
    border-radius: 10px;
    padding: 20px;
    margin-bottom: 20px;
    background: #fff;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.cart-item-image {
    width: 100px;
    height: 100px;
    object-fit: cover;
    border-radius: 8px;
}

.cart-item-details h5 {
    margin-bottom: 10px;
    color: #333;
}

.cart-item-price {
    font-size: 1.2em;
    font-weight: 700;
    color: #007bff;
}

.quantity-controls .btn {
    border-radius: 0;
    width: 40px;
    height: 40px;
    display: flex;
    align-items: center;
    justify-content: center;
}

.quantity-controls .form-control {
    border-left: none;
    border-right: none;
    text-align: center;
    width: 80px;
}

.cart-summary {
    background: #f8f9fa;
    border-radius: 10px;
    padding: 30px;
    position: sticky;
    top: 20px;
}

.cart-summary h4 {
    color: #333;
    margin-bottom: 20px;
}

.summary-row {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    padding: 5px 0;
}

.summary-row.total {
    border-top: 2px solid #dee2e6;
    padding-top: 15px;
    margin-top: 15px;
    font-weight: 700;
    font-size: 1.1em;
}

.empty-cart {
    text-align: center;
    padding: 60px 20px;
}

.empty-cart i {
    font-size: 4em;
    color: #6c757d;
    margin-bottom: 20px;
}

.btn-checkout {
    background: linear-gradient(45deg, #28a745, #20c997);
    border: none;
    border-radius: 25px;
    padding: 15px 30px;
    font-weight: 600;
    font-size: 1.1em;
    transition: all 0.3s ease;
}

.btn-checkout:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(40, 167, 69, 0.3);
}

.btn-continue {
    border-radius: 25px;
    padding: 10px 25px;
    font-weight: 600;
}

.remove-item {
    color: #dc3545;
    background: none;
    border: none;
    font-size: 1.2em;
    transition: color 0.3s ease;
}

.remove-item:hover {
    color: #c82333;
}
</style>

<script>
$(document).ready(function() {
    loadCart();
    
    function loadCart() {
        $.ajax({
            url: '<?php echo site_url("website/get_cart"); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    displayCart(response.data);
                } else {
                    showEmptyCart();
                }
            },
            error: function() {
                showEmptyCart();
            }
        });
    }
    
    function displayCart(cartData) {
        if (!cartData || cartData.length === 0) {
            showEmptyCart();
            return;
        }
        
        var html = '<div class="row">';
        html += '<div class="col-lg-8">';
        
        // Cart items
        var total = 0;
        cartData.forEach(function(item) {
            var itemTotal = item.price * item.quantity;
            total += itemTotal;
            
            html += '<div class="cart-item" data-id="' + item.id + '">';
            html += '<div class="row align-items-center">';
            html += '<div class="col-md-2">';
            html += '<img src="' + item.image + '" alt="' + item.name + '" class="cart-item-image">';
            html += '</div>';
            html += '<div class="col-md-4">';
            html += '<div class="cart-item-details">';
            html += '<h5>' + item.name + '</h5>';
            html += '<p class="text-muted small">SKU: ' + item.sku + '</p>';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-2">';
            html += '<div class="cart-item-price">' + formatMoney(item.price) + '</div>';
            html += '</div>';
            html += '<div class="col-md-3">';
            html += '<div class="quantity-controls d-flex justify-content-center">';
            html += '<button class="btn btn-outline-secondary qty-minus" data-id="' + item.id + '">';
            html += '<i class="fa fa-minus"></i>';
            html += '</button>';
            html += '<input type="number" class="form-control qty-input" value="' + item.quantity + '" data-id="' + item.id + '" min="1" max="' + item.stock + '">';
            html += '<button class="btn btn-outline-secondary qty-plus" data-id="' + item.id + '">';
            html += '<i class="fa fa-plus"></i>';
            html += '</button>';
            html += '</div>';
            html += '</div>';
            html += '<div class="col-md-1">';
            html += '<button class="btn remove-item" data-id="' + item.id + '" title="Remove item">';
            html += '<i class="fa fa-trash"></i>';
            html += '</button>';
            html += '</div>';
            html += '</div>';
            html += '</div>';
        });
        
        html += '</div>'; // Close col-lg-8
        
        // Cart summary
        html += '<div class="col-lg-4">';
        html += '<div class="cart-summary">';
        html += '<h4>Order Summary</h4>';
        html += '<div class="summary-row">';
        html += '<span>Subtotal (' + cartData.length + ' items):</span>';
        html += '<span>' + formatMoney(total) + '</span>';
        html += '</div>';
        html += '<div class="summary-row">';
        html += '<span>Shipping:</span>';
        html += '<span>Free</span>';
        html += '</div>';
        html += '<div class="summary-row">';
        html += '<span>Tax:</span>';
        html += '<span>Included</span>';
        html += '</div>';
        html += '<div class="summary-row total">';
        html += '<span>Total:</span>';
        html += '<span>' + formatMoney(total) + '</span>';
        html += '</div>';
        html += '<div class="mt-4">';
        html += '<a href="<?php echo site_url("website/checkout"); ?>" class="btn btn-checkout btn-block">';
        html += '<i class="fa fa-credit-card"></i> Proceed to Checkout';
        html += '</a>';
        html += '</div>';
        html += '</div>';
        html += '</div>'; // Close col-lg-4
        html += '</div>'; // Close row
        
        $('#cart-content').html(html);
        
        // Bind events
        bindCartEvents();
    }
    
    function showEmptyCart() {
        var html = '<div class="empty-cart">';
        html += '<i class="fa fa-shopping-cart"></i>';
        html += '<h3>Your cart is empty</h3>';
        html += '<p class="text-muted">Looks like you haven\'t added any items to your cart yet.</p>';
        html += '<a href="<?php echo site_url("website/products"); ?>" class="btn btn-primary btn-continue">';
        html += '<i class="fa fa-shopping-bag"></i> Continue Shopping';
        html += '</a>';
        html += '</div>';
        
        $('#cart-content').html(html);
    }
    
    function bindCartEvents() {
        // Quantity controls
        $('.qty-minus').click(function() {
            var productId = $(this).data('id');
            var input = $(this).siblings('.qty-input');
            var currentVal = parseInt(input.val());
            if (currentVal > 1) {
                updateQuantity(productId, currentVal - 1);
            }
        });
        
        $('.qty-plus').click(function() {
            var productId = $(this).data('id');
            var input = $(this).siblings('.qty-input');
            var currentVal = parseInt(input.val());
            var maxVal = parseInt(input.attr('max'));
            if (currentVal < maxVal) {
                updateQuantity(productId, currentVal + 1);
            }
        });
        
        $('.qty-input').change(function() {
            var productId = $(this).data('id');
            var quantity = parseInt($(this).val());
            var maxVal = parseInt($(this).attr('max'));
            
            if (quantity < 1) quantity = 1;
            if (quantity > maxVal) quantity = maxVal;
            
            $(this).val(quantity);
            updateQuantity(productId, quantity);
        });
        
        // Remove item
        $('.remove-item').click(function() {
            var productId = $(this).data('id');
            removeFromCart(productId);
        });
    }
    
    function updateQuantity(productId, quantity) {
        $.ajax({
            url: '<?php echo site_url("website/update_cart"); ?>',
            type: 'POST',
            data: {
                product_id: productId,
                quantity: quantity
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    loadCart(); // Reload cart
                    updateCartCount();
                } else {
                    showAlert(response.message || 'Error updating cart', 'error');
                }
            },
            error: function() {
                showAlert('Error updating cart', 'error');
            }
        });
    }
    
    function removeFromCart(productId) {
        if (confirm('Are you sure you want to remove this item from your cart?')) {
            $.ajax({
                url: '<?php echo site_url("website/remove_from_cart"); ?>',
                type: 'POST',
                data: {
                    product_id: productId
                },
                dataType: 'json',
                success: function(response) {
                    if (response.success) {
                        loadCart(); // Reload cart
                        updateCartCount();
                        showAlert('Item removed from cart', 'success');
                    } else {
                        showAlert(response.message || 'Error removing item', 'error');
                    }
                },
                error: function() {
                    showAlert('Error removing item', 'error');
                }
            });
        }
    }
    
    function updateCartCount() {
        $.ajax({
            url: '<?php echo site_url("website/get_cart_count"); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    $('.cart-count').text(response.count);
                }
            }
        });
    }
    
    function formatMoney(amount) {
        return '<?php echo $base_currency->symbol; ?>' + parseFloat(amount).toFixed(2);
    }
    
    function showAlert(message, type) {
        var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
        var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999;">' +
                       '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
                       message +
                       '</div>';
        $('body').append(alertHtml);
        
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 3000);
    }
});
</script>

<?php $this->load->view('frontend/includes/footer'); ?>

