<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php $this->load->view('frontend/includes/header'); ?>

<div class="container-fluid py-5">
    <div class="container">
        <!-- Page Header -->
        <div class="row mb-4">
            <div class="col-12">
                <div class="page-header text-center">
                    <h1 class="display-4 text-primary">Checkout</h1>
                    <p class="lead">Complete your order</p>
                </div>
            </div>
        </div>

        <form id="checkout-form" method="POST" action="<?php echo site_url('website/process_checkout'); ?>">
            <div class="row">
                <!-- Checkout Form -->
                <div class="col-lg-8">
                    <div class="checkout-sections">
                        <!-- Customer Information -->
                        <div class="checkout-section mb-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0"><i class="fa fa-user"></i> Customer Information</h5>
                                </div>
                                <div class="card-body">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="first_name">First Name *</label>
                                                <input type="text" class="form-control" id="first_name" name="first_name" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="last_name">Last Name *</label>
                                                <input type="text" class="form-control" id="last_name" name="last_name" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="email">Email Address *</label>
                                                <input type="email" class="form-control" id="email" name="email" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="phone">Phone Number *</label>
                                                <input type="tel" class="form-control" id="phone" name="phone" required>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Shipping Address -->
                        <div class="checkout-section mb-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0"><i class="fa fa-truck"></i> Shipping Address</h5>
                                </div>
                                <div class="card-body">
                                    <div class="form-group">
                                        <label for="address">Street Address *</label>
                                        <input type="text" class="form-control" id="address" name="address" required>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="city">City *</label>
                                                <input type="text" class="form-control" id="city" name="city" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="state">State/Province *</label>
                                                <input type="text" class="form-control" id="state" name="state" required>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="postal_code">Postal Code *</label>
                                                <input type="text" class="form-control" id="postal_code" name="postal_code" required>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label for="country">Country *</label>
                                                <select class="form-control" id="country" name="country" required>
                                                    <option value="">Select Country</option>
                                                    <option value="US">United States</option>
                                                    <option value="CA">Canada</option>
                                                    <option value="UK">United Kingdom</option>
                                                    <option value="AU">Australia</option>
                                                    <option value="DE">Germany</option>
                                                    <option value="FR">France</option>
                                                    <option value="IT">Italy</option>
                                                    <option value="ES">Spain</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Payment Method -->
                        <div class="checkout-section mb-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0"><i class="fa fa-credit-card"></i> Payment Method</h5>
                                </div>
                                <div class="card-body">
                                    <?php if (!empty($payment_modes)): ?>
                                        <?php foreach ($payment_modes as $payment): ?>
                                            <div class="form-check mb-3">
                                                <input class="form-check-input" type="radio" name="payment_method" id="payment_<?php echo $payment->id; ?>" value="<?php echo $payment->id; ?>" required>
                                                <label class="form-check-label" for="payment_<?php echo $payment->id; ?>">
                                                    <strong><?php echo $payment->name; ?></strong>
                                                    <?php if (!empty($payment->description)): ?>
                                                        <br><small class="text-muted"><?php echo $payment->description; ?></small>
                                                    <?php endif; ?>
                                                </label>
                                            </div>
                                        <?php endforeach; ?>
                                    <?php else: ?>
                                        <div class="alert alert-info">
                                            <i class="fa fa-info-circle"></i>
                                            No payment methods available. Please contact us to complete your order.
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Order Notes -->
                        <div class="checkout-section mb-4">
                            <div class="card">
                                <div class="card-header">
                                    <h5 class="mb-0"><i class="fa fa-sticky-note"></i> Order Notes (Optional)</h5>
                                </div>
                                <div class="card-body">
                                    <div class="form-group">
                                        <textarea class="form-control" id="order_notes" name="order_notes" rows="3" placeholder="Any special instructions for your order..."></textarea>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Order Summary -->
                <div class="col-lg-4">
                    <div class="order-summary">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="mb-0"><i class="fa fa-shopping-cart"></i> Order Summary</h5>
                            </div>
                            <div class="card-body">
                                <div id="order-items">
                                    <!-- Order items will be loaded here -->
                                    <div class="text-center py-3">
                                        <i class="fa fa-spinner fa-spin"></i>
                                        <p class="mt-2">Loading...</p>
                                    </div>
                                </div>
                                
                                <hr>
                                
                                <div class="summary-totals">
                                    <div class="summary-row">
                                        <span>Subtotal:</span>
                                        <span id="subtotal">$0.00</span>
                                    </div>
                                    <div class="summary-row">
                                        <span>Shipping:</span>
                                        <span>Free</span>
                                    </div>
                                    <div class="summary-row">
                                        <span>Tax:</span>
                                        <span>Included</span>
                                    </div>
                                    <hr>
                                    <div class="summary-row total">
                                        <span><strong>Total:</strong></span>
                                        <span><strong id="total">$0.00</strong></span>
                                    </div>
                                </div>
                                
                                <div class="mt-4">
                                    <button type="submit" class="btn btn-success btn-lg btn-block" id="place-order-btn">
                                        <i class="fa fa-lock"></i> Place Order
                                    </button>
                                </div>
                                
                                <div class="mt-3">
                                    <a href="<?php echo site_url('website/cart'); ?>" class="btn btn-outline-secondary btn-block">
                                        <i class="fa fa-arrow-left"></i> Back to Cart
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </form>
    </div>
</div>

<style>
.checkout-section .card {
    border: none;
    box-shadow: 0 2px 10px rgba(0,0,0,0.1);
    border-radius: 10px;
}

.checkout-section .card-header {
    background: linear-gradient(45deg, #007bff, #0056b3);
    color: white;
    border-radius: 10px 10px 0 0;
    border: none;
}

.checkout-section .card-header h5 {
    margin: 0;
    font-weight: 600;
}

.form-group label {
    font-weight: 600;
    color: #333;
    margin-bottom: 5px;
}

.form-control {
    border-radius: 8px;
    border: 2px solid #e9ecef;
    padding: 12px 15px;
    transition: all 0.3s ease;
}

.form-control:focus {
    border-color: #007bff;
    box-shadow: 0 0 0 0.2rem rgba(0,123,255,0.25);
}

.form-check-input {
    margin-top: 0.3rem;
}

.form-check-label {
    margin-left: 0.5rem;
}

.order-summary .card {
    position: sticky;
    top: 20px;
    border: none;
    box-shadow: 0 5px 20px rgba(0,0,0,0.1);
    border-radius: 15px;
}

.order-summary .card-header {
    background: linear-gradient(45deg, #28a745, #20c997);
    color: white;
    border-radius: 15px 15px 0 0;
    border: none;
}

.order-item {
    display: flex;
    align-items: center;
    padding: 10px 0;
    border-bottom: 1px solid #f8f9fa;
}

.order-item:last-child {
    border-bottom: none;
}

.order-item-image {
    width: 50px;
    height: 50px;
    object-fit: cover;
    border-radius: 5px;
    margin-right: 15px;
}

.order-item-details {
    flex: 1;
}

.order-item-name {
    font-weight: 600;
    margin-bottom: 5px;
    color: #333;
}

.order-item-qty {
    color: #6c757d;
    font-size: 0.9em;
}

.order-item-price {
    font-weight: 600;
    color: #007bff;
}

.summary-row {
    display: flex;
    justify-content: space-between;
    margin-bottom: 10px;
    padding: 5px 0;
}

.summary-row.total {
    font-size: 1.1em;
    border-top: 2px solid #dee2e6;
    padding-top: 15px;
    margin-top: 15px;
}

.btn-success {
    background: linear-gradient(45deg, #28a745, #20c997);
    border: none;
    border-radius: 25px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.btn-success:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(40, 167, 69, 0.3);
}

.btn-outline-secondary {
    border-radius: 25px;
    font-weight: 600;
}

#place-order-btn:disabled {
    opacity: 0.6;
    cursor: not-allowed;
}
</style>

<script>
$(document).ready(function() {
    loadOrderSummary();
    
    function loadOrderSummary() {
        $.ajax({
            url: '<?php echo site_url("website/get_cart"); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success && response.data.length > 0) {
                    displayOrderSummary(response.data);
                } else {
                    showEmptyCart();
                }
            },
            error: function() {
                showEmptyCart();
            }
        });
    }
    
    function displayOrderSummary(cartData) {
        var html = '';
        var subtotal = 0;
        
        cartData.forEach(function(item) {
            var itemTotal = item.price * item.quantity;
            subtotal += itemTotal;
            
            html += '<div class="order-item">';
            html += '<img src="' + item.image + '" alt="' + item.name + '" class="order-item-image">';
            html += '<div class="order-item-details">';
            html += '<div class="order-item-name">' + item.name + '</div>';
            html += '<div class="order-item-qty">Qty: ' + item.quantity + '</div>';
            html += '</div>';
            html += '<div class="order-item-price">' + formatMoney(itemTotal) + '</div>';
            html += '</div>';
        });
        
        $('#order-items').html(html);
        $('#subtotal').text(formatMoney(subtotal));
        $('#total').text(formatMoney(subtotal));
    }
    
    function showEmptyCart() {
        var html = '<div class="text-center py-4">';
        html += '<i class="fa fa-shopping-cart fa-3x text-muted mb-3"></i>';
        html += '<h5>Your cart is empty</h5>';
        html += '<p class="text-muted">Please add some items to your cart before checkout.</p>';
        html += '<a href="<?php echo site_url("website/products"); ?>" class="btn btn-primary">Continue Shopping</a>';
        html += '</div>';
        
        $('#order-items').html(html);
        $('#place-order-btn').prop('disabled', true);
    }
    
    function formatMoney(amount) {
        return '<?php echo $base_currency->symbol; ?>' + parseFloat(amount).toFixed(2);
    }
    
    // Form validation
    $('#checkout-form').submit(function(e) {
        e.preventDefault();
        
        // Basic validation
        var isValid = true;
        var requiredFields = ['first_name', 'last_name', 'email', 'phone', 'address', 'city', 'state', 'postal_code', 'country', 'payment_method'];
        
        requiredFields.forEach(function(field) {
            var value = $('#' + field).val();
            if (!value || value.trim() === '') {
                $('#' + field).addClass('is-invalid');
                isValid = false;
            } else {
                $('#' + field).removeClass('is-invalid');
            }
        });
        
        if (!isValid) {
            showAlert('Please fill in all required fields', 'error');
            return;
        }
        
        // Submit form
        submitOrder();
    });
    
    function submitOrder() {
        $('#place-order-btn').prop('disabled', true).html('<i class="fa fa-spinner fa-spin"></i> Processing...');
        
        $.ajax({
            url: '<?php echo site_url("website/process_checkout"); ?>',
            type: 'POST',
            data: $('#checkout-form').serialize(),
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAlert('Order placed successfully! Order #' + response.order_id, 'success');
                    setTimeout(function() {
                        window.location.href = '<?php echo site_url("website/orders"); ?>';
                    }, 2000);
                } else {
                    showAlert(response.message || 'Error placing order', 'error');
                    $('#place-order-btn').prop('disabled', false).html('<i class="fa fa-lock"></i> Place Order');
                }
            },
            error: function() {
                showAlert('Error placing order', 'error');
                $('#place-order-btn').prop('disabled', false).html('<i class="fa fa-lock"></i> Place Order');
            }
        });
    }
    
    function showAlert(message, type) {
        var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
        var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999;">' +
                       '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
                       message +
                       '</div>';
        $('body').append(alertHtml);
        
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 5000);
    }
    
    // Remove validation classes on input
    $('input, select, textarea').on('input change', function() {
        $(this).removeClass('is-invalid');
    });
});
</script>

<?php $this->load->view('frontend/includes/footer'); ?>

