<?php defined('BASEPATH') or exit('No direct script access allowed'); ?>
<?php $this->load->view('frontend/includes/header'); ?>

<div class="container-fluid py-5">
    <div class="container">
        <!-- Breadcrumb -->
        <nav aria-label="breadcrumb" class="mb-4">
            <ol class="breadcrumb">
                <li class="breadcrumb-item"><a href="<?php echo site_url('homepage'); ?>">Home</a></li>
                <li class="breadcrumb-item"><a href="<?php echo site_url('website/products'); ?>">Products</a></li>
                <li class="breadcrumb-item"><a href="<?php echo site_url('website/products/1/' . $group_id); ?>"><?php echo htmlspecialchars($group); ?></a></li>
                <li class="breadcrumb-item active" aria-current="page"><?php echo htmlspecialchars($detailt_product->description); ?></li>
            </ol>
        </nav>

        <div class="row">
            <!-- Product Images -->
            <div class="col-lg-6 mb-4">
                <div class="product-gallery">
                    <div class="main-image mb-3">
                        <img src="<?php echo $this->omni_sales_model->get_image_items($detailt_product->id); ?>" 
                             class="img-fluid rounded shadow" 
                             alt="<?php echo htmlspecialchars($detailt_product->description); ?>"
                             id="main-product-image">
                    </div>
                    <!-- Thumbnail images would go here if multiple images available -->
                </div>
            </div>

            <!-- Product Details -->
            <div class="col-lg-6">
                <div class="product-details">
                    <h1 class="product-title h2 mb-3"><?php echo html_entity_decode($detailt_product->description); ?></h1>
                    
                    <div class="product-meta mb-3">
                        <span class="badge badge-info">SKU: <?php echo htmlspecialchars($detailt_product->sku_code); ?></span>
                        <span class="badge badge-secondary">Category: <?php echo htmlspecialchars($group); ?></span>
                    </div>

                    <div class="price-section mb-4">
                        <div class="price h3 text-primary">
                            <?php echo app_format_money($price, $base_currency->name); ?>
                        </div>
                        <div class="text-muted small">
                            Price includes all taxes
                        </div>
                    </div>

                    <div class="product-description mb-4">
                        <h5>Description</h5>
                        <p class="text-muted"><?php echo html_entity_decode($detailt_product->long_description); ?></p>
                    </div>

                    <!-- Stock Status -->
                    <div class="stock-status mb-4">
                        <?php if ($amount_in_stock > 0): ?>
                            <div class="alert alert-success">
                                <i class="fa fa-check-circle"></i> 
                                In Stock (<?php echo $amount_in_stock; ?> available)
                            </div>
                        <?php else: ?>
                            <div class="alert alert-danger">
                                <i class="fa fa-times-circle"></i> Out of Stock
                            </div>
                        <?php endif; ?>
                    </div>

                    <!-- Add to Cart Section -->
                    <?php if ($amount_in_stock > 0): ?>
                        <div class="add-to-cart-section">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="input-group">
                                        <div class="input-group-prepend">
                                            <button class="btn btn-outline-secondary qty-minus" type="button">
                                                <i class="fa fa-minus"></i>
                                            </button>
                                        </div>
                                        <input type="number" 
                                               class="form-control text-center qty-input" 
                                               value="1" 
                                               min="1" 
                                               max="<?php echo $amount_in_stock; ?>"
                                               id="product-quantity">
                                        <div class="input-group-append">
                                            <button class="btn btn-outline-secondary qty-plus" type="button">
                                                <i class="fa fa-plus"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-8">
                                    <button class="btn btn-primary btn-lg btn-block add-to-cart-btn" 
                                            data-id="<?php echo $detailt_product->id; ?>">
                                        <i class="fa fa-shopping-cart"></i> Add to Cart
                                    </button>
                                </div>
                            </div>
                            <div class="row mt-3">
                                <div class="col-12">
                                    <button class="btn btn-success btn-lg btn-block buy-now-btn" 
                                            data-id="<?php echo $detailt_product->id; ?>">
                                        <i class="fa fa-bolt"></i> Buy Now
                                    </button>
                                </div>
                            </div>
                        </div>
                    <?php else: ?>
                        <div class="alert alert-warning">
                            <i class="fa fa-exclamation-triangle"></i>
                            This product is currently out of stock. Please check back later.
                        </div>
                    <?php endif; ?>

                    <!-- Product Features -->
                    <div class="product-features mt-5">
                        <h5>Why Choose This Product?</h5>
                        <ul class="list-unstyled">
                            <li><i class="fa fa-check text-success mr-2"></i> Fresh baked daily</li>
                            <li><i class="fa fa-check text-success mr-2"></i> Premium ingredients</li>
                            <li><i class="fa fa-check text-success mr-2"></i> Artisan crafted</li>
                            <li><i class="fa fa-check text-success mr-2"></i> Quality guaranteed</li>
                        </ul>
                    </div>
                </div>
            </div>
        </div>

        <!-- Related Products -->
        <?php if (!empty($product)): ?>
            <div class="row mt-5">
                <div class="col-12">
                    <h3 class="mb-4">Related Products</h3>
                    <div class="row">
                        <?php foreach ($product as $item): ?>
                            <div class="col-lg-3 col-md-4 col-sm-6 mb-4">
                                <div class="card product-card h-100 shadow-sm">
                                    <div class="product-image">
                                        <a href="<?php echo site_url('website/product/' . $item['id']); ?>">
                                            <img src="<?php echo $item['image']; ?>" 
                                                 class="card-img-top" 
                                                 alt="<?php echo htmlspecialchars($item['name']); ?>"
                                                 style="height: 200px; object-fit: cover;">
                                        </a>
                                    </div>
                                    <div class="card-body d-flex flex-column">
                                        <h6 class="card-title">
                                            <a href="<?php echo site_url('website/product/' . $item['id']); ?>" class="text-decoration-none">
                                                <?php echo html_entity_decode($item['name']); ?>
                                            </a>
                                        </h6>
                                        <div class="price mt-auto">
                                            <span class="text-primary font-weight-bold">
                                                <?php echo app_format_money($item['price'], $base_currency->name); ?>
                                            </span>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        <?php endforeach; ?>
                    </div>
                </div>
            </div>
        <?php endif; ?>
    </div>
</div>

<style>
.product-gallery .main-image img {
    width: 100%;
    height: 400px;
    object-fit: cover;
    border-radius: 10px;
}

.product-title {
    color: #333;
    font-weight: 700;
}

.price-section .price {
    font-weight: 700;
    margin-bottom: 0;
}

.add-to-cart-section .input-group {
    margin-bottom: 0;
}

.qty-input {
    border-left: none;
    border-right: none;
}

.qty-minus,
.qty-plus {
    border-radius: 0;
}

.add-to-cart-btn,
.buy-now-btn {
    border-radius: 25px;
    font-weight: 600;
    transition: all 0.3s ease;
}

.add-to-cart-btn:hover,
.buy-now-btn:hover {
    transform: translateY(-2px);
    box-shadow: 0 5px 15px rgba(0,0,0,0.2);
}

.product-card {
    transition: transform 0.3s ease, box-shadow 0.3s ease;
    border: none;
    border-radius: 10px;
    overflow: hidden;
}

.product-card:hover {
    transform: translateY(-3px);
    box-shadow: 0 8px 20px rgba(0,0,0,0.1) !important;
}

.breadcrumb {
    background: none;
    padding: 0;
}

.breadcrumb-item a {
    color: #007bff;
    text-decoration: none;
}

.breadcrumb-item a:hover {
    text-decoration: underline;
}

.product-features ul li {
    padding: 0.25rem 0;
}

.stock-status .alert {
    border-radius: 10px;
    border: none;
}

.badge {
    font-size: 0.9em;
    padding: 0.5em 0.75em;
}
</style>

<script>
$(document).ready(function() {
    // Quantity controls
    $('.qty-minus').click(function() {
        var input = $('#product-quantity');
        var currentVal = parseInt(input.val());
        if (currentVal > 1) {
            input.val(currentVal - 1);
        }
    });

    $('.qty-plus').click(function() {
        var input = $('#product-quantity');
        var currentVal = parseInt(input.val());
        var maxVal = parseInt(input.attr('max'));
        if (currentVal < maxVal) {
            input.val(currentVal + 1);
        }
    });

    // Add to cart functionality
    $('.add-to-cart-btn').click(function() {
        var productId = $(this).data('id');
        var quantity = $('#product-quantity').val();
        
        addToCart(productId, quantity);
    });

    // Buy now functionality
    $('.buy-now-btn').click(function() {
        var productId = $(this).data('id');
        var quantity = $('#product-quantity').val();
        
        // Add to cart first, then redirect to checkout
        addToCart(productId, quantity, function() {
            window.location.href = '<?php echo site_url("website/checkout"); ?>';
        });
    });

    // Add to cart function
    function addToCart(productId, quantity, callback) {
        $.ajax({
            url: '<?php echo site_url("website/add_to_cart"); ?>',
            type: 'POST',
            data: {
                product_id: productId,
                quantity: quantity
            },
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    showAlert('Product added to cart!', 'success');
                    updateCartCount();
                    if (callback) callback();
                } else {
                    showAlert(response.message || 'Error adding product to cart', 'error');
                }
            },
            error: function() {
                showAlert('Error adding product to cart', 'error');
            }
        });
    }

    // Show alert function
    function showAlert(message, type) {
        var alertClass = type === 'success' ? 'alert-success' : 'alert-danger';
        var alertHtml = '<div class="alert ' + alertClass + ' alert-dismissible fade show position-fixed" style="top: 20px; right: 20px; z-index: 9999;">' +
                       '<button type="button" class="close" data-dismiss="alert">&times;</button>' +
                       message +
                       '</div>';
        $('body').append(alertHtml);
        
        setTimeout(function() {
            $('.alert').fadeOut();
        }, 3000);
    }

    // Update cart count
    function updateCartCount() {
        $.ajax({
            url: '<?php echo site_url("website/get_cart_count"); ?>',
            type: 'GET',
            dataType: 'json',
            success: function(response) {
                if (response.success) {
                    // Update cart count in header if exists
                    $('.cart-count').text(response.count);
                }
            }
        });
    }
});
</script>

<?php $this->load->view('frontend/includes/footer'); ?>

