<?php
// Basic test to check if the issue is with CodeIgniter or the specific controller
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Testing basic CodeIgniter functionality...\n";

try {
    // Test 1: Load CodeIgniter
    require_once('index.php');
    echo "✓ CodeIgniter loaded\n";
    
    // Test 2: Create CI instance
    $CI =& get_instance();
    echo "✓ CI instance created\n";
    
    // Test 3: Test basic controller
    class TestController extends CI_Controller {
        public function test() {
            echo "✓ Test controller method works\n";
        }
    }
    
    $test = new TestController();
    $test->test();
    
    // Test 4: Test if we can load a simple view
    $CI->load->view('frontend/includes/header');
    echo "✓ Header view loaded\n";
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "Test completed.\n";
?>

