<?php
// Test script to debug products page
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Include CodeIgniter
require_once('index.php');

try {
    echo "Testing products controller...\n";
    
    // Test the controller directly
    $CI =& get_instance();
    $CI->load->model('omni_sales_model');
    
    echo "Model loaded successfully\n";
    
    // Test get_products_direct method
    $controller = new Website_frontend();
    $products = $controller->get_products_direct(0, 5);
    
    echo "Products found: " . count($products) . "\n";
    
    if (count($products) > 0) {
        echo "First product: " . $products[0]['name'] . "\n";
        echo "First product image: " . $products[0]['image'] . "\n";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}
?>

