<?php
// Direct test to see what products are in the database
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "<h1>Direct Database Products Test</h1>";

try {
    require_once('index.php');
    $CI =& get_instance();
    
    // Direct query to get all products
    $CI->db->select('id, description, long_description, rate, sku_code, group_id');
    $CI->db->from('tblitems');
    $CI->db->where('rate >', 0);
    $CI->db->limit(10);
    $query = $CI->db->get();
    $products = $query->result_array();
    
    echo "<h2>Found " . count($products) . " products in database:</h2>";
    
    foreach ($products as $product) {
        echo "<div style='border: 1px solid #ccc; margin: 10px; padding: 10px;'>";
        echo "<h3>ID: {$product['id']} - {$product['description']}</h3>";
        echo "<p>Price: {$product['rate']}</p>";
        echo "<p>SKU: {$product['sku_code']}</p>";
        echo "<p>Group ID: {$product['group_id']}</p>";
        
        // Test image loading
        $CI->load->model('omni_sales_model');
        $image = $CI->omni_sales_model->get_image_items($product['id']);
        echo "<p>Image: <img src='$image' style='width: 100px; height: 60px; object-fit: cover;'></p>";
        echo "</div>";
    }
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage() . "<br>";
    echo "File: " . $e->getFile() . "<br>";
    echo "Line: " . $e->getLine() . "<br>";
}

echo "<p>Test completed.</p>";
?>

