<?php
// Test with minimal products view
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Testing minimal products page...\n";

try {
    // Test 1: Load CodeIgniter
    require_once('index.php');
    echo "✓ CodeIgniter loaded\n";
    
    // Test 2: Create controller
    $CI =& get_instance();
    $controller = new Website_frontend();
    echo "✓ Controller created\n";
    
    // Test 3: Test with minimal data
    $data = [
        'title' => 'Test Products',
        'page_title' => 'Test',
        'products' => [
            [
                'id' => 1,
                'name' => 'Test Product',
                'price' => 10.00,
                'image' => 'https://via.placeholder.com/300x200',
                'category' => 'Test',
                'description' => 'Test description',
                'rating' => 4.5,
                'reviews' => 100,
                'w_quantity' => 10
            ]
        ],
        'categories' => ['All Products', 'Test'],
        'base_currency' => (object)['name' => 'USD', 'symbol' => '$'],
        'current_page' => 1,
        'per_page' => 20,
        'total_products' => 1,
        'total_pages' => 1
    ];
    
    echo "✓ Test data created\n";
    
    // Test 4: Try to load the view
    ob_start();
    $CI->load->view('frontend/products', $data);
    $output = ob_get_clean();
    
    echo "✓ View loaded successfully\n";
    echo "Output length: " . strlen($output) . " characters\n";
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
    echo "Stack trace:\n" . $e->getTraceAsString() . "\n";
}

echo "Test completed.\n";
?>

