<?php
// Very simple test to check if the issue is with the view
error_reporting(E_ALL);
ini_set('display_errors', 1);

echo "Testing products page step by step...\n";

// Test 1: Basic PHP
echo "✓ PHP is working\n";

// Test 2: Check if we can include the view file
try {
    $data = [
        'title' => 'Test Products',
        'page_title' => 'Test',
        'products' => [
            [
                'id' => 1,
                'name' => 'Test Product',
                'price' => 10.00,
                'image' => 'https://via.placeholder.com/300x200',
                'category' => 'Test',
                'description' => 'Test description'
            ]
        ],
        'categories' => ['All Products', 'Test'],
        'total_products' => 1,
        'current_page' => 1,
        'total_pages' => 1,
        'base_currency' => (object)['name' => 'USD', 'symbol' => '$']
    ];
    
    echo "✓ Test data created\n";
    
    // Test if we can load the view
    ob_start();
    include('application/views/frontend/products.php');
    $output = ob_get_clean();
    
    echo "✓ View loaded successfully\n";
    echo "Output length: " . strlen($output) . " characters\n";
    
} catch (Exception $e) {
    echo "✗ View error: " . $e->getMessage() . "\n";
    echo "File: " . $e->getFile() . "\n";
    echo "Line: " . $e->getLine() . "\n";
}

echo "Test completed.\n";
?>