defmodule DaProductApp.Repo.Migrations.CreateCustomEvents do
  use Ecto.Migration

  def change do
    execute("""
    CREATE TABLE custom_events (
      id BIGINT AUTO_INCREMENT PRIMARY KEY,
      is_published BOOLEAN NOT NULL,
      date_added DATETIME,
      created_by BINARY(16),
      created_by_user VARCHAR(255),
      date_modified DATETIME,
      modified_by BINARY(16),
      modified_by_user VARCHAR(255),
      checked_out DATETIME,
      checked_out_by INT,
      checked_out_by_user VARCHAR(255),
      name VARCHAR(255) NOT NULL,
      alias VARCHAR(255) NOT NULL,
      payloads TEXT NOT NULL,
      idgoal VARCHAR(255),
      discription VARCHAR(255),
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL,
      UNIQUE (idgoal)
    ) ENGINE=InnoDB
    """)
  end
end
