defmodule DaProductApp.Repo.Migrations.CreatePosTerminals do
  use Ecto.Migration

  def up do
    execute("""
    CREATE TABLE pos_terminals (
      id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
      name VARCHAR(255) NOT NULL,
      serial_number VARCHAR(255) NOT NULL,
      device_type VARCHAR(255) NOT NULL,
      neo_terminal_id VARCHAR(255),
      store_id BIGINT UNSIGNED NOT NULL,
      provider_id BIGINT UNSIGNED NOT NULL,
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL,
      CONSTRAINT fk_store FOREIGN KEY (store_id) REFERENCES stores(id) ON DELETE CASCADE,
      CONSTRAINT fk_pos_terminals_provider FOREIGN KEY (provider_id) REFERENCES providers(id) ON DELETE CASCADE
    ) ENGINE=InnoDB
    """)
  end

  def down do
    execute("DROP TABLE IF EXISTS pos_terminals")
  end
end
