defmodule DaProductApp.Repo.Migrations.CreateMerchantEnrollments do
  use Ecto.Migration

  def change do
    execute """
    CREATE TABLE merchant_enrollments (
      id BIGINT UNSIGNED NOT NULL AUTO_INCREMENT PRIMARY KEY,
      provider VARCHAR(255),
      registration_params JSON,
      registration_response JSON,
      inquiry_history JSON,
      products JSON,
      status VARCHAR(255),
      group_id BIGINT,
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL,
      CONSTRAINT merchant_enrollments_group_id_fkey FOREIGN KEY (group_id) REFERENCES `groups`(id),
      INDEX merchant_enrollments_group_id_index (group_id)
    ) ENGINE=InnoDB
    """, "DROP TABLE IF EXISTS merchant_enrollments"
  end
end

