defmodule DaProductApp.Repo.Migrations.CreateYspConfigurations do
  use Ecto.Migration

  def up do
    execute("""
    CREATE TABLE ysp_configurations (
      id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
      merchant_id VARCHAR(255) NOT NULL,
      notification_url VARCHAR(500) NOT NULL,
      merchant_tag VARCHAR(255),
      bank_user_id VARCHAR(255),
      terminal_id VARCHAR(255),
      shop_id VARCHAR(255),
      cash_desk_id VARCHAR(255),
      max_retry_attempts INT DEFAULT 3,
      retry_interval_seconds INT DEFAULT 30,
      is_active BOOLEAN DEFAULT TRUE,
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL,
      UNIQUE KEY unique_merchant_id (merchant_id),
      INDEX idx_merchant_id (merchant_id),
      INDEX idx_active (is_active)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    """)

    # Insert default configuration
    execute("""
    INSERT INTO ysp_configurations (
      merchant_id,
      notification_url,
      merchant_tag,
      bank_user_id,
      terminal_id,
      shop_id,
      cash_desk_id,
      max_retry_attempts,
      retry_interval_seconds,
      is_active,
      inserted_at,
      updated_at
    ) VALUES (
      'default',
      'http://testapp.ariticapp.com/prasanna/raqmiyatresponse.php',
      'UB776WH',
      'MERCURY_ALIPAY123',
      '900890089008900',
      'SHOP001',
      'DEV00010002',
      3,
      30,
      TRUE,
      NOW(),
      NOW()
    )
    """)
  end

  def down do
    execute("DROP TABLE IF EXISTS ysp_configurations")
  end
end