defmodule DaProductApp.Repo.Migrations.CreateTransactions do
  use Ecto.Migration

  def up do
    execute("""
    CREATE TABLE transactions (
      id BIGINT UNSIGNED AUTO_INCREMENT PRIMARY KEY,
      patient_name VARCHAR(255),
      uhid VARCHAR(255),
      charge_rate DECIMAL(10,2),
      email VARCHAR(255),
      mobile_no VARCHAR(255),
      processing_id VARCHAR(255),
      uname VARCHAR(255),
      user_id VARCHAR(255) DEFAULT '1',
      pay_mode VARCHAR(255),
      location_id VARCHAR(255),
      transaction_location VARCHAR(255),
      credentials_user VARCHAR(255),
      credentials_key VARCHAR(255),
      version VARCHAR(255),
      return_url VARCHAR(255),
      response_url VARCHAR(255),
      status VARCHAR(255) DEFAULT 'pending',
      transaction_id VARCHAR(255),
      transaction_amount DECIMAL(10,2),
      transaction_ref_number VARCHAR(255),
      m_ref_num VARCHAR(255),
      name VARCHAR(255),
      provider_id BIGINT UNSIGNED,
      device_id VARCHAR(255),
      merchant_id VARCHAR(255),
      additional_data JSON,
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL,
      INDEX idx_processing_id (processing_id),
      INDEX idx_transaction_ref (transaction_ref_number),
      INDEX idx_provider (provider_id),
      INDEX idx_merchant_id (merchant_id)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci
    """)
  end

  def down do
    execute("DROP TABLE IF EXISTS transactions")
  end
end
