defmodule DaProductApp.Repo.Migrations.CreateCustomTransactionLog do
  use Ecto.Migration

  def up do
    execute("""
    CREATE TABLE custom_transaction_log (
      id BIGINT AUTO_INCREMENT PRIMARY KEY, -- Auto-increment ID
      initiateRefrenceNumber VARCHAR(255) NOT NULL,
      merchanteRefrenceNumber VARCHAR(255) NOT NULL,
      deviceId VARCHAR(255) NOT NULL,
      amount VARCHAR(255) NOT NULL,
      status VARCHAR(255) NOT NULL,
      payloads JSON, -- JSON for map type
      date_added DATETIME NOT NULL,
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL
    ) ENGINE=InnoDB
    """)
  end

  def down do
    execute("DROP TABLE IF EXISTS custom_transaction_log")
  end
end
