defmodule DaProductApp.Repo.Migrations.CreateGroups do
  use Ecto.Migration

  def change do
    execute("""
    CREATE TABLE `groups` (
      id BIGINT AUTO_INCREMENT PRIMARY KEY,
      name VARCHAR(255) NOT NULL,
      code VARCHAR(255) NOT NULL,
      description VARCHAR(255) DEFAULT NULL,
      status VARCHAR(255) DEFAULT 'active',
      inserted_at DATETIME NOT NULL,
      updated_at DATETIME NOT NULL,
      UNIQUE KEY groups_code_index (code)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4
    """)
  end
end

