defmodule DaProductApp.Repo.Migrations.AddGroupIdToBrands do
  use Ecto.Migration

  def change do
    # First add the column
    execute("ALTER TABLE brands ADD COLUMN group_id BIGINT")

    # Then add the foreign key constraint
    execute("""
    ALTER TABLE brands
    ADD CONSTRAINT fk_brands_group
    FOREIGN KEY (group_id) REFERENCES `groups`(id)
    ON DELETE SET NULL
    """)
  end

  def down do
    execute("ALTER TABLE brands DROP FOREIGN KEY fk_brands_group")
    execute("ALTER TABLE brands DROP COLUMN group_id")
  end
end

