import BaseAgGridHook from '../base/BaseAgGridHook';

export default {
  ...BaseAgGridHook,
  mounted() {
    const config = {
      columnDefs: [
        { headerName: "Serial Number", field: "serial_number" },
        { headerName: "OID", field: "oid" },
        { headerName: "Last Status", field: "last_status" },
        { headerName: "Last Seen", field: "last_seen_at" }
      ],
      rowData: JSON.parse(this.el.dataset.rows || '[]'),
      onRowClicked: event => {
        // Push event to LiveView with serial_number
        this.pushEvent(this.el.dataset.rowClickEvent || "show_terminal_details", {
          serial_number: event.data.serial_number
        });
      }
    };
    this.setupGrid(config);
  }
}
