import "./chunk-LK32TJAX.js";

// node_modules/currency.js/dist/currency.es.js
var defaults = {
  symbol: "$",
  separator: ",",
  decimal: ".",
  errorOnInvalid: false,
  precision: 2,
  pattern: "!#",
  negativePattern: "-!#",
  format,
  fromCents: false
};
var round = function round2(v) {
  return Math.round(v);
};
var pow = function pow2(p) {
  return Math.pow(10, p);
};
var rounding = function rounding2(value, increment) {
  return round(value / increment) * increment;
};
var groupRegex = /(\d)(?=(\d{3})+\b)/g;
var vedicRegex = /(\d)(?=(\d\d)+\d\b)/g;
function currency(value, opts) {
  var that = this;
  if (!(that instanceof currency)) {
    return new currency(value, opts);
  }
  var settings = Object.assign({}, defaults, opts), precision = pow(settings.precision), v = parse(value, settings);
  that.intValue = v;
  that.value = v / precision;
  settings.increment = settings.increment || 1 / precision;
  if (settings.useVedic) {
    settings.groups = vedicRegex;
  } else {
    settings.groups = groupRegex;
  }
  this.s = settings;
  this.p = precision;
}
function parse(value, opts) {
  var useRounding = arguments.length > 2 && arguments[2] !== void 0 ? arguments[2] : true;
  var v = 0, decimal = opts.decimal, errorOnInvalid = opts.errorOnInvalid, decimals = opts.precision, fromCents = opts.fromCents, precision = pow(decimals), isNumber = typeof value === "number", isCurrency = value instanceof currency;
  if (isCurrency && fromCents) {
    return value.intValue;
  }
  if (isNumber || isCurrency) {
    v = isCurrency ? value.value : value;
  } else if (typeof value === "string") {
    var regex = new RegExp("[^-\\d" + decimal + "]", "g"), decimalString = new RegExp("\\" + decimal, "g");
    v = value.replace(/\((.*)\)/, "-$1").replace(regex, "").replace(decimalString, ".");
    v = v || 0;
  } else {
    if (errorOnInvalid) {
      throw Error("Invalid Input");
    }
    v = 0;
  }
  if (!fromCents) {
    v *= precision;
    v = v.toFixed(4);
  }
  return useRounding ? round(v) : v;
}
function format(currency2, settings) {
  var pattern = settings.pattern, negativePattern = settings.negativePattern, symbol = settings.symbol, separator = settings.separator, decimal = settings.decimal, groups = settings.groups, split = ("" + currency2).replace(/^-/, "").split("."), dollars2 = split[0], cents2 = split[1];
  return (currency2.value >= 0 ? pattern : negativePattern).replace("!", symbol).replace("#", dollars2.replace(groups, "$1" + separator) + (cents2 ? decimal + cents2 : ""));
}
currency.prototype = {
  /**
   * Adds values together.
   * @param {number} number
   * @returns {currency}
   */
  add: function add(number) {
    var intValue = this.intValue, _settings = this.s, _precision = this.p;
    return currency((intValue += parse(number, _settings)) / (_settings.fromCents ? 1 : _precision), _settings);
  },
  /**
   * Subtracts value.
   * @param {number} number
   * @returns {currency}
   */
  subtract: function subtract(number) {
    var intValue = this.intValue, _settings = this.s, _precision = this.p;
    return currency((intValue -= parse(number, _settings)) / (_settings.fromCents ? 1 : _precision), _settings);
  },
  /**
   * Multiplies values.
   * @param {number} number
   * @returns {currency}
   */
  multiply: function multiply(number) {
    var intValue = this.intValue, _settings = this.s;
    return currency((intValue *= number) / (_settings.fromCents ? 1 : pow(_settings.precision)), _settings);
  },
  /**
   * Divides value.
   * @param {number} number
   * @returns {currency}
   */
  divide: function divide(number) {
    var intValue = this.intValue, _settings = this.s;
    return currency(intValue /= parse(number, _settings, false), _settings);
  },
  /**
   * Takes the currency amount and distributes the values evenly. Any extra pennies
   * left over from the distribution will be stacked onto the first set of entries.
   * @param {number} count
   * @returns {array}
   */
  distribute: function distribute(count) {
    var intValue = this.intValue, _precision = this.p, _settings = this.s, distribution = [], split = Math[intValue >= 0 ? "floor" : "ceil"](intValue / count), pennies = Math.abs(intValue - split * count), precision = _settings.fromCents ? 1 : _precision;
    for (; count !== 0; count--) {
      var item = currency(split / precision, _settings);
      pennies-- > 0 && (item = item[intValue >= 0 ? "add" : "subtract"](1 / precision));
      distribution.push(item);
    }
    return distribution;
  },
  /**
   * Returns the dollar value.
   * @returns {number}
   */
  dollars: function dollars() {
    return ~~this.value;
  },
  /**
   * Returns the cent value.
   * @returns {number}
   */
  cents: function cents() {
    var intValue = this.intValue, _precision = this.p;
    return ~~(intValue % _precision);
  },
  /**
   * Formats the value as a string according to the formatting settings.
   * @param {boolean} useSymbol - format with currency symbol
   * @returns {string}
   */
  format: function format2(options) {
    var _settings = this.s;
    if (typeof options === "function") {
      return options(this, _settings);
    }
    return _settings.format(this, Object.assign({}, _settings, options));
  },
  /**
   * Formats the value as a string according to the formatting settings.
   * @returns {string}
   */
  toString: function toString() {
    var intValue = this.intValue, _precision = this.p, _settings = this.s;
    return rounding(intValue / _precision, _settings.increment).toFixed(_settings.precision);
  },
  /**
   * Value for JSON serialization.
   * @returns {float}
   */
  toJSON: function toJSON() {
    return this.value;
  }
};
var currency_es_default = currency;
export {
  currency_es_default as default
};
/*! Bundled license information:

currency.js/dist/currency.es.js:
  (*!
   * currency.js - v2.0.4
   * http://scurker.github.io/currency.js
   *
   * Copyright (c) 2021 Jason Wilson
   * Released under MIT license
   *)
*/
//# sourceMappingURL=currency__js.js.map
